/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.parser.annotation;

import java.lang.reflect.Method;
import osmo.common.log.Logger;
import osmo.tester.annotation.Group;
import osmo.tester.annotation.Post;
import osmo.tester.model.FSM;
import osmo.tester.model.InvocationTarget;
import osmo.tester.model.TransitionName;
import osmo.tester.parser.AnnotationParser;
import osmo.tester.parser.ParserParameters;
import osmo.tester.parser.ParserResult;
import osmo.tester.parser.annotation.GuardParser;

public class PostParser
implements AnnotationParser {
    private static final Logger log = new Logger(PostParser.class);

    @Override
    public String parse(ParserResult result, ParserParameters parameters) {
        Post post = (Post)parameters.getAnnotation();
        Method method = parameters.getMethod();
        String errors = "";
        String aName = "@" + Post.class.getSimpleName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 0) {
            errors = errors + aName + " methods are not allowed to have any parameters: \"" + method.getName() + "()\" has " + parameterTypes.length + ".\n";
        }
        InvocationTarget target = new InvocationTarget(parameters, Post.class);
        FSM fsm = result.getFsm();
        String[] targetNames = post.value();
        String prefix = parameters.getPrefix();
        String group = parameters.getClassAnnotation(Group.class);
        for (String targetName : targetNames) {
            log.d("Parsing post '" + targetName + "'");
            if (targetName.equals("osmo.tester.annotations.DEFAULT_VALUE")) {
                if (group.length() > 0) {
                    targetName = group;
                } else {
                    String methodName = parameters.getMethod().getName();
                    targetName = GuardParser.findNameFrom(methodName);
                    if (targetName.length() == 0) {
                        String msg = aName + " method name must be of format xX when using method based naming: " + methodName;
                        msg = msg + ". Or if using generic association, name \"all\" must be used.\n";
                        errors = errors + msg;
                    }
                }
            }
            if (targetName.equals("all")) {
                fsm.addGenericPost(target);
                log.d("added generic post:" + targetName);
                continue;
            }
            TransitionName tName = new TransitionName(prefix, targetName);
            log.d("created specific post:" + targetName);
            fsm.addSpecificPost(tName, target);
        }
        return errors;
    }
}

