/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.parser.annotation;

import java.lang.reflect.Method;
import osmo.common.log.Logger;
import osmo.tester.annotation.Group;
import osmo.tester.annotation.Pre;
import osmo.tester.model.FSM;
import osmo.tester.model.InvocationTarget;
import osmo.tester.model.TransitionName;
import osmo.tester.parser.AnnotationParser;
import osmo.tester.parser.ParserParameters;
import osmo.tester.parser.ParserResult;
import osmo.tester.parser.annotation.GuardParser;

public class PreParser
implements AnnotationParser {
    private static final Logger log = new Logger(PreParser.class);

    @Override
    public String parse(ParserResult result, ParserParameters parameters) {
        Pre pre = (Pre)parameters.getAnnotation();
        Method method = parameters.getMethod();
        String errors = "";
        Class<?>[] parameterTypes = method.getParameterTypes();
        String aName = "@" + Pre.class.getSimpleName();
        if (parameterTypes.length > 0) {
            errors = errors + aName + " methods are not allowed to have parameters: \"" + method.getName() + "()\" has " + parameterTypes.length + " parameters.\n";
        }
        InvocationTarget target = new InvocationTarget(parameters, Pre.class);
        FSM fsm = result.getFsm();
        String[] targetNames = pre.value();
        String prefix = parameters.getPrefix();
        String group = parameters.getClassAnnotation(Group.class);
        for (String targetName : targetNames) {
            log.d("Parsing pre-method '" + targetName + "'");
            if (targetName.equals("osmo.tester.annotations.DEFAULT_VALUE")) {
                if (group.length() > 0) {
                    targetName = group;
                } else {
                    String methodName = parameters.getMethod().getName();
                    targetName = GuardParser.findNameFrom(methodName);
                    if (targetName.length() == 0) {
                        String msg = aName + " method name must be of format xX when using method based naming: " + methodName;
                        msg = msg + ". Or if using generic association, name \"all\" must be used.\n";
                        errors = errors + msg;
                    }
                }
            }
            if (targetName.equals("all")) {
                fsm.addGenericPre(target);
                continue;
            }
            TransitionName tName = new TransitionName(prefix, targetName);
            fsm.addSpecificPre(tName, target);
        }
        return errors;
    }
}

