/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.parser.annotation;

import java.lang.reflect.Method;
import osmo.common.log.Logger;
import osmo.tester.annotation.Group;
import osmo.tester.annotation.TestStep;
import osmo.tester.model.FSMTransition;
import osmo.tester.model.InvocationTarget;
import osmo.tester.model.TransitionName;
import osmo.tester.parser.AnnotationParser;
import osmo.tester.parser.ParserParameters;
import osmo.tester.parser.ParserResult;

public class TestStepParser
implements AnnotationParser {
    private static final Logger log = new Logger(TestStepParser.class);
    private String errors = "";

    @Override
    public String parse(ParserResult result, ParserParameters parameters) {
        this.errors = "";
        String type = "";
        Object annotation = parameters.getAnnotation();
        String name = null;
        int weight = 0;
        String group = parameters.getClassAnnotation(Group.class);
        TestStep ts = (TestStep)annotation;
        name = ts.name();
        if (name.length() == 0) {
            name = ts.value();
        }
        weight = ts.weight();
        if (ts.group().length() > 0) {
            group = ts.group();
        }
        type = TestStep.class.getSimpleName();
        if (name.length() == 0) {
            name = TestStepParser.parseName(parameters.getMethod().getName());
        }
        TransitionName tName = this.checkName(name, result, parameters);
        TransitionName groupName = new TransitionName(parameters.getPrefix(), group);
        if (tName == null) {
            return this.errors;
        }
        this.createTransition(result, parameters, tName, weight, groupName);
        Method method = parameters.getMethod();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 0) {
            this.errors = this.errors + "@" + type + " methods are not allowed to have parameters: \"" + method.getName() + "()\" has " + parameterTypes.length + " parameters.\n";
        }
        return this.errors;
    }

    private TransitionName checkName(String name, ParserResult result, ParserParameters parameters) {
        if (name.length() == 0) {
            this.errors = this.errors + "Test step must have a name. Define the \"name\" or \"value\" property.\n";
            return null;
        }
        if (name.equals("all")) {
            this.errors = this.errors + "Test step name \"all\" is reserved. Choose another.\n";
            return null;
        }
        String prefix = parameters.getPrefix();
        TransitionName tName = new TransitionName(prefix, name);
        if (result.getFsm().getTransition(tName) != null) {
            this.errors = this.errors + "Test step name must be unique. '" + tName + "' given several times.\n";
            return null;
        }
        return tName;
    }

    private void createTransition(ParserResult result, ParserParameters parameters, TransitionName name, int weight, TransitionName group) {
        log.d("creating transition:" + name);
        FSMTransition transition = result.getFsm().createTransition(name, weight);
        transition.setTransition(new InvocationTarget(parameters, TestStep.class));
        transition.setGroupName(group);
    }

    public static String parseName(String name) {
        name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        return name;
    }
}

