/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.parser.annotation;

import java.lang.reflect.Field;
import osmo.common.log.Logger;
import osmo.tester.annotation.Variable;
import osmo.tester.model.VariableField;
import osmo.tester.parser.AnnotationParser;
import osmo.tester.parser.ParserParameters;
import osmo.tester.parser.ParserResult;

public class VariableParser
implements AnnotationParser {
    private static final Logger log = new Logger(VariableParser.class);

    @Override
    public String parse(ParserResult result, ParserParameters parameters) {
        String errors = "";
        String annotationName = "@" + Variable.class.getSimpleName();
        Field field = parameters.getField();
        field.setAccessible(true);
        Object model = parameters.getModel();
        Variable annotation = (Variable)parameters.getAnnotation();
        String name = annotation.value();
        VariableField var = new VariableField(model, field, name);
        Object o = null;
        try {
            o = field.get(model);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to check variable type for " + field.getName(), e);
        }
        result.getFsm().addModelVariable(var);
        log.d("Parsed variable:" + annotationName);
        return errors;
    }
}

