/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.parser.field;

import java.lang.reflect.Field;
import osmo.common.log.Logger;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.data.SearchableInput;
import osmo.tester.parser.AnnotationParser;
import osmo.tester.parser.ParserParameters;
import osmo.tester.parser.ParserResult;

public class TestSuiteParser
implements AnnotationParser {
    private static final Logger log = new Logger(TestSuiteParser.class);

    @Override
    public String parse(ParserResult result, ParserParameters parameters) {
        log.d("TestSuite parser processing");
        String errors = "";
        Field field = parameters.getField();
        field.setAccessible(true);
        String name = SearchableInput.class.getSimpleName();
        Object model = parameters.getModel();
        try {
            TestSuite suite = (TestSuite)field.get(model);
            if (suite != null) {
                errors = errors + name + " value was not null, which is not allowed.\n";
                return errors;
            }
            suite = parameters.getSuite();
            field.set(model, suite);
            log.d("Value is now set to: " + suite);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to parse/set " + field.getName(), e);
        }
        return errors;
    }
}

