/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.reporting.coverage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import osmo.tester.coverage.TestCoverage;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.model.FSM;
import osmo.tester.model.FSMTransition;
import osmo.tester.reporting.coverage.CoverageMetric;
import osmo.tester.reporting.coverage.ValueCount;

public class ASCIICoverageReporter
extends CoverageMetric {
    public ASCIICoverageReporter(TestCoverage tc, Collection<TestCase> tests, FSM fsm) {
        super(tc, tests, fsm);
    }

    public String getStepCounts() {
        List<ValueCount> coverage = this.countSteps();
        int longest = 0;
        for (ValueCount tc : coverage) {
            if (tc.getValue().length() <= longest) continue;
            longest = tc.getValue().length();
        }
        String ret = "";
        for (ValueCount t : coverage) {
            ret = ret + t.getValue();
            ret = ret + this.getSpaces(longest - t.getValue().length() + 2);
            ret = ret + t.getCount() + "\n";
        }
        return ret;
    }

    private String getSpaces(int a) {
        String ret = "";
        for (int i = 0; i < a; ++i) {
            ret = ret + " ";
        }
        return ret;
    }

    public String getStepPairCounts() {
        List<ValueCount> tpc = this.countStepPairs();
        Collections.sort(tpc);
        int max = 0;
        for (ValueCount t : tpc) {
            int length = t.getValue().length();
            if (length <= max) continue;
            max = length;
        }
        String ret = "";
        for (ValueCount t : tpc) {
            ret = ret + t.getValue();
            ret = ret + this.getSpaces(max - t.getValue().length() + 2);
            ret = ret + t.getCount() + "\n";
        }
        return ret;
    }

    public String getRequirementCounts() {
        return "";
    }

    public String getTraceabilityMatrix() {
        Collection<FSMTransition> transitions = this.fsm.getTransitions();
        ArrayList<String> all = new ArrayList<String>();
        for (FSMTransition fSMTransition : transitions) {
            all.add(fSMTransition.getStringName());
        }
        int max = 0;
        for (String t : all) {
            if (t.length() <= max) continue;
            max = t.length();
        }
        String string = "Coverage\\TC";
        String ret = string + this.getSpaces(max - string.length() + 2);
        for (int i = 0; i < this.tests.size(); ++i) {
            ret = ret + "|" + i;
        }
        ret = ret + "|\n";
        for (String t : all) {
            ret = ret + t + this.getSpaces(max - t.length() + 2);
            for (TestCase tc : this.tests) {
                Collection<String> temp = tc.getCoveredSteps();
                if (temp.contains(t)) {
                    ret = ret + "|x";
                    continue;
                }
                ret = ret + "| ";
            }
            ret = ret + "|\n";
        }
        return ret;
    }
}

