/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.reporting.coverage;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import osmo.tester.coverage.TestCoverage;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.generator.testsuite.TestCaseStep;
import osmo.tester.model.FSM;
import osmo.tester.model.FSMTransition;
import osmo.tester.model.Requirements;
import osmo.tester.reporting.coverage.RequirementCount;
import osmo.tester.reporting.coverage.SingleTestCoverage;
import osmo.tester.reporting.coverage.ValueCount;
import osmo.tester.reporting.coverage.VariableValues;
import osmo.tester.scripter.robotframework.CSSHelper;

public abstract class CoverageMetric {
    protected final TestCoverage suiteCoverage;
    protected final FSM fsm;
    protected final Collection<TestCase> tests;
    private VelocityEngine velocity = new VelocityEngine();
    private VelocityContext vc = new VelocityContext();

    public CoverageMetric(TestCoverage suiteCoverage, Collection<TestCase> tests, FSM fsm) {
        this.fsm = fsm;
        this.suiteCoverage = suiteCoverage;
        this.tests = tests;
        this.velocity.setProperty("resource.loader", (Object)"class");
        this.velocity.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
    }

    protected List<ValueCount> countSteps() {
        Map<String, Integer> covered = this.suiteCoverage.getStepCoverage();
        ArrayList<ValueCount> counts = new ArrayList<ValueCount>();
        Collection<FSMTransition> all = this.fsm.getTransitions();
        for (FSMTransition fSMTransition : all) {
            String tn = fSMTransition.getStringName();
            if (covered.containsKey(tn)) continue;
            covered.put(tn, 0);
        }
        for (Map.Entry entry : covered.entrySet()) {
            ValueCount count = new ValueCount((String)entry.getKey(), (Integer)entry.getValue());
            counts.add(count);
        }
        Collections.sort(counts);
        return counts;
    }

    protected List<ValueCount> countStepPairs() {
        LinkedHashMap<String, Integer> coverage = new LinkedHashMap<String, Integer>();
        for (TestCase testCase : this.tests) {
            String previous = ".osmo.tester.start.step";
            for (TestCaseStep ts : testCase.getSteps()) {
                String next = ts.getName();
                String key = previous + "->" + next;
                Integer count = (Integer)coverage.get(key);
                if (count == null) {
                    count = 0;
                }
                coverage.put(key, count + 1);
                previous = ts.getName();
            }
        }
        List<String> allPairs = this.getStepPairs();
        for (String pair : allPairs) {
            if (coverage.containsKey(pair)) continue;
            coverage.put(pair, 0);
        }
        ArrayList<ValueCount> arrayList = new ArrayList<ValueCount>();
        for (Map.Entry entry : coverage.entrySet()) {
            String pair = (String)entry.getKey();
            ValueCount count = new ValueCount(pair, (Integer)entry.getValue());
            arrayList.add(count);
        }
        return arrayList;
    }

    protected List<RequirementCount> countRequirements() {
        LinkedHashMap<String, Integer> coverage = new LinkedHashMap<String, Integer>();
        for (TestCase tc : this.tests) {
            Collection<String> reqs = tc.getCoverage().getRequirements();
            Iterator<Object> iterator = reqs.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                Integer count = (Integer)coverage.get(string);
                if (count == null) {
                    count = 0;
                }
                coverage.put(string, count + 1);
            }
        }
        Requirements requirements = this.fsm.getRequirements();
        Collection<String> all = requirements.getRequirements();
        for (String name : all) {
            if (coverage.containsKey(name)) continue;
            coverage.put(name, 0);
        }
        ArrayList<RequirementCount> rc = new ArrayList<RequirementCount>();
        for (Map.Entry entry : coverage.entrySet()) {
            String name = (String)entry.getKey();
            RequirementCount count = new RequirementCount(name, (Integer)entry.getValue());
            rc.add(count);
        }
        return rc;
    }

    public String getStepCounts(String templateName) {
        List<ValueCount> counts = this.countSteps();
        this.vc.put("steps", counts);
        StringWriter sw = new StringWriter();
        this.velocity.mergeTemplate(templateName, "UTF8", (Context)this.vc, (Writer)sw);
        return sw.toString();
    }

    public String getStepPairCounts(String templateName) {
        List<ValueCount> tpc = this.countStepPairs();
        Collections.sort(tpc);
        this.vc.put("step-pairs", tpc);
        StringWriter sw = new StringWriter();
        this.velocity.mergeTemplate(templateName, "UTF8", (Context)this.vc, (Writer)sw);
        return sw.toString();
    }

    public String getRequirementCounts(String templateName) {
        List<RequirementCount> tpc = this.countRequirements();
        Collections.sort(tpc);
        this.vc.put("reqs", tpc);
        StringWriter sw = new StringWriter();
        this.velocity.mergeTemplate(templateName, "UTF8", (Context)this.vc, (Writer)sw);
        return sw.toString();
    }

    public String getTraceabilityMatrix(String templateName) {
        List<SingleTestCoverage> tc = this.getTestCoverage();
        List<String> steps = this.getSteps();
        List<String> pairs = this.getStepPairs();
        List<String> reqs = this.getRequirements();
        List<String> variables = this.getVariables();
        List<VariableValues> variableValues = this.getVariableValues();
        List<VariableValues> states = this.getStates();
        List<VariableValues> statePairs = this.getStatePairs();
        this.vc.put("alt", (Object)new CSSHelper());
        this.vc.put("tests", tc);
        this.vc.put("req_names", reqs);
        this.vc.put("step_names", steps);
        this.vc.put("step_pair_names", pairs);
        this.vc.put("variable_names", variables);
        this.vc.put("variable_values", variableValues);
        this.vc.put("states", states);
        this.vc.put("state_pairs", statePairs);
        StringWriter sw = new StringWriter();
        this.velocity.mergeTemplate(templateName, "UTF8", (Context)this.vc, (Writer)sw);
        return sw.toString();
    }

    private List<String> getVariables() {
        ArrayList<String> variables = new ArrayList<String>();
        variables.addAll(this.suiteCoverage.getVariables());
        Collections.sort(variables);
        return variables;
    }

    private List<SingleTestCoverage> getTestCoverage() {
        ArrayList<SingleTestCoverage> result = new ArrayList<SingleTestCoverage>();
        for (TestCase test : this.tests) {
            result.add(new SingleTestCoverage(test));
        }
        return result;
    }

    private List<String> getSteps() {
        ArrayList<String> result = new ArrayList<String>();
        Collection<FSMTransition> transitions = this.fsm.getTransitions();
        for (FSMTransition transition : transitions) {
            result.add(transition.getStringName());
        }
        Collections.sort(result);
        return result;
    }

    private List<String> getStepPairs() {
        ArrayList<String> result = new ArrayList<String>();
        Collection<String> pairs = this.suiteCoverage.getStepPairs();
        result.addAll(pairs);
        Collections.sort(result);
        return result;
    }

    private List<String> getRequirements() {
        LinkedHashSet<String> temp = new LinkedHashSet<String>();
        Requirements fsmReqs = this.fsm.getRequirements();
        temp.addAll(fsmReqs.getRequirements());
        temp.addAll(fsmReqs.getExcess());
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.addAll(temp);
        Collections.sort(reqs);
        return reqs;
    }

    private List<VariableValues> getVariableValues(Map<String, Collection<String>> variables) {
        ArrayList<VariableValues> result = new ArrayList<VariableValues>();
        ArrayList<String> coverageNames = new ArrayList<String>();
        coverageNames.addAll(variables.keySet());
        Collections.sort(coverageNames);
        for (String name : coverageNames) {
            result.add(new VariableValues(name, variables.get(name)));
        }
        return result;
    }

    public List<VariableValues> getVariableValues() {
        return this.getVariableValues(this.suiteCoverage.getVariableValues());
    }

    public List<VariableValues> getStates() {
        return this.getVariableValues(this.suiteCoverage.getStates());
    }

    public List<VariableValues> getStatePairs() {
        return this.getVariableValues(this.suiteCoverage.getStatePairs());
    }
}

