/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.reporting.coverage;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import osmo.tester.generator.testsuite.TestCase;

public class SingleTestCoverage {
    private final String name;
    private final Map<String, Integer> reqCount = new LinkedHashMap<String, Integer>();
    private final Map<String, Integer> stepCount = new LinkedHashMap<String, Integer>();
    private final Map<String, Integer> pairCount = new LinkedHashMap<String, Integer>();
    private final Map<String, Collection<Object>> variableValues = new LinkedHashMap<String, Collection<Object>>();

    public SingleTestCoverage(TestCase tc) {
        this.name = tc.getName();
        this.countRequirements(tc);
        this.countSteps(tc);
        this.collectVariableValues(tc);
    }

    private void countRequirements(TestCase tc) {
        Collection<String> covered = tc.getCoverage().getRequirements();
        for (String req : covered) {
            this.incrementCountFor(this.reqCount, req);
        }
    }

    private void countSteps(TestCase tc) {
        List<String> names = tc.getAllStepNames();
        String previous = ".osmo.tester.start.step";
        for (String name : names) {
            this.incrementCountFor(this.stepCount, name);
            String pair = previous + "->" + name;
            this.incrementCountFor(this.pairCount, pair);
            previous = name;
        }
    }

    private void incrementCountFor(Map<String, Integer> map, String name) {
        Integer count = map.get(name);
        if (count == null) {
            count = 0;
        }
        Integer n = count;
        Integer n2 = count = Integer.valueOf(count + 1);
        map.put(name, count);
    }

    private void collectVariableValues(TestCase tc) {
        Map<String, Collection<String>> variables = tc.getCoverage().getVariableValues();
        for (String var : variables.keySet()) {
            Collection<Object> values = this.variableValues.get(var);
            if (values == null) {
                values = new LinkedHashSet<Object>();
                this.variableValues.put(var, values);
            }
            values.addAll(variables.get(var));
        }
    }

    public String getName() {
        return this.name;
    }

    private int countFor(Map<String, Integer> map, String name) {
        Integer count = map.get(name);
        if (count == null) {
            count = 0;
        }
        return count;
    }

    public int reqCount(String requirement) {
        return this.countFor(this.reqCount, requirement);
    }

    public int stepCount(String step) {
        return this.countFor(this.stepCount, step);
    }

    public int pairCount(String pair) {
        return this.countFor(this.pairCount, pair);
    }

    public Collection<Object> variableCoverage(String variable) {
        Collection<Object> values = this.variableValues.get(variable);
        if (values != null) {
            return values;
        }
        return Collections.EMPTY_LIST;
    }

    public Collection<String> variableNames() {
        return this.variableValues.keySet();
    }
}

