/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.reporting.jenkins;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import osmo.common.log.Logger;
import osmo.tester.OSMOConfiguration;
import osmo.tester.generator.endcondition.EndCondition;
import osmo.tester.generator.filter.StepFilter;
import osmo.tester.generator.listener.GenerationListener;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.generator.testsuite.TestCaseStep;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.FSM;
import osmo.tester.model.FSMTransition;
import osmo.tester.model.TestModels;
import osmo.tester.parser.ModelObject;
import osmo.tester.reporting.jenkins.JenkinsSuite;
import osmo.tester.reporting.jenkins.Property;

public class JenkinsReportGenerator
implements GenerationListener {
    private static final Logger log = new Logger(JenkinsReportGenerator.class);
    private VelocityEngine velocity = new VelocityEngine();
    private VelocityContext vc = new VelocityContext();
    private OSMOConfiguration config = null;
    private JenkinsSuite suite = new JenkinsSuite("OSMO Test Suite", false);
    private final String filename;
    private final boolean steps;
    private Long seed = null;
    private FSM fsm;
    private static final String NULL = "Null";
    private static final String SCRIPTER = "Scripter";
    private static final String ALGORITHM = "Algorithm";
    private static final String FILTER = "Filter";
    private static final String LISTENER = "Listener";
    private static final String MODEL_OBJECT = "Model Object";
    private static final String SEED = "Seed";
    private static final String SUITE_END_CONDITION = "Suite End Condition";
    private static final String TEST_CASE_END_CONDITION = "Test Case End Condition";

    public JenkinsReportGenerator(String filename, boolean steps) {
        this.filename = filename;
        this.steps = steps;
    }

    public void enableTestMode() {
        this.suite = new JenkinsSuite("OSMO Test Suite", true);
    }

    @Override
    public void init(long seed, FSM fsm, OSMOConfiguration config) {
        this.seed = seed;
        this.fsm = fsm;
        this.config = config;
    }

    @Override
    public void guard(FSMTransition transition) {
    }

    @Override
    public void stepStarting(TestCaseStep step) {
    }

    @Override
    public void stepDone(TestCaseStep step) {
    }

    @Override
    public void lastStep(String name) {
    }

    @Override
    public void pre(FSMTransition transition) {
    }

    @Override
    public void post(FSMTransition transition) {
    }

    @Override
    public void testStarted(TestCase test) {
    }

    @Override
    public void testEnded(TestCase test) {
        this.suite.add(test);
    }

    @Override
    public void testError(TestCase test, Throwable error) {
    }

    @Override
    public void suiteStarted(TestSuite suite) {
        this.suite.start();
    }

    @Override
    public void suiteEnded(TestSuite suite) {
        this.suite.end();
        if (this.filename == null) {
            log.d("No filename defined, not writing jenkins report to file");
            return;
        }
        if (this.steps) {
            this.writeStepReport();
        } else {
            this.writeTestReport();
        }
    }

    public void writeStepReport() {
        String report = this.generateReport("steps");
        try {
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(this.filename));
            out.write(report);
            ((Writer)out).flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to write report", ioe);
        }
    }

    public void writeTestReport() {
        String report = this.generateReport("tests");
        try {
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(this.filename));
            out.write(report);
            ((Writer)out).flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to write report", ioe);
        }
    }

    public String generateStepReport() {
        return this.generateReport("steps");
    }

    public String generateTestReport() {
        return this.generateReport("tests");
    }

    public String generateReport(String templateName) {
        this.vc.put("suite", (Object)this.suite);
        this.vc.put("properties", this.fillProperties());
        this.velocity.setProperty("resource.loader", (Object)"class");
        this.velocity.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        StringWriter sw = new StringWriter();
        this.velocity.mergeTemplate("osmo/tester/reporting/jenkins/jenkins-" + templateName + ".vm", "UTF8", (Context)this.vc, (Writer)sw);
        return sw.toString();
    }

    private Collection<Property> fillProperties() {
        ArrayList<Property> properties = new ArrayList<Property>();
        String algorithm = this.config.cloneAlgorithm(this.seed, this.fsm).getClass().getName();
        properties.add(new Property(ALGORITHM, algorithm));
        Collection<StepFilter> filters = this.config.getFilters();
        for (StepFilter stepFilter : filters) {
            properties.add(new Property(FILTER, stepFilter.getClass().getName()));
        }
        Collection<GenerationListener> listeners = this.config.getListeners().getListeners();
        for (GenerationListener generationListener : listeners) {
            properties.add(new Property(LISTENER, generationListener.getClass().getName()));
        }
        TestModels testModels = new TestModels();
        this.config.createModelObjects(testModels);
        for (ModelObject mo : testModels.getModels()) {
            String prefix = mo.getPrefix();
            String name = mo.getObject().getClass().getName();
            if (prefix.length() > 0) {
                properties.add(new Property(MODEL_OBJECT, prefix + "::" + name));
                continue;
            }
            properties.add(new Property(MODEL_OBJECT, name));
        }
        properties.add(new Property(SEED, "" + this.seed));
        EndCondition endCondition = this.config.getSuiteEndCondition();
        properties.add(new Property(SUITE_END_CONDITION, endCondition.toString()));
        EndCondition testEndCondition = this.config.getTestCaseEndCondition();
        properties.add(new Property(TEST_CASE_END_CONDITION, testEndCondition.toString()));
        return properties;
    }

    public JenkinsSuite getSuite() {
        return this.suite;
    }
}

