/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.reporting.jenkins;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import osmo.tester.reporting.jenkins.JenkinsTest;

public class JenkinsStep {
    private final String className;
    private final String name;
    private long startTime;
    private long endTime;
    private Exception error = null;
    private static final AtomicInteger nextId = new AtomicInteger(0);

    public JenkinsStep(String className, JenkinsTest parent, String name) {
        this.className = className;
        int id = nextId.incrementAndGet();
        this.name = parent.getName() + "_step_" + id + "_" + name;
    }

    public static void resetId() {
        nextId.set(0);
    }

    public String getDuration() {
        long duration = this.endTime - this.startTime;
        double seconds = (double)duration / 1000.0;
        return String.format(Locale.US, "%.2f", seconds);
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        return this.name;
    }

    public String getError() {
        if (this.error == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
        PrintStream psOut = new PrintStream(out);
        this.error.printStackTrace(psOut);
        return out.toString();
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setError(Exception error) {
        this.error = error;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }
}

