/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.reporting.jenkins;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import osmo.tester.generator.testsuite.TestCase;
import osmo.tester.generator.testsuite.TestCaseStep;
import osmo.tester.reporting.jenkins.JenkinsStep;
import osmo.tester.reporting.jenkins.JenkinsTest;

public class JenkinsSuite {
    private final String name;
    private long startTime;
    private long endTime;
    private Collection<JenkinsTest> tests = new ArrayList<JenkinsTest>();
    private ByteArrayOutputStream out;
    private ByteArrayOutputStream err;
    private PrintStream oldOut;
    private PrintStream oldErr;
    private PrintStream newOut;
    private PrintStream newErr;
    public static DateFormat format = DateFormat.getDateTimeInstance();
    private Long testStartTime = null;
    private Long testEndTime = null;
    private boolean testing = false;

    public JenkinsSuite(String name, boolean testing) {
        this.name = name;
        this.testing = testing;
        this.out = new ByteArrayOutputStream(1000);
        this.newOut = new PrintStream(this.out);
        this.err = new ByteArrayOutputStream(1000);
        this.newErr = new PrintStream(this.err);
    }

    public void start() {
        JenkinsTest.resetId();
        this.startTime = System.currentTimeMillis();
        this.oldOut = System.out;
        this.oldErr = System.err;
        System.setOut(this.newOut);
        System.setErr(this.newErr);
    }

    public void end() {
        this.endTime = System.currentTimeMillis();
        System.setOut(this.oldOut);
        System.setErr(this.oldErr);
    }

    public String getName() {
        return this.name;
    }

    public String getSystemOut() {
        return this.out.toString();
    }

    public String getSystemErr() {
        return this.err.toString();
    }

    public long getStartMillis() {
        if (this.testStartTime != null) {
            return this.testStartTime;
        }
        return this.startTime;
    }

    public long getEndMillis() {
        if (this.testEndTime != null) {
            return this.testEndTime;
        }
        return this.endTime;
    }

    public String getDuration() {
        long duration = this.getEndMillis() - this.getStartMillis();
        double seconds = (double)duration / 1000.0;
        return String.format(Locale.US, "%.2f", seconds);
    }

    public void add(TestCase test) {
        JenkinsTest newTest = new JenkinsTest(this.testing);
        JenkinsStep.resetId();
        List<TestCaseStep> steps = test.getSteps();
        for (TestCaseStep step : steps) {
            String className = step.getModelObjectName();
            String stepName = step.getName();
            JenkinsStep jenkinsStep = new JenkinsStep(className, newTest, stepName);
            jenkinsStep.setStartTime(step.getStartTime());
            jenkinsStep.setEndTime(step.getEndTime());
            newTest.add(jenkinsStep);
        }
        this.tests.add(newTest);
    }

    public Collection<JenkinsStep> getSteps() {
        ArrayList<JenkinsStep> steps = new ArrayList<JenkinsStep>();
        for (JenkinsTest test : this.tests) {
            steps.addAll(test.getSteps());
        }
        return steps;
    }

    public Collection<JenkinsTest> getTests() {
        return this.tests;
    }

    public int getStepCount() {
        int count = 0;
        for (JenkinsTest test : this.tests) {
            count += test.getSteps().size();
        }
        return count;
    }

    public int getTestCount() {
        return this.tests.size();
    }

    public int getErrorCount() {
        int count = 0;
        for (JenkinsTest test : this.tests) {
            List<JenkinsStep> steps = test.getSteps();
            for (JenkinsStep step : steps) {
                if (step.getError() == null) continue;
                ++count;
            }
        }
        return count;
    }

    public int getFailureCount() {
        return 0;
    }

    public String getStartTime() {
        return format.format(new Date(this.getStartMillis()));
    }

    public void setStartTime(long startTime) {
        this.testStartTime = startTime;
    }

    public void setEndTime(long endTime) {
        this.testEndTime = endTime;
    }
}

