/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.reporting.jenkins;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import osmo.tester.reporting.jenkins.JenkinsStep;

public class JenkinsTest {
    private List<JenkinsStep> steps = new ArrayList<JenkinsStep>();
    private static AtomicInteger nextId = new AtomicInteger(0);
    private final int id = nextId.incrementAndGet();
    private boolean testing = false;

    public static void resetId() {
        nextId.set(0);
    }

    public JenkinsTest(boolean testing) {
        this.testing = testing;
    }

    public void add(JenkinsStep step) {
        this.steps.add(step);
    }

    public String getName() {
        return "Test" + this.id;
    }

    public String getClassName() {
        LinkedHashSet<JenkinsStep> mySteps = new LinkedHashSet<JenkinsStep>();
        mySteps.addAll(this.steps);
        LinkedHashSet<String> name = new LinkedHashSet<String>();
        for (JenkinsStep step : mySteps) {
            name.add(step.getClassName());
        }
        return ((Object)name).toString();
    }

    public String getDuration() {
        if (this.steps.size() == 0) {
            return "!test has no steps!";
        }
        if (this.testing) {
            return "0.00";
        }
        JenkinsStep first = this.steps.get(0);
        JenkinsStep last = this.steps.get(this.steps.size() - 1);
        long startTime = first.getStartTime();
        long endTime = last.getEndTime();
        if (endTime == 0L) {
            return "0.00";
        }
        long duration = endTime - startTime;
        double seconds = (double)duration / 1000.0;
        return String.format(Locale.US, "%.2f", seconds);
    }

    public List<JenkinsStep> getSteps() {
        return this.steps;
    }
}

