/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.reporting.junit;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import osmo.tester.OSMOConfiguration;
import osmo.tester.OSMOTester;
import osmo.tester.generator.MainGenerator;
import osmo.tester.reporting.junit.JUnitGenerationListener;
import osmo.tester.reporting.junit.OSMOConfigurationProvider;
import osmo.tester.reporting.junit.OSMOJUnitTest;

public class OSMORunner
extends BlockJUnit4ClassRunner {
    protected List<FrameworkMethod> tests = new ArrayList<FrameworkMethod>();

    public OSMORunner(Class<?> klass) throws InitializationError {
        super(klass);
        try {
            this.computeTests();
        }
        catch (Exception e) {
            throw new InitializationError((Throwable)e);
        }
    }

    protected void computeTests() throws Exception {
        this.tests.addAll(super.computeTestMethods());
        this.tests.addAll(this.computeOSMOTests());
        this.createTest();
    }

    protected Collection<? extends FrameworkMethod> computeOSMOTests() throws Exception {
        List factories = this.getTestClass().getAnnotatedMethods(OSMOConfigurationProvider.class);
        int factoryCount = factories.size();
        if (factoryCount == 0) {
            throw new IllegalArgumentException("OSMORunner requires a @OsmoConfigurationFactory method");
        }
        if (factoryCount > 1) {
            throw new IllegalArgumentException("OSMORunner supports only one @OsmoConfigurationFactory method (had " + factoryCount + ")");
        }
        FrameworkMethod method = (FrameworkMethod)factories.get(0);
        if (!Modifier.isStatic(method.getMethod().getModifiers())) {
            throw new InitializationError("TestFactory " + method + " must be static.");
        }
        Object obj = method.getMethod().invoke((Object)this.getTestClass().getJavaClass(), new Object[0]);
        if (obj == null) {
            throw new IllegalArgumentException("@" + OSMOConfigurationProvider.class.getSimpleName() + " method must return a value of type " + OSMOConfiguration.class.getSimpleName() + " was null");
        }
        if (!(obj instanceof OSMOConfiguration)) {
            throw new IllegalArgumentException("@" + OSMOConfigurationProvider.class.getSimpleName() + " method must return a value of type " + OSMOConfiguration.class.getSimpleName() + " was " + obj.getClass().getSimpleName());
        }
        OSMOConfiguration config = (OSMOConfiguration)obj;
        int count = config.getJUnitLength();
        if (count <= 0) {
            throw new IllegalArgumentException(OSMOConfiguration.class.getSimpleName() + " with JUnit must define value for JUnitLength");
        }
        OSMOTester osmo = new OSMOTester();
        osmo.setConfig(config);
        long seed = System.currentTimeMillis();
        MainGenerator generator = osmo.initGenerator(seed);
        config.initialize(seed, generator.getFsm());
        generator.initSuite();
        config.addListener(new JUnitGenerationListener(config.getJUnitLength(), generator));
        ArrayList<OSMOJUnitTest> tests = new ArrayList<OSMOJUnitTest>();
        for (int i = 0; i < count; ++i) {
            Method execute = OSMOJUnitTest.class.getMethod("execute", new Class[0]);
            OSMOJUnitTest test = new OSMOJUnitTest(generator, execute);
            tests.add(test);
        }
        return tests;
    }

    protected List<FrameworkMethod> computeTestMethods() {
        return this.tests;
    }

    protected void validateInstanceMethods(List<Throwable> errors) {
    }
}

