/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.reporting.model;

import java.lang.reflect.Method;
import java.util.Collection;
import osmo.tester.OSMOConfiguration;
import osmo.tester.generator.MainGenerator;
import osmo.tester.generator.testsuite.TestSuite;
import osmo.tester.model.CoverageMethod;
import osmo.tester.model.FSM;
import osmo.tester.model.FSMTransition;
import osmo.tester.model.InvocationTarget;
import osmo.tester.model.ModelFactory;
import osmo.tester.model.Requirements;
import osmo.tester.model.VariableField;

public class ModelPrinter {
    private OSMOConfiguration config = new OSMOConfiguration();

    public void setModelFactory(ModelFactory factory) {
        this.config.setFactory(factory);
    }

    public String write() {
        String report = "";
        MainGenerator generator = new MainGenerator(0L, new TestSuite(), this.config);
        FSM fsm = generator.getFsm();
        report = report + "BeforeSuites: " + this.targetsToString(fsm.getBeforeSuites());
        report = report + "AfterSuites: " + this.targetsToString(fsm.getAfterSuites());
        report = report + "BeforeTests: " + this.targetsToString(fsm.getBeforeTests());
        report = report + "AfterTests: " + this.targetsToString(fsm.getAfterTests());
        report = report + "Last Steps: " + this.targetsToString(fsm.getLastSteps());
        report = report + "Model EndConditions: " + this.targetsToString(fsm.getEndConditions());
        report = report + "Exploration Enablers: " + this.targetsToString(fsm.getExplorationEnablers());
        report = report + "Generation Enablers: " + this.targetsToString(fsm.getGenerationEnablers());
        report = report + "Coverage Value Methods: ";
        Collection<CoverageMethod> coverageMethods = fsm.getCoverageMethods();
        for (CoverageMethod cm : coverageMethods) {
            report = report + cm.getVariableName();
            Method method = cm.getInvocationTarget().getMethod();
            String[] split = method.toGenericString().split(" ");
            String target = split[2];
            report = report + "[" + target + "], ";
        }
        report = report + "\n";
        Requirements requirements = fsm.getRequirements();
        report = report + "Requirements: " + requirements;
        if (requirements != null) {
            report = report + " (" + requirements.getRequirements() + ")";
        }
        report = report + "\n";
        Collection<VariableField> variables = fsm.getModelVariables();
        report = report + "Variables: ";
        for (VariableField variable : variables) {
            report = report + variable.getName() + ", ";
        }
        report = report + "\n";
        report = report + "\n";
        Collection<FSMTransition> transitions = fsm.getTransitions();
        for (FSMTransition t : transitions) {
            report = report + "STEP: " + t.getStringName() + ", WEIGHT=" + t.getWeight() + "\n";
            report = report + "GUARDS: " + this.targetsToString(t.getGuards());
            report = report + "GROUP: " + t.getGroupName() + "\n";
            report = report + "POST: " + this.targetsToString(t.getPostMethods());
            report = report + "PRE: " + this.targetsToString(t.getPreMethods());
            report = report + "\n";
        }
        return report;
    }

    private String targetsToString(Collection<InvocationTarget> targets) {
        String result = "";
        for (InvocationTarget target : targets) {
            Method method = target.getMethod();
            String[] split = method.toGenericString().split(" ");
            String name = split[2];
            result = result + name + ", ";
        }
        result = result + "\n";
        return result;
    }
}

