/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.scenario;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import osmo.common.OSMOException;
import osmo.tester.generator.endcondition.EndCondition;
import osmo.tester.generator.endcondition.logical.And;
import osmo.tester.generator.endcondition.structure.StepCoverage;
import osmo.tester.model.FSM;
import osmo.tester.model.FSMTransition;
import osmo.tester.scenario.Slice;

public class Scenario {
    private List<String> startup = new ArrayList<String>();
    private List<Slice> slices = new ArrayList<Slice>();
    private Collection<String> forbidden = new LinkedHashSet<String>();
    private final boolean strict;
    private String errors = "";

    public Scenario(boolean strict) {
        this.strict = strict;
    }

    public void addStartup(String ... steps) {
        this.startup.addAll(Arrays.asList(steps));
    }

    public void forbid(String step) {
        this.forbidden.add(step);
    }

    public void addSlice(String stepName, int min, int max) {
        this.slices.add(new Slice(stepName, min, max));
    }

    public List<String> getStartup() {
        return this.startup;
    }

    public List<Slice> getSlices() {
        return this.slices;
    }

    public void validate(FSM fsm) {
        this.errors = "";
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (FSMTransition t : fsm.getTransitions()) {
            names.add(t.getStringName());
        }
        LinkedHashSet<String> toClear = new LinkedHashSet<String>();
        toClear.addAll(this.startup);
        toClear.removeAll(names);
        if (!toClear.isEmpty()) {
            this.error("Scenario startup script contains steps not found in model:" + toClear);
        }
        toClear.clear();
        ArrayList<String> allSliced = new ArrayList<String>();
        for (Slice slice : this.slices) {
            String name = slice.getStepName();
            toClear.add(name);
            if (allSliced.contains(name)) {
                this.error("Duplicate slices not allowed:" + name);
            }
            allSliced.add(name);
            int min = slice.getMin();
            int max = slice.getMax();
            if (min == 0 || max == 0 || min <= max) continue;
            this.error("Minimum must be lower or equal to maximum in slice:" + name);
        }
        toClear.removeAll(names);
        if (!toClear.isEmpty()) {
            this.error("Scenario slices contains steps not found in model:" + toClear);
        }
        toClear.clear();
        toClear.addAll(this.forbidden);
        toClear.retainAll(allSliced);
        if (!toClear.isEmpty()) {
            this.error("Cannot forbid items in slice:" + toClear);
        }
        if (this.strict) {
            ArrayList<String> temp = new ArrayList<String>();
            temp.addAll(names);
            temp.removeAll(allSliced);
            this.forbidden.addAll(temp);
        }
        if (this.errors.length() > 0) {
            throw new OSMOException(this.errors);
        }
    }

    private void error(String msg) {
        if (this.errors.length() > 0) {
            this.errors = this.errors + "\n";
        }
        this.errors = this.errors + msg;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public EndCondition createEndCondition(EndCondition testCaseEndCondition) {
        if (this.slices.isEmpty()) {
            return testCaseEndCondition;
        }
        LinkedHashMap<String, Integer> counts = new LinkedHashMap<String, Integer>();
        for (String string : this.startup) {
            Integer count = (Integer)counts.get(string);
            if (count == null) {
                count = 0;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            counts.put(string, count);
        }
        ArrayList<String> reqs = new ArrayList<String>();
        for (Slice slice : this.slices) {
            String name = slice.getStepName();
            Integer count = (Integer)counts.get(name);
            if (count != null) {
                for (int ci = 0; ci < count; ++ci) {
                    reqs.add(name);
                }
            }
            for (int i = 0; i < slice.getMin(); ++i) {
                reqs.add(name);
            }
        }
        if (reqs.isEmpty()) {
            return testCaseEndCondition;
        }
        StepCoverage stepCoverage = new StepCoverage(reqs.toArray(new String[reqs.size()]));
        if (testCaseEndCondition == null) {
            return stepCoverage;
        }
        return new And(stepCoverage, testCaseEndCondition);
    }

    public Collection<String> getForbidden() {
        return this.forbidden;
    }
}

