/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.scenario;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import osmo.tester.model.FSMTransition;
import osmo.tester.scenario.Scenario;
import osmo.tester.scenario.Slice;

public class ScenarioFilter {
    private final Scenario scenario;
    private final int sliceIndex;
    private Map<String, Slice> slices = new LinkedHashMap<String, Slice>();

    public ScenarioFilter(Scenario scenario) {
        this.scenario = scenario;
        if (scenario == null) {
            this.sliceIndex = -1;
            return;
        }
        List<Slice> slices = scenario.getSlices();
        for (Slice slice : slices) {
            this.slices.put(slice.getStepName(), slice);
        }
        this.sliceIndex = scenario.getStartup().size();
    }

    public void filter(List<FSMTransition> enabled, List<String> stepsSoFar) {
        if (this.scenario == null) {
            return;
        }
        if (stepsSoFar.size() < this.scenario.getStartup().size()) {
            this.filterStartup(enabled, stepsSoFar);
        } else {
            this.filterSlice(enabled, stepsSoFar);
        }
    }

    private void filterSlice(List<FSMTransition> enabled, List<String> stepsSoFar) {
        LinkedHashMap<String, Integer> stepCount = new LinkedHashMap<String, Integer>();
        for (int si = this.sliceIndex; si < stepsSoFar.size(); ++si) {
            String step = stepsSoFar.get(si);
            Integer count = (Integer)stepCount.get(step);
            if (count == null) {
                count = 0;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            stepCount.put(step, count);
        }
        Iterator<FSMTransition> ei = enabled.iterator();
        while (ei.hasNext()) {
            int max;
            FSMTransition t = ei.next();
            String name = t.getStringName();
            if (this.scenario.getForbidden().contains(name)) {
                ei.remove();
                continue;
            }
            Slice slice = this.slices.get(name);
            if (slice == null) continue;
            Integer count = (Integer)stepCount.get(name);
            if (count == null) {
                count = 0;
            }
            if ((max = slice.getMax()) <= 0 || max > count) continue;
            ei.remove();
        }
    }

    private void filterStartup(List<FSMTransition> enabled, List<String> stepsSoFar) {
        String now = this.scenario.getStartup().get(stepsSoFar.size());
        Iterator<FSMTransition> i = enabled.iterator();
        while (i.hasNext()) {
            FSMTransition t = i.next();
            if (t.getStringName().equals(now)) continue;
            i.remove();
        }
    }
}

