/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.scripter.internal;

import java.util.ArrayList;
import java.util.List;
import osmo.common.TestUtils;
import osmo.tester.scripter.internal.TestScript;

public class TestLoader {
    public List<TestScript> loadTests(String dir) {
        ArrayList<TestScript> scripts = new ArrayList<TestScript>();
        List<String> files = TestUtils.listFiles(dir, "tc", true);
        for (String file : files) {
            String scriptText = TestUtils.readFile(file, "UTF8");
            TestScript script = this.parse(scriptText);
            scripts.add(script);
        }
        return scripts;
    }

    public TestScript parse(String scriptText) {
        String[] lines;
        TestScript script = new TestScript();
        for (String line : lines = scriptText.split("\n")) {
            if (line.startsWith("#")) continue;
            if (line.startsWith("seed:")) {
                this.parseSeed(script, line);
                continue;
            }
            script.addStep(line);
        }
        if (script.getSeed() == null) {
            throw new IllegalArgumentException("Test script has no seed defined.");
        }
        return script;
    }

    private void parseSeed(TestScript script, String line) {
        int start = "seed:".length();
        String seedText = line.substring(start, line.length()).trim();
        long seed = Long.parseLong(seedText);
        script.setSeed(seed);
    }
}

