/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.scripter.robotframework;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import osmo.tester.scripter.robotframework.CSSHelper;
import osmo.tester.scripter.robotframework.RFParameter;
import osmo.tester.scripter.robotframework.RFTestCase;

public class RFScripter {
    private String testLibrary;
    private VelocityEngine velocity = new VelocityEngine();
    private VelocityContext vc = new VelocityContext();
    private Map<String, String> variables = new LinkedHashMap<String, String>();
    private Collection<RFTestCase> tests = new ArrayList<RFTestCase>();
    private RFTestCase currentTest = null;
    private final int cellCount;

    public RFScripter(int cellCount) {
        this.cellCount = cellCount;
    }

    public void setTestLibrary(String testLibrary) {
        this.testLibrary = testLibrary;
    }

    public void addVariable(String name, String value) {
        this.variables.put("${" + name + "}", value);
    }

    public void startTest(String name) {
        if (this.currentTest != null) {
            this.tests.add(this.currentTest);
        }
        this.currentTest = new RFTestCase(name, this.cellCount);
    }

    public void addStep(String keyword, RFParameter ... params) {
        this.currentTest.addStep(keyword, params);
    }

    public void addStepWithResult(String keyword, String variableName, RFParameter ... params) {
        this.currentTest.addStepWithResult(keyword, variableName, params);
    }

    public String createScript() {
        if (!this.tests.contains(this.currentTest)) {
            this.tests.add(this.currentTest);
        }
        this.vc.put("library", (Object)this.testLibrary);
        this.vc.put("argument_headers", this.getArgumentHeaders());
        this.vc.put("variables", this.variables.entrySet());
        this.vc.put("css", (Object)new CSSHelper());
        this.vc.put("tests", this.tests);
        this.velocity.setProperty("resource.loader", (Object)"class");
        this.velocity.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        StringWriter sw = new StringWriter();
        this.velocity.mergeTemplate("osmo/tester/scripter/robotframework/script.vm", "UTF8", (Context)this.vc, (Writer)sw);
        return sw.toString();
    }

    private Collection<String> getArgumentHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        for (int i = 0; i < this.cellCount; ++i) {
            headers.add("Argument");
        }
        return headers;
    }
}

