/*
 * Decompiled with CFR 0.152.
 */
package osmo.tester.scripter.robotframework;

import java.util.ArrayList;
import java.util.Collection;
import osmo.tester.scripter.robotframework.RFParameter;

public class RFTestStep {
    private final String action;
    private final String returnValueVariableName;
    private final RFParameter[] params;
    private final int cellCount;

    public RFTestStep(String action, int cellCount, RFParameter ... params) {
        this.action = action;
        this.returnValueVariableName = null;
        this.params = params;
        this.cellCount = cellCount;
    }

    public RFTestStep(String action, int cellCount, String variableName, RFParameter ... params) {
        this.action = action;
        this.returnValueVariableName = variableName;
        this.params = params;
        this.cellCount = cellCount;
    }

    public String getAction() {
        if (this.returnValueVariableName != null) {
            return "${" + this.returnValueVariableName + "}=";
        }
        return this.action;
    }

    public Collection<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        if (this.returnValueVariableName != null) {
            parameters.add(this.action);
        }
        for (RFParameter param : this.params) {
            parameters.add(param.toString());
        }
        for (int i = parameters.size(); i < this.cellCount; ++i) {
            parameters.add("");
        }
        return parameters;
    }
}

