/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.util.Util;

public class ReportParser {
    private Map<String, List<Feature>> jsonReportFiles;

    public ReportParser(List<String> jsonReportFiles) throws IOException {
        this.jsonReportFiles = this.parseJsonResults(jsonReportFiles);
    }

    public Map<String, List<Feature>> getFeatures() {
        return this.jsonReportFiles;
    }

    private Map<String, List<Feature>> parseJsonResults(List<String> jsonReportFiles) throws IOException {
        LinkedHashMap<String, List<Feature>> featureResults = new LinkedHashMap<String, List<Feature>>();
        for (String jsonFile : jsonReportFiles) {
            String fileContent = Util.readFileAsString(jsonFile);
            if (!Util.isValidCucumberJsonReport(fileContent)) continue;
            Feature[] features = (Feature[])new Gson().fromJson(Util.U2U(fileContent), Feature[].class);
            featureResults.put(jsonFile, Arrays.asList(features));
        }
        return featureResults;
    }
}

