/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.SquirrelTableCellRenderer;
import net.sourceforge.squirrel_sql.fw.gui.ColumnOrder;
import net.sourceforge.squirrel_sql.fw.gui.SortableTableModel;
import net.sourceforge.squirrel_sql.fw.gui.SortingListener;
import net.sourceforge.squirrel_sql.fw.resources.LibraryResources;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ButtonTableHeader
extends JTableHeader {
    private static ILogger s_log = LoggerController.createLogger(ButtonTableHeader.class);
    private static final String PREF_KEY_ALWAYS_ADJUST_ALL_COLUMN_HEADERS = "Squirrel.alwaysAdoptAllColumnHeaders";
    private static Icon s_ascIcon;
    private static Icon s_descIcon;
    private TableDataListener _dataListener = new TableDataListener();
    private SortingListener _sortingListener;
    private boolean _pressed = false;
    private boolean _dragged = false;
    private int _pressedViewColumnIdx = -1;
    private Icon _currentSortedColumnIcon;
    private int _currentlySortedModelIdx = -1;

    public ButtonTableHeader() {
        this.setDefaultRenderer(new ButtonTableRenderer(this.getFont()));
        HeaderListener hl = new HeaderListener();
        this.addMouseListener(hl);
        this.addMouseMotionListener(hl);
        this._sortingListener = new SortingListener(){

            @Override
            public void sortingDone(int modelColumnIx, ColumnOrder columnOrder) {
                ButtonTableHeader.this.onSortingDone(modelColumnIx, columnOrder);
            }
        };
    }

    private void onSortingDone(int modelColumnIx, ColumnOrder columnOrder) {
        int viewColumnIndex = this.getViewColumnIndex(modelColumnIx);
        this._currentSortedColumnIcon = ColumnOrder.ASC == columnOrder ? s_ascIcon : (ColumnOrder.DESC == columnOrder ? s_descIcon : null);
        this._currentlySortedModelIdx = modelColumnIx;
        this._pressedViewColumnIdx = viewColumnIndex;
        this.repaint();
    }

    private int getViewColumnIndex(int modelColumnIx) {
        int viewColumnIndex = -1;
        for (int i = 0; i < this.getTable().getColumnModel().getColumnCount(); ++i) {
            if (modelColumnIx != this.getTable().getColumnModel().getColumn(i).getModelIndex()) continue;
            viewColumnIndex = i;
        }
        return viewColumnIndex;
    }

    @Override
    public void setTable(JTable table) {
        SortableTableModel sortableTableModel;
        TableModel obj;
        JTable oldTable = this.getTable();
        if (oldTable != null && (obj = oldTable.getModel()) instanceof SortableTableModel) {
            sortableTableModel = (SortableTableModel)obj;
            sortableTableModel.getActualModel().removeTableModelListener(this._dataListener);
            sortableTableModel.removeSortingListener(this._sortingListener);
        }
        super.setTable(table);
        if (table != null && (obj = table.getModel()) instanceof SortableTableModel) {
            sortableTableModel = (SortableTableModel)obj;
            sortableTableModel.getActualModel().addTableModelListener(this._dataListener);
            sortableTableModel.addSortingListener(this._sortingListener);
        }
        this._currentSortedColumnIcon = null;
        this._currentlySortedModelIdx = -1;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int col = this.columnAtPoint(e.getPoint());
        String retStr = null;
        if (col >= 0) {
            TableColumn tcol = this.getColumnModel().getColumn(col);
            int colWidth = tcol.getWidth();
            TableCellRenderer h = tcol.getHeaderRenderer();
            if (h == null) {
                h = this.getDefaultRenderer();
            }
            Component c = h.getTableCellRendererComponent(this.table, tcol.getHeaderValue(), false, false, -1, col);
            int prefWidth = c.getPreferredSize().width;
            if (prefWidth > colWidth) {
                retStr = tcol.getHeaderValue().toString();
            }
        }
        return retStr;
    }

    public int getCurrentlySortedModelIdx() {
        return this._currentlySortedModelIdx;
    }

    public boolean isAscending() {
        return this._currentSortedColumnIcon == s_ascIcon;
    }

    public void columnIndexWillBeRemoved(int colIx) {
    }

    public void columnIndexWillBeAdded(int colIx) {
    }

    public void adjustAllColWidths(boolean includeColHeaders) {
        for (int i = 0; i < this.getTable().getColumnModel().getColumnCount(); ++i) {
            this.adjustColWidth(i, includeColHeaders);
        }
    }

    public static boolean isAlwaysAdjustAllColWidths() {
        return Preferences.userRoot().getBoolean(PREF_KEY_ALWAYS_ADJUST_ALL_COLUMN_HEADERS, false);
    }

    public static void setAlwaysAdjustAllColWidths(boolean b) {
        Preferences.userRoot().putBoolean(PREF_KEY_ALWAYS_ADJUST_ALL_COLUMN_HEADERS, b);
    }

    public void initColWidths() {
        if (ButtonTableHeader.isAlwaysAdjustAllColWidths()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ButtonTableHeader.this.adjustAllColWidths(true);
                }
            });
        }
    }

    private void adjustColWidth(int colIx, boolean includeColHeaders) {
        int modelIx = this.getTable().convertColumnIndexToModel(colIx);
        int rowCount = this.getTable().getModel().getRowCount();
        int newWidth = 20;
        if (includeColHeaders) {
            TableColumn column = this.getTable().getColumnModel().getColumn(colIx);
            TableCellRenderer headerRenderer = column.getHeaderRenderer();
            if (null == headerRenderer) {
                headerRenderer = this.getTable().getTableHeader().getDefaultRenderer();
            }
            Component headerComp = headerRenderer.getTableCellRendererComponent(this.getTable(), null, false, false, 0, colIx);
            FontMetrics headerFontMetrics = headerComp.getFontMetrics(headerComp.getFont());
            Rectangle2D bounds = headerFontMetrics.getStringBounds("" + column.getHeaderValue(), headerComp.getGraphics());
            int width = bounds.getBounds().width;
            if (-1 != this._currentlySortedModelIdx && colIx == this.getViewColumnIndex(this._currentlySortedModelIdx) && null != this._currentSortedColumnIcon) {
                width += this._currentSortedColumnIcon.getIconWidth();
            }
            newWidth = Math.max(newWidth, width);
        }
        if (0 == rowCount) {
            if (includeColHeaders) {
                this.getColumnModel().getColumn(colIx).setPreferredWidth(newWidth + 10);
            }
            return;
        }
        TableCellRenderer cellRenderer = this.getTable().getCellRenderer(0, colIx);
        Component cellComp = cellRenderer.getTableCellRendererComponent(this.getTable(), null, false, false, rowCount - 1, colIx);
        FontMetrics cellFontMetrics = cellComp.getFontMetrics(cellComp.getFont());
        for (int i = 0; i < rowCount; ++i) {
            Object value = this.getTable().getModel().getValueAt(i, modelIx);
            String stringVal = "";
            stringVal = this.getTable().getCellRenderer(i, colIx) instanceof SquirrelTableCellRenderer ? stringVal + ((SquirrelTableCellRenderer)((Object)this.getTable().getCellRenderer(i, colIx))).renderValue(value) : stringVal + value;
            Rectangle2D bounds = cellFontMetrics.getStringBounds(stringVal, cellComp.getGraphics());
            newWidth = Math.max(newWidth, bounds.getBounds().width);
        }
        this.getColumnModel().getColumn(colIx).setPreferredWidth(newWidth + 10);
    }

    static {
        try {
            LibraryResources rsrc = new LibraryResources();
            s_descIcon = rsrc.getIcon("table.descending");
            s_ascIcon = rsrc.getIcon("table.ascending");
        }
        catch (Exception ex) {
            s_log.error("Error retrieving icons", ex);
        }
    }

    protected class ButtonTableRenderer
    implements TableCellRenderer {
        JButton _buttonRaised = new JButton();
        JButton _buttonLowered;

        ButtonTableRenderer(Font font) {
            this._buttonRaised.putClientProperty("JButton.buttonType", "gradient");
            this._buttonRaised.setMargin(new Insets(0, 0, 0, 0));
            this._buttonRaised.setFont(font);
            this._buttonLowered = new JButton();
            this._buttonLowered.putClientProperty("JButton.buttonType", "gradient");
            this._buttonLowered.setMargin(new Insets(0, 0, 0, 0));
            this._buttonLowered.setFont(font);
            this._buttonLowered.getModel().setArmed(true);
            this._buttonLowered.getModel().setPressed(true);
            this._buttonLowered.setMinimumSize(new Dimension(50, 25));
            this._buttonRaised.setMinimumSize(new Dimension(50, 25));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                value = "";
            }
            if (ButtonTableHeader.this._pressedViewColumnIdx == column && ButtonTableHeader.this._pressed) {
                this._buttonLowered.setText(value.toString());
                if (column == ButtonTableHeader.this.getViewColumnIndex(ButtonTableHeader.this._currentlySortedModelIdx) && ButtonTableHeader.this._currentSortedColumnIcon != null) {
                    this._buttonLowered.setIcon(ButtonTableHeader.this._currentSortedColumnIcon);
                } else {
                    this._buttonLowered.setIcon(null);
                }
                return this._buttonLowered;
            }
            this._buttonRaised.setText(value.toString());
            if (ButtonTableHeader.this._currentSortedColumnIcon != null && column == ButtonTableHeader.this.getViewColumnIndex(ButtonTableHeader.this._currentlySortedModelIdx)) {
                this._buttonRaised.setIcon(ButtonTableHeader.this._currentSortedColumnIcon);
            } else {
                this._buttonRaised.setIcon(null);
            }
            return this._buttonRaised;
        }
    }

    class HeaderListener
    extends MouseAdapter
    implements MouseMotionListener {
        HeaderListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (ButtonTableHeader.this.getCursor().getType() == 11 || 1 != e.getButton()) {
                return;
            }
            ButtonTableHeader.this._pressed = true;
            if (-42 == ButtonTableHeader.this.table.convertColumnIndexToModel(ButtonTableHeader.this.columnAtPoint(e.getPoint()))) {
                return;
            }
            ButtonTableHeader.this._pressedViewColumnIdx = ButtonTableHeader.this.columnAtPoint(e.getPoint());
            ButtonTableHeader.this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (2 == e.getClickCount() && ButtonTableHeader.this.getCursor().getType() == 11) {
                int colIx = ButtonTableHeader.this.columnAtPoint(e.getPoint());
                Rectangle headerRect = ButtonTableHeader.this.getHeaderRect(colIx);
                int distToColBegin = e.getPoint().x - headerRect.x;
                int distToColEnd = headerRect.x + headerRect.width - e.getPoint().x;
                if (distToColBegin < distToColEnd && 0 < colIx && colIx < ButtonTableHeader.this.getColumnModel().getColumnCount()) {
                    --colIx;
                }
                ButtonTableHeader.this.adjustColWidth(colIx, true);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (ButtonTableHeader.this.getCursor().getType() == 11 || 1 != e.getButton()) {
                return;
            }
            if (-42 == ButtonTableHeader.this.table.convertColumnIndexToModel(ButtonTableHeader.this.columnAtPoint(e.getPoint()))) {
                ButtonTableHeader.this._pressed = false;
                ButtonTableHeader.this._dragged = false;
                return;
            }
            ButtonTableHeader.this._pressed = false;
            if (!ButtonTableHeader.this._dragged) {
                ButtonTableHeader.this._currentSortedColumnIcon = null;
                int column = ButtonTableHeader.this.getTable().convertColumnIndexToModel(ButtonTableHeader.this._pressedViewColumnIdx);
                TableModel tm = ButtonTableHeader.this.table.getModel();
                if (column > -1 && column < tm.getColumnCount() && tm instanceof SortableTableModel) {
                    ((SortableTableModel)tm).sortByColumn(column);
                    if (ColumnOrder.ASC == ((SortableTableModel)tm).getColumnOrder()) {
                        ButtonTableHeader.this._currentSortedColumnIcon = s_ascIcon;
                    } else if (ColumnOrder.DESC == ((SortableTableModel)tm).getColumnOrder()) {
                        ButtonTableHeader.this._currentSortedColumnIcon = s_descIcon;
                    } else {
                        ButtonTableHeader.this._currentSortedColumnIcon = null;
                    }
                    ButtonTableHeader.this._currentlySortedModelIdx = column;
                }
                ButtonTableHeader.this.repaint();
            }
            ButtonTableHeader.this._dragged = false;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            ButtonTableHeader.this._dragged = true;
            if (ButtonTableHeader.this._pressed) {
                ButtonTableHeader.this._pressed = false;
                ButtonTableHeader.this.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ButtonTableHeader.this._dragged = false;
        }
    }

    private final class TableDataListener
    implements TableModelListener {
        private TableDataListener() {
        }

        @Override
        public void tableChanged(TableModelEvent evt) {
            ButtonTableHeader.this._currentSortedColumnIcon = null;
            ButtonTableHeader.this._currentlySortedModelIdx = -1;
        }
    }
}

