/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class ChooserPreviewer
extends JComponent {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ChooserPreviewer.class);
    private int DFT_BYTES_TO_READ = 2048;
    private final JPanel _emptyPnl = new JPanel();
    private final JTextArea _textComponent = new JTextArea();
    private final JLabel _imageComponent = new JLabel();
    private Component _currentComponent;
    private JScrollPane _currentComponentSp;
    private JFileChooser _chooser;
    private ChooserListener _propChangeListener;

    public ChooserPreviewer() {
        this.createUserInterface();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.cleanup();
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JFileChooser)) continue;
            this._chooser = (JFileChooser)parent;
            break;
        }
        if (this._chooser != null) {
            this._propChangeListener = new ChooserListener();
            this._chooser.addPropertyChangeListener(this._propChangeListener);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.cleanup();
    }

    protected void cleanup() {
        if (this._chooser != null && this._propChangeListener != null) {
            this._chooser.removePropertyChangeListener(this._propChangeListener);
        }
        this._propChangeListener = null;
        this._chooser = null;
    }

    protected void fileChanged() {
        Component componentToUse = this._emptyPnl;
        File file = this._chooser.getSelectedFile();
        if (file != null && file.isFile() && file.canRead()) {
            String suffix = Utilities.getFileNameSuffix(file.getPath()).toLowerCase();
            componentToUse = suffix.equals("gif") || suffix.equals("jpg") || suffix.equals("jpeg") || suffix.equals("png") ? this.readImageFile(file) : this.readTextFile(file);
        }
        if (componentToUse != this._currentComponent) {
            this._currentComponentSp.setViewportView(componentToUse);
            this._currentComponent = componentToUse;
        }
    }

    protected Component readImageFile(File file) {
        ImageIcon icon = new ImageIcon(file.getPath());
        this._imageComponent.setIcon(icon);
        return this._imageComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Component readTextFile(File file) {
        StringBuffer buf = new StringBuffer(this.DFT_BYTES_TO_READ);
        if (file != null && file.isFile() && file.canRead()) {
            try {
                FileReader rdr = new FileReader(file);
                try {
                    char[] data = new char[this.DFT_BYTES_TO_READ];
                    int count = rdr.read(data, 0, data.length);
                    if (count != -1) {
                        buf.append(data, 0, count);
                    }
                }
                finally {
                    rdr.close();
                }
            }
            catch (IOException ex) {
                buf = new StringBuffer(s_stringMgr.getString("ChooserPreviewer.error", ex.toString()));
            }
        }
        this._textComponent.setText(buf.toString());
        this._textComponent.setCaretPosition(0);
        return this._textComponent;
    }

    private void createUserInterface() {
        this._textComponent.setEditable(false);
        this.setLayout(new BorderLayout());
        this._currentComponentSp = new JScrollPane(this._textComponent);
        this.add((Component)this._currentComponentSp, "Center");
        this.setPreferredSize(new Dimension(250, 0));
    }

    private class ChooserListener
    implements PropertyChangeListener {
        private ChooserListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("SelectedFileChangedProperty")) {
                ChooserPreviewer.this.fileChanged();
            }
        }
    }
}

