/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.exportData;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import jxl.Workbook;
import jxl.write.Boolean;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.gui.action.TableExportCsvController;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.AbstractDataExportFileWriter;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.IExportDataCell;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;

public class DataExportExcelWriter
extends AbstractDataExportFileWriter {
    private WritableWorkbook workbook;
    private WritableSheet sheet;
    private boolean withHeader = false;

    public DataExportExcelWriter(File file, TableExportCsvController ctrl, boolean includeHeaders, ProgressAbortCallback progressController) {
        super(file, ctrl, includeHeaders, progressController);
    }

    private WritableCell getXlsCell(ColumnDisplayDefinition colDef, int colIdx, int curRow, Object cellObj) {
        Boolean ret;
        if (null == cellObj) {
            return new Label(colIdx, curRow, this.getDataXLSAsString(cellObj));
        }
        if (null == colDef) {
            return new Label(colIdx, curRow, this.getDataXLSAsString(cellObj));
        }
        int colType = colDef.getSqlType();
        switch (colType) {
            case -7: 
            case 16: {
                ret = new Boolean(colIdx, curRow, ((java.lang.Boolean)cellObj).booleanValue());
                break;
            }
            case 4: {
                ret = new Number(colIdx, curRow, ((java.lang.Number)cellObj).doubleValue());
                break;
            }
            case -6: 
            case 5: {
                ret = new Number(colIdx, curRow, ((java.lang.Number)cellObj).doubleValue());
                break;
            }
            case 3: {
                ret = new Number(colIdx, curRow, ((java.lang.Number)cellObj).doubleValue());
                break;
            }
            case 2: {
                ret = new Number(colIdx, curRow, ((java.lang.Number)cellObj).doubleValue());
                break;
            }
            case 6: {
                ret = new Number(colIdx, curRow, ((java.lang.Number)cellObj).doubleValue());
                break;
            }
            case 8: {
                ret = new Number(colIdx, curRow, ((java.lang.Number)cellObj).doubleValue());
                break;
            }
            case 7: {
                ret = new Number(colIdx, curRow, ((java.lang.Number)cellObj).doubleValue());
                break;
            }
            case -5: {
                ret = new Number(colIdx, curRow, (double)Long.parseLong(cellObj.toString()));
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                long time = ((Date)cellObj).getTime();
                Calendar cal = Calendar.getInstance();
                cal.setTime((Date)cellObj);
                int offset = cal.get(15) + cal.get(16);
                long utcTime = time + (long)offset;
                if (utcTime < -2203891200000L) {
                    utcTime += 86400000L;
                }
                Date xlsUTCDate = new Date(utcTime);
                ret = new DateTime(colIdx, curRow, xlsUTCDate, DateTime.GMT);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                cellObj = CellComponentFactory.renderObject(cellObj, colDef);
                ret = new Label(colIdx, curRow, this.getDataXLSAsString(cellObj));
                break;
            }
            default: {
                cellObj = CellComponentFactory.renderObject(cellObj, colDef);
                ret = new Label(colIdx, curRow, this.getDataXLSAsString(cellObj));
            }
        }
        return ret;
    }

    private String getDataXLSAsString(Object cellObj) {
        if (cellObj == null) {
            return "";
        }
        return cellObj.toString().trim();
    }

    @Override
    protected void beforeWorking(File file) throws IOException {
        this.workbook = Workbook.createWorkbook((File)file);
        this.sheet = this.workbook.createSheet("Squirrel SQL Export", 0);
    }

    @Override
    protected void addHeaderCell(int colIdx, String columnName) throws Exception {
        this.withHeader = true;
        Label label = new Label(colIdx, 0, columnName);
        this.sheet.addCell((WritableCell)label);
    }

    @Override
    protected void addCell(IExportDataCell cell) throws Exception {
        WritableCell xlsCell = this.getCtrl().useGloablPrefsFormatting() ? this.getXlsCell(cell.getColumnDisplayDefinition(), cell.getColumnIndex(), this.calculateRowIdx(cell), cell.getObject()) : this.getXlsCell(null, cell.getColumnIndex(), this.calculateRowIdx(cell), cell.getObject());
        this.sheet.addCell(xlsCell);
    }

    private int calculateRowIdx(IExportDataCell cell) {
        if (this.withHeader) {
            return cell.getRowIndex() + 1;
        }
        return cell.getRowIndex();
    }

    @Override
    protected void afterWorking() throws Exception {
        this.workbook.write();
        this.workbook.close();
    }
}

