/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.workflow.simple.converter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.BpmnAutoLayout;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.workflow.simple.converter.WorkflowDefinitionConversionFactory;
import org.activiti.workflow.simple.converter.listener.WorkflowDefinitionConversionListener;
import org.activiti.workflow.simple.definition.ListStepDefinition;
import org.activiti.workflow.simple.definition.ParallelStepsDefinition;
import org.activiti.workflow.simple.definition.StepDefinition;
import org.activiti.workflow.simple.definition.WorkflowDefinition;
import org.activiti.workflow.simple.exception.SimpleWorkflowException;

public class WorkflowDefinitionConversion {
    protected WorkflowDefinition workflowDefinition;
    protected BpmnModel bpmnModel;
    protected Process process;
    protected Map<String, Object> additionalArtifacts;
    protected WorkflowDefinitionConversionFactory conversionFactory;
    protected String lastActivityId;
    protected HashMap<String, Integer> incrementalIdMapping;
    protected boolean sequenceflowGenerationEnabled = true;
    protected boolean updateLastActivityEnabled = true;

    WorkflowDefinitionConversion(WorkflowDefinitionConversionFactory factory) {
        this.conversionFactory = factory;
    }

    public WorkflowDefinitionConversion(WorkflowDefinitionConversionFactory factory, WorkflowDefinition workflowDefinition) {
        this(factory);
        this.workflowDefinition = workflowDefinition;
    }

    public void convert() {
        if (this.workflowDefinition == null) {
            throw new SimpleWorkflowException("Cannot start conversion: need to set a WorkflowDefinition first!");
        }
        this.incrementalIdMapping = new HashMap();
        this.additionalArtifacts = new HashMap<String, Object>();
        this.bpmnModel = new BpmnModel();
        this.process = new Process();
        this.bpmnModel.addProcess(this.process);
        if (this.conversionFactory.getAllWorkflowDefinitionConversionListeners() != null) {
            for (WorkflowDefinitionConversionListener conversionListener : this.conversionFactory.getAllWorkflowDefinitionConversionListeners()) {
                conversionListener.beforeStepsConversion(this);
            }
        }
        this.convertSteps(this.workflowDefinition.getSteps());
        if (this.conversionFactory.getAllWorkflowDefinitionConversionListeners() != null) {
            for (WorkflowDefinitionConversionListener conversionListener : this.conversionFactory.getAllWorkflowDefinitionConversionListeners()) {
                conversionListener.afterStepsConversion(this);
            }
        }
        BpmnAutoLayout bpmnAutoLayout = new BpmnAutoLayout(this.bpmnModel);
        bpmnAutoLayout.execute();
    }

    public void convertSteps(List<StepDefinition> stepDefinitions) {
        for (StepDefinition step : stepDefinitions) {
            this.conversionFactory.getStepConverterFor(step).convertStepDefinition(step, this);
        }
    }

    public void convertListParallelSteps(List<ListStepDefinition<ParallelStepsDefinition>> stepDefinitions) {
        for (ListStepDefinition<ParallelStepsDefinition> step : stepDefinitions) {
            this.conversionFactory.getStepConverterFor(step).convertStepDefinition(step, this);
        }
    }

    public String getUniqueNumberedId(String baseName) {
        Integer index = this.incrementalIdMapping.get(baseName);
        if (index == null) {
            index = 1;
            this.incrementalIdMapping.put(baseName, index);
        } else {
            index = index + 1;
            this.incrementalIdMapping.put(baseName, index);
        }
        return baseName + index;
    }

    public String getLastActivityId() {
        return this.lastActivityId;
    }

    public void setLastActivityId(String lastActivityId) {
        this.lastActivityId = lastActivityId;
    }

    public BpmnModel getBpmnModel() {
        return this.bpmnModel;
    }

    public void setBpmnModel(BpmnModel bpmnModel) {
        this.bpmnModel = bpmnModel;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public Object getArtifact(String artifactKey) {
        return this.additionalArtifacts.get(artifactKey);
    }

    public Map<String, Object> getAdditionalArtifacts() {
        return this.additionalArtifacts;
    }

    public void setArtifact(String artifactKey, Object artifact) {
        this.additionalArtifacts.put(artifactKey, artifact);
    }

    public WorkflowDefinition getWorkflowDefinition() {
        return this.workflowDefinition;
    }

    public void setWorkflowDefinition(WorkflowDefinition workflowDefinition) {
        this.workflowDefinition = workflowDefinition;
    }

    public boolean isSequenceflowGenerationEnabled() {
        return this.sequenceflowGenerationEnabled;
    }

    public void setSequenceflowGenerationEnabled(boolean sequenceflowGenerationEnabled) {
        this.sequenceflowGenerationEnabled = sequenceflowGenerationEnabled;
    }

    public boolean isUpdateLastActivityEnabled() {
        return this.updateLastActivityEnabled;
    }

    public void setUpdateLastActivityEnabled(boolean updateLastActivityEnabled) {
        this.updateLastActivityEnabled = updateLastActivityEnabled;
    }

    public WorkflowDefinitionConversionFactory getConversionFactory() {
        return this.conversionFactory;
    }

    public String getBpmn20Xml() {
        if (this.bpmnModel == null) {
            this.convert();
        }
        BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();
        return new String(bpmnXMLConverter.convertToXML(this.bpmnModel));
    }
}

