/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.calcite.adapter.druid.DimensionSpec;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.ExtractionFunction;

public class ExtractionDimensionSpec
implements DimensionSpec {
    private final String dimension;
    private final ExtractionFunction extractionFunction;
    private final String outputName;

    public ExtractionDimensionSpec(String dimension, ExtractionFunction extractionFunction, String outputName) {
        this.dimension = (String)Preconditions.checkNotNull((Object)dimension);
        this.extractionFunction = (ExtractionFunction)Preconditions.checkNotNull((Object)extractionFunction);
        this.outputName = outputName;
    }

    public String getOutputName() {
        return this.outputName;
    }

    @Override
    public void write(JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("type", "extraction");
        generator.writeStringField("dimension", this.dimension);
        DruidQuery.writeFieldIf(generator, "outputName", this.outputName);
        DruidQuery.writeField(generator, "extractionFn", this.extractionFunction);
        generator.writeEndObject();
    }
}

