/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import org.apache.calcite.adapter.druid.ExtractionDimensionSpec;
import org.apache.calcite.adapter.druid.ExtractionFunction;
import org.apache.calcite.adapter.druid.Granularity;
import org.apache.calcite.adapter.druid.TimeExtractionFunction;

public class TimeExtractionDimensionSpec
extends ExtractionDimensionSpec {
    public TimeExtractionDimensionSpec(ExtractionFunction extractionFunction, String outputName) {
        super("__time", extractionFunction, outputName);
    }

    public static TimeExtractionDimensionSpec makeFullTimeExtract(String outputName) {
        return new TimeExtractionDimensionSpec(TimeExtractionFunction.createDefault(), outputName);
    }

    public static TimeExtractionDimensionSpec makeTimeExtract(Granularity granularity, String outputName) {
        return new TimeExtractionDimensionSpec(TimeExtractionFunction.createExtractFromGranularity(granularity), outputName);
    }

    public static TimeExtractionDimensionSpec makeTimeFloor(Granularity granularity, String outputName) {
        TimeExtractionFunction fn = TimeExtractionFunction.createFloorFromGranularity(granularity);
        return new TimeExtractionDimensionSpec(fn, outputName);
    }
}

