/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.streaming.api.functions.sink.filesystem;

import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.Path;

/**
 * Listener about the status of file.
 */
@Internal
public interface FileLifeCycleListener<BucketID> {

	/**
	 * Notifies a new file has been opened.
	 *
	 * <p>Note that this does not mean that the file has been created in the file system. It is
	 * only created logically and the actual file will be generated after it is committed.
	 *
	 * @param bucketID The bucketID of newly opened file.
	 * @param newPath The path of newly opened file.
	 */
	void onPartFileOpened(BucketID bucketID, Path newPath);

}
