/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.graph.TransformationTranslator;
import org.apache.flink.streaming.util.graph.StreamGraphUtils;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class SimpleTransformationTranslator<OUT, T extends Transformation<OUT>>
implements TransformationTranslator<OUT, T> {
    @Override
    public Collection<Integer> translateForBatch(T transformation, TransformationTranslator.Context context) {
        Preconditions.checkNotNull(transformation);
        Preconditions.checkNotNull((Object)context);
        Collection<Integer> transformedIds = this.translateForBatchInternal(transformation, context);
        this.configure(transformation, context);
        return transformedIds;
    }

    @Override
    public Collection<Integer> translateForStreaming(T transformation, TransformationTranslator.Context context) {
        Preconditions.checkNotNull(transformation);
        Preconditions.checkNotNull((Object)context);
        Collection<Integer> transformedIds = this.translateForStreamingInternal(transformation, context);
        this.configure(transformation, context);
        return transformedIds;
    }

    protected abstract Collection<Integer> translateForBatchInternal(T var1, TransformationTranslator.Context var2);

    protected abstract Collection<Integer> translateForStreamingInternal(T var1, TransformationTranslator.Context var2);

    private void configure(T transformation, TransformationTranslator.Context context) {
        StreamNode streamNode;
        StreamGraph streamGraph = context.getStreamGraph();
        int transformationId = transformation.getId();
        StreamGraphUtils.configureBufferTimeout(streamGraph, transformationId, transformation, context.getDefaultBufferTimeout());
        if (transformation.getUid() != null) {
            streamGraph.setTransformationUID(transformationId, transformation.getUid());
        }
        if (transformation.getUserProvidedNodeHash() != null) {
            streamGraph.setTransformationUserHash(transformationId, transformation.getUserProvidedNodeHash());
        }
        StreamGraphUtils.validateTransformationUid(streamGraph, transformation);
        if (transformation.getMinResources() != null && transformation.getPreferredResources() != null) {
            streamGraph.setResources(transformationId, transformation.getMinResources(), transformation.getPreferredResources());
        }
        if ((streamNode = streamGraph.getStreamNode(transformationId)) != null && streamNode.getManagedMemoryOperatorScopeUseCaseWeights().isEmpty() && streamNode.getManagedMemorySlotScopeUseCases().isEmpty()) {
            streamNode.setManagedMemoryUseCaseWeights(transformation.getManagedMemoryOperatorScopeUseCaseWeights(), transformation.getManagedMemorySlotScopeUseCases());
        }
    }
}

