/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import org.apache.flink.util.Preconditions;

final class StreamingCommitterState<CommT> {
    private final List<CommT> committables;

    StreamingCommitterState(List<CommT> committables) {
        this.committables = (List)Preconditions.checkNotNull(committables);
    }

    StreamingCommitterState(NavigableMap<Long, List<CommT>> committablesPerCheckpoint) {
        this.committables = new ArrayList<CommT>();
        for (Map.Entry item : committablesPerCheckpoint.entrySet()) {
            this.committables.addAll((Collection)item.getValue());
        }
    }

    public List<CommT> getCommittables() {
        return this.committables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamingCommitterState that = (StreamingCommitterState)o;
        return this.committables.equals(that.committables);
    }

    public int hashCode() {
        return Objects.hash(this.committables);
    }
}

