/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeLookup;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.inference.utils.AdaptedCallContext;
import org.apache.flink.table.types.inference.utils.UnknownCallContext;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

@Internal
public final class TypeInferenceUtil {
    public static String generateSignature(String name, FunctionDefinition definition, TypeInference typeInference) {
        if (typeInference.getNamedArguments().isPresent() || typeInference.getTypedArguments().isPresent()) {
            return TypeInferenceUtil.formatNamedOrTypedArguments(name, typeInference);
        }
        return typeInference.getInputTypeStrategy().getExpectedSignatures(definition).stream().map(s -> TypeInferenceUtil.formatSignature(name, s)).collect(Collectors.joining("\n"));
    }

    public static Result runTypeInference(TypeInference typeInference, CallContext callContext, @Nullable SurroundingInfo surroundingInfo) {
        try {
            return TypeInferenceUtil.runTypeInferenceInternal(typeInference, callContext, surroundingInfo);
        }
        catch (ValidationException e) {
            throw new ValidationException(String.format("Invalid function call:\n%s(%s)", callContext.getName(), callContext.getArgumentDataTypes().stream().map(DataType::toString).collect(Collectors.joining(", "))), e);
        }
        catch (Throwable t) {
            throw new TableException(String.format("Unexpected error in type inference logic of function '%s'. This is a bug.", callContext.getName()), t);
        }
    }

    private static Result runTypeInferenceInternal(TypeInference typeInference, CallContext callContext, @Nullable SurroundingInfo surroundingInfo) {
        AdaptedCallContext adaptedCallContext;
        try {
            TypeInferenceUtil.validateArgumentCount(typeInference.getInputTypeStrategy().getArgumentCount(), callContext.getArgumentDataTypes().size(), true);
        }
        catch (ValidationException e) {
            throw TypeInferenceUtil.getInvalidInputException(typeInference, callContext, e);
        }
        try {
            adaptedCallContext = TypeInferenceUtil.adaptArguments(typeInference, callContext, surroundingInfo);
        }
        catch (ValidationException e) {
            throw TypeInferenceUtil.getInvalidInputException(typeInference, callContext, e);
        }
        return TypeInferenceUtil.inferTypes(adaptedCallContext, typeInference.getAccumulatorTypeStrategy().orElse(null), typeInference.getOutputTypeStrategy());
    }

    private static ValidationException getInvalidInputException(TypeInference typeInference, CallContext callContext, ValidationException cause) {
        return new ValidationException(String.format("Invalid input arguments. Expected signatures are:\n%s", TypeInferenceUtil.generateSignature(callContext.getName(), callContext.getFunctionDefinition(), typeInference)), cause);
    }

    private static String formatNamedOrTypedArguments(String name, TypeInference typeInference) {
        Optional<List<String>> optionalNames = typeInference.getNamedArguments();
        Optional<List<DataType>> optionalDataTypes = typeInference.getTypedArguments();
        int count = Math.max(optionalNames.map(List::size).orElse(0), optionalDataTypes.map(List::size).orElse(0));
        String arguments = IntStream.range(0, count).mapToObj(pos -> {
            StringBuilder builder = new StringBuilder();
            optionalNames.ifPresent(names -> builder.append((String)names.get(pos)).append(" => "));
            optionalDataTypes.ifPresent(dataTypes -> builder.append(((DataType)dataTypes.get(pos)).toString()));
            return builder.toString();
        }).collect(Collectors.joining(", "));
        return String.format("%s(%s)", name, arguments);
    }

    private static String formatSignature(String name, Signature s) {
        String arguments = s.getArguments().stream().map(TypeInferenceUtil::formatArgument).collect(Collectors.joining(", "));
        return String.format("%s(%s)", name, arguments);
    }

    private static String formatArgument(Signature.Argument arg) {
        StringBuilder stringBuilder = new StringBuilder();
        arg.getName().ifPresent(n -> stringBuilder.append((String)n).append(" "));
        stringBuilder.append(arg.getType());
        return stringBuilder.toString();
    }

    private static boolean validateArgumentCount(ArgumentCount argumentCount, int actualCount, boolean throwOnFailure) {
        int minCount = argumentCount.getMinCount().orElse(0);
        if (actualCount < minCount) {
            if (throwOnFailure) {
                throw new ValidationException(String.format("Invalid number of arguments. At least %d arguments expected but %d passed.", minCount, actualCount));
            }
            return false;
        }
        int maxCount = argumentCount.getMaxCount().orElse(Integer.MAX_VALUE);
        if (actualCount > maxCount) {
            if (throwOnFailure) {
                throw new ValidationException(String.format("Invalid number of arguments. At most %d arguments expected but %d passed.", maxCount, actualCount));
            }
            return false;
        }
        if (!argumentCount.isValidCount(actualCount)) {
            if (throwOnFailure) {
                throw new ValidationException(String.format("Invalid number of arguments. %d arguments passed.", actualCount));
            }
            return false;
        }
        return true;
    }

    private static AdaptedCallContext adaptArguments(TypeInference typeInference, CallContext callContext, @Nullable SurroundingInfo surroundingInfo) {
        List<DataType> actualTypes = callContext.getArgumentDataTypes();
        typeInference.getTypedArguments().ifPresent(dataTypes -> {
            if (actualTypes.size() != dataTypes.size()) {
                throw new ValidationException(String.format("Invalid number of arguments. %d arguments expected after argument expansion but %d passed.", dataTypes.size(), actualTypes.size()));
            }
        });
        AdaptedCallContext adaptedCallContext = TypeInferenceUtil.inferInputTypes(typeInference, callContext, surroundingInfo);
        List<DataType> expectedTypes = adaptedCallContext.getArgumentDataTypes();
        for (int pos = 0; pos < actualTypes.size(); ++pos) {
            DataType expectedType = expectedTypes.get(pos);
            DataType actualType = actualTypes.get(pos);
            if (LogicalTypeCasts.supportsImplicitCast(actualType.getLogicalType(), expectedType.getLogicalType())) continue;
            throw new ValidationException(String.format("Invalid argument type at position %d. Data type %s expected but %s passed.", pos, expectedType, actualType));
        }
        return adaptedCallContext;
    }

    private static AdaptedCallContext inferInputTypes(TypeInference typeInference, CallContext callContext, @Nullable SurroundingInfo surroundingInfo) {
        DataType outputType = surroundingInfo != null ? (DataType)surroundingInfo.inferOutputType(callContext.getDataTypeLookup()).orElse(null) : null;
        AdaptedCallContext adaptedCallContext = new AdaptedCallContext(callContext, outputType);
        typeInference.getTypedArguments().ifPresent(adaptedCallContext::setExpectedArguments);
        List<DataType> inferredDataTypes = typeInference.getInputTypeStrategy().inferInputTypes(adaptedCallContext, true).orElseThrow(() -> new ValidationException("Invalid input arguments."));
        if (inferredDataTypes.stream().anyMatch(TypeInferenceUtil::isUnknown)) {
            throw new ValidationException("Invalid use of untyped NULL in arguments.");
        }
        adaptedCallContext.setExpectedArguments(inferredDataTypes);
        return adaptedCallContext;
    }

    private static Result inferTypes(AdaptedCallContext adaptedCallContext, @Nullable TypeStrategy accumulatorTypeStrategy, TypeStrategy outputTypeStrategy) {
        Optional<DataType> potentialOutputType = outputTypeStrategy.inferType(adaptedCallContext);
        if (!potentialOutputType.isPresent()) {
            throw new ValidationException("Could not infer an output type for the given arguments.");
        }
        DataType outputType = potentialOutputType.get();
        if (TypeInferenceUtil.isUnknown(outputType)) {
            throw new ValidationException("Could not infer an output type for the given arguments. Untyped NULL received.");
        }
        if (adaptedCallContext.getFunctionDefinition().getKind() == FunctionKind.TABLE_AGGREGATE || adaptedCallContext.getFunctionDefinition().getKind() == FunctionKind.AGGREGATE) {
            if (accumulatorTypeStrategy == null) {
                return new Result(adaptedCallContext.getArgumentDataTypes(), outputType, outputType);
            }
            Optional<DataType> potentialAccumulatorType = accumulatorTypeStrategy.inferType(adaptedCallContext);
            if (!potentialAccumulatorType.isPresent()) {
                throw new ValidationException("Could not infer an accumulator type for the given arguments.");
            }
            DataType accumulatorType = potentialAccumulatorType.get();
            if (TypeInferenceUtil.isUnknown(accumulatorType)) {
                throw new ValidationException("Could not infer an accumulator type for the given arguments. Untyped NULL received.");
            }
            return new Result(adaptedCallContext.getArgumentDataTypes(), potentialAccumulatorType.get(), outputType);
        }
        return new Result(adaptedCallContext.getArgumentDataTypes(), null, outputType);
    }

    private static boolean isUnknown(DataType dataType) {
        return LogicalTypeChecks.hasRoot(dataType.getLogicalType(), LogicalTypeRoot.NULL);
    }

    private TypeInferenceUtil() {
    }

    public static final class Result {
        private final List<DataType> expectedArgumentTypes;
        @Nullable
        private final DataType accumulatorDataType;
        private final DataType outputDataType;

        public Result(List<DataType> expectedArgumentTypes, @Nullable DataType accumulatorDataType, DataType outputDataType) {
            this.expectedArgumentTypes = expectedArgumentTypes;
            this.accumulatorDataType = accumulatorDataType;
            this.outputDataType = outputDataType;
        }

        public List<DataType> getExpectedArgumentTypes() {
            return this.expectedArgumentTypes;
        }

        public Optional<DataType> getAccumulatorDataType() {
            return Optional.ofNullable(this.accumulatorDataType);
        }

        public DataType getOutputDataType() {
            return this.outputDataType;
        }
    }

    public static final class SurroundingInfo {
        private final String name;
        private final FunctionDefinition functionDefinition;
        private final TypeInference typeInference;
        private final int argumentCount;
        private final int innerCallPosition;

        public SurroundingInfo(String name, FunctionDefinition functionDefinition, TypeInference typeInference, int argumentCount, int innerCallPosition) {
            this.name = name;
            this.functionDefinition = functionDefinition;
            this.typeInference = typeInference;
            this.argumentCount = argumentCount;
            this.innerCallPosition = innerCallPosition;
        }

        private Optional<DataType> inferOutputType(DataTypeLookup lookup) {
            boolean isValidCount = TypeInferenceUtil.validateArgumentCount(this.typeInference.getInputTypeStrategy().getArgumentCount(), this.argumentCount, false);
            if (!isValidCount) {
                return Optional.empty();
            }
            UnknownCallContext callContext = new UnknownCallContext(lookup, this.name, this.functionDefinition, this.argumentCount);
            AdaptedCallContext adaptedContext = TypeInferenceUtil.adaptArguments(this.typeInference, callContext, null);
            return this.typeInference.getInputTypeStrategy().inferInputTypes(adaptedContext, false).map(dataTypes -> (DataType)dataTypes.get(this.innerCallPosition));
        }
    }
}

