/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.python.utils;

import java.lang.reflect.InvocationTargetException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.functions.python.PythonFunction;

@Internal
public enum PythonFunctionUtils {


    public static PythonFunction getPythonFunction(String fullyQualifiedName, ReadableConfig config) {
        try {
            Class<?> pythonFunctionFactory = Class.forName("org.apache.flink.client.python.PythonFunctionFactory", true, Thread.currentThread().getContextClassLoader());
            return (PythonFunction)pythonFunctionFactory.getMethod("getPythonFunction", String.class, ReadableConfig.class).invoke(null, fullyQualifiedName, config);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(String.format("Instantiating python function '%s' failed.", fullyQualifiedName), e);
        }
    }
}

