/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.util.ArrayList;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableFilter;
import org.apache.calcite.adapter.enumerable.EnumerableMergeJoin;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;

class EnumerableMergeJoinRule
extends ConverterRule {
    EnumerableMergeJoinRule() {
        super(LogicalJoin.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableMergeJoinRule");
    }

    @Override
    public RelNode convert(RelNode rel) {
        LogicalJoin join = (LogicalJoin)rel;
        JoinInfo info = join.analyzeCondition();
        if (join.getJoinType() != JoinRelType.INNER) {
            return null;
        }
        if (info.pairs().size() == 0) {
            return null;
        }
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
        ArrayList<RelCollation> collations = new ArrayList<RelCollation>();
        int offset = 0;
        for (Ord<RelNode> ord : Ord.zip(join.getInputs())) {
            RelTraitSet traits = ((RelNode)ord.e).getTraitSet().replace(EnumerableConvention.INSTANCE);
            if (!info.pairs().isEmpty()) {
                ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
                for (int key : info.keys().get(ord.i)) {
                    fieldCollations.add(new RelFieldCollation(key, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.LAST));
                }
                RelCollation collation = RelCollations.of(fieldCollations);
                collations.add(RelCollations.shift(collation, offset));
                traits = traits.replace(collation);
            }
            newInputs.add(EnumerableMergeJoinRule.convert((RelNode)ord.e, traits));
            offset += ((RelNode)ord.e).getRowType().getFieldCount();
        }
        RelNode left = (RelNode)newInputs.get(0);
        RelNode right = (RelNode)newInputs.get(1);
        RelOptCluster cluster = join.getCluster();
        RelTraitSet traitSet = join.getTraitSet().replace(EnumerableConvention.INSTANCE);
        if (!collations.isEmpty()) {
            traitSet = traitSet.replace(collations);
        }
        AbstractRelNode newRel = new EnumerableMergeJoin(cluster, traitSet, left, right, info.getEquiCondition(left, right, cluster.getRexBuilder()), join.getVariablesSet(), join.getJoinType());
        if (!info.isEqui()) {
            RexNode nonEqui = RexUtil.composeConjunction(cluster.getRexBuilder(), info.nonEquiConditions);
            newRel = new EnumerableFilter(cluster, newRel.getTraitSet(), newRel, nonEqui);
        }
        return newRel;
    }
}

