/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryArray;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.dataformat.BinaryMap;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.BinaryStringUtil;
import org.apache.flink.table.dataformat.BoxedWrapperRow;
import org.apache.flink.table.dataformat.DataFormatConverters;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.dataformat.JoinedRow;
import org.apache.flink.table.dataformat.SqlTimestamp;
import org.apache.flink.table.dataformat.util.BinaryRowUtil;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.codegen.CodeGenException;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.codegen.HashCodeGenerator$;
import org.apache.flink.table.runtime.dataview.StateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedHashFunction;
import org.apache.flink.table.runtime.generated.HashFunction;
import org.apache.flink.table.runtime.generated.NamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.generated.TableAggsHandleFunction;
import org.apache.flink.table.runtime.types.ClassLogicalTypeConverter;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.runtime.types.PlannerTypeUtils;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.runtime.util.MurmurHashUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.types.Row;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class CodeGenUtils$ {
    public static CodeGenUtils$ MODULE$;
    private final String DEFAULT_TIMEZONE_TERM;
    private final String DEFAULT_INPUT1_TERM;
    private final String DEFAULT_INPUT2_TERM;
    private final String DEFAULT_COLLECTOR_TERM;
    private final String DEFAULT_OUT_RECORD_TERM;
    private final String DEFAULT_OPERATOR_COLLECTOR_TERM;
    private final String DEFAULT_OUT_RECORD_WRITER_TERM;
    private final String DEFAULT_CONTEXT_TERM;
    private final String BINARY_ROW;
    private final String BINARY_ARRAY;
    private final String BASE_ARRAY;
    private final String BINARY_GENERIC;
    private final String BINARY_STRING;
    private final String BINARY_MAP;
    private final String BASE_MAP;
    private final String BASE_ROW;
    private final String JOINED_ROW;
    private final String GENERIC_ROW;
    private final String DECIMAL_TERM;
    private final String SEGMENT;
    private final String AGGS_HANDLER_FUNCTION;
    private final String TABLE_AGGS_HANDLER_FUNCTION;
    private final String NAMESPACE_AGGS_HANDLER_FUNCTION;
    private final String STATE_DATA_VIEW_STORE;
    private final String STRING_UTIL;
    private final String SQL_TIMESTAMP;
    private final AtomicInteger nameCounter;

    static {
        new CodeGenUtils$();
    }

    public String DEFAULT_TIMEZONE_TERM() {
        return this.DEFAULT_TIMEZONE_TERM;
    }

    public String DEFAULT_INPUT1_TERM() {
        return this.DEFAULT_INPUT1_TERM;
    }

    public String DEFAULT_INPUT2_TERM() {
        return this.DEFAULT_INPUT2_TERM;
    }

    public String DEFAULT_COLLECTOR_TERM() {
        return this.DEFAULT_COLLECTOR_TERM;
    }

    public String DEFAULT_OUT_RECORD_TERM() {
        return this.DEFAULT_OUT_RECORD_TERM;
    }

    public String DEFAULT_OPERATOR_COLLECTOR_TERM() {
        return this.DEFAULT_OPERATOR_COLLECTOR_TERM;
    }

    public String DEFAULT_OUT_RECORD_WRITER_TERM() {
        return this.DEFAULT_OUT_RECORD_WRITER_TERM;
    }

    public String DEFAULT_CONTEXT_TERM() {
        return this.DEFAULT_CONTEXT_TERM;
    }

    public String BINARY_ROW() {
        return this.BINARY_ROW;
    }

    public String BINARY_ARRAY() {
        return this.BINARY_ARRAY;
    }

    public String BASE_ARRAY() {
        return this.BASE_ARRAY;
    }

    public String BINARY_GENERIC() {
        return this.BINARY_GENERIC;
    }

    public String BINARY_STRING() {
        return this.BINARY_STRING;
    }

    public String BINARY_MAP() {
        return this.BINARY_MAP;
    }

    public String BASE_MAP() {
        return this.BASE_MAP;
    }

    public String BASE_ROW() {
        return this.BASE_ROW;
    }

    public String JOINED_ROW() {
        return this.JOINED_ROW;
    }

    public String GENERIC_ROW() {
        return this.GENERIC_ROW;
    }

    public String DECIMAL_TERM() {
        return this.DECIMAL_TERM;
    }

    public String SEGMENT() {
        return this.SEGMENT;
    }

    public String AGGS_HANDLER_FUNCTION() {
        return this.AGGS_HANDLER_FUNCTION;
    }

    public String TABLE_AGGS_HANDLER_FUNCTION() {
        return this.TABLE_AGGS_HANDLER_FUNCTION;
    }

    public String NAMESPACE_AGGS_HANDLER_FUNCTION() {
        return this.NAMESPACE_AGGS_HANDLER_FUNCTION;
    }

    public String STATE_DATA_VIEW_STORE() {
        return this.STATE_DATA_VIEW_STORE;
    }

    public String STRING_UTIL() {
        return this.STRING_UTIL;
    }

    public String SQL_TIMESTAMP() {
        return this.SQL_TIMESTAMP;
    }

    private AtomicInteger nameCounter() {
        return this.nameCounter;
    }

    public String newName(String name) {
        return new StringBuilder(1).append(name).append("$").append(this.nameCounter().getAndIncrement()).toString();
    }

    public Seq<String> newNames(Seq<String> names) {
        Predef$.MODULE$.require(names.toSet().size() == names.length(), (Function0 & Serializable & scala.Serializable)() -> "Duplicated names");
        int newId = this.nameCounter().getAndIncrement();
        return (Seq)names.map((Function1 & Serializable & scala.Serializable)name -> new StringBuilder(1).append((String)name).append("$").append(newId).toString(), Seq$.MODULE$.canBuildFrom());
    }

    public <T> String className(Manifest<T> m) {
        return m.runtimeClass().getCanonicalName();
    }

    public String primitiveTypeTermForType(LogicalType t) {
        LogicalTypeRoot logicalTypeRoot = t.getTypeRoot();
        String string = LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) ? "int" : (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot) ? "long" : (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot) ? "short" : (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot) ? "byte" : (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot) ? "float" : (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot) ? "double" : (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot) ? "boolean" : (LogicalTypeRoot.DATE.equals(logicalTypeRoot) ? "int" : (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? "int" : (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot) ? "int" : (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot) ? "long" : this.boxedTypeTermForType(t)))))))))));
        return string;
    }

    public String boxedTypeTermForType(LogicalType t) {
        String string;
        LogicalTypeRoot logicalTypeRoot = t.getTypeRoot();
        if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot)) {
            string = this.className(ManifestFactory$.MODULE$.classType(Integer.class));
        } else if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot)) {
            string = this.className(ManifestFactory$.MODULE$.classType(Long.class));
        } else if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
            string = this.className(ManifestFactory$.MODULE$.classType(Short.class));
        } else if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
            string = this.className(ManifestFactory$.MODULE$.classType(Byte.class));
        } else if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
            string = this.className(ManifestFactory$.MODULE$.classType(Float.class));
        } else if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
            string = this.className(ManifestFactory$.MODULE$.classType(Double.class));
        } else if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
            string = this.className(ManifestFactory$.MODULE$.classType(Boolean.class));
        } else if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
            string = this.className(ManifestFactory$.MODULE$.classType(Integer.class));
        } else if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            string = this.className(ManifestFactory$.MODULE$.classType(Integer.class));
        } else if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)) {
            string = this.className(ManifestFactory$.MODULE$.classType(Integer.class));
        } else if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)) {
            string = this.className(ManifestFactory$.MODULE$.classType(Long.class));
        } else {
            boolean bl = LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot) ? true : LogicalTypeRoot.CHAR.equals(logicalTypeRoot);
            if (bl) {
                string = this.BINARY_STRING();
            } else {
                boolean bl2 = LogicalTypeRoot.VARBINARY.equals(logicalTypeRoot) ? true : LogicalTypeRoot.BINARY.equals(logicalTypeRoot);
                if (bl2) {
                    string = "byte[]";
                } else if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot)) {
                    string = this.className(ManifestFactory$.MODULE$.classType(Decimal.class));
                } else if (LogicalTypeRoot.ARRAY.equals(logicalTypeRoot)) {
                    string = this.className(ManifestFactory$.MODULE$.classType(BaseArray.class));
                } else {
                    boolean bl3 = LogicalTypeRoot.MULTISET.equals(logicalTypeRoot) ? true : LogicalTypeRoot.MAP.equals(logicalTypeRoot);
                    if (bl3) {
                        string = this.className(ManifestFactory$.MODULE$.classType(BaseMap.class));
                    } else if (LogicalTypeRoot.ROW.equals(logicalTypeRoot)) {
                        string = this.className(ManifestFactory$.MODULE$.classType(BaseRow.class));
                    } else {
                        boolean bl4 = LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot);
                        if (bl4) {
                            string = this.className(ManifestFactory$.MODULE$.classType(SqlTimestamp.class));
                        } else if (LogicalTypeRoot.RAW.equals(logicalTypeRoot)) {
                            string = this.className(ManifestFactory$.MODULE$.classType(BinaryGeneric.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                        } else {
                            throw new MatchError((Object)logicalTypeRoot);
                        }
                    }
                }
            }
        }
        return string;
    }

    public String boxedTypeTermForExternalType(DataType t) {
        return t.getConversionClass() == null ? ClassLogicalTypeConverter.getDefaultExternalClassForType((LogicalType)t.getLogicalType()).getCanonicalName() : t.getConversionClass().getCanonicalName();
    }

    public String primitiveDefaultValue(LogicalType t) {
        boolean bl;
        boolean bl2;
        LogicalTypeRoot logicalTypeRoot = t.getTypeRoot();
        boolean bl3 = LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot) ? true : LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot));
        String string = bl3 ? "-1" : (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot) ? "-1L" : (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot) ? "-1.0f" : (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot) ? "-1.0d" : (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot) ? "false" : ((bl2 = LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot) ? true : LogicalTypeRoot.CHAR.equals(logicalTypeRoot)) ? new StringBuilder(11).append(this.BINARY_STRING()).append(".EMPTY_UTF8").toString() : ((bl = LogicalTypeRoot.DATE.equals(logicalTypeRoot) ? true : LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) ? "-1" : (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot) ? "-1" : (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot) ? "-1L" : "null"))))))));
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInternalClass(DataType t) {
        Class clazz;
        Class clazz2 = clazz = t.getConversionClass();
        Class<Object> clazz3 = Object.class;
        if (clazz2 == null) {
            if (clazz3 == null) return false;
        } else if (clazz2.equals(clazz3)) return false;
        Class clazz4 = clazz;
        Class<Row> clazz5 = Row.class;
        if (clazz4 == null) {
            if (clazz5 == null) return false;
        } else if (clazz4.equals(clazz5)) return false;
        if (BaseRow.class.isAssignableFrom(clazz)) return true;
        Class clazz6 = clazz;
        Class clazz7 = ClassLogicalTypeConverter.getInternalClassForType((LogicalType)LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)t));
        if (clazz6 != null) {
            if (!clazz6.equals(clazz7)) return false;
            return true;
        }
        if (clazz7 == null) return true;
        return false;
    }

    public String hashCodeForType(CodeGeneratorContext ctx, LogicalType t, String term) {
        String string;
        LogicalTypeRoot logicalTypeRoot = t.getTypeRoot();
        if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
            string = new StringBuilder(11).append(this.className(ManifestFactory$.MODULE$.classType(Boolean.class))).append(".hashCode(").append(term).append(")").toString();
        } else if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
            string = new StringBuilder(11).append(this.className(ManifestFactory$.MODULE$.classType(Byte.class))).append(".hashCode(").append(term).append(")").toString();
        } else if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
            string = new StringBuilder(11).append(this.className(ManifestFactory$.MODULE$.classType(Short.class))).append(".hashCode(").append(term).append(")").toString();
        } else if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot)) {
            string = new StringBuilder(11).append(this.className(ManifestFactory$.MODULE$.classType(Integer.class))).append(".hashCode(").append(term).append(")").toString();
        } else if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot)) {
            string = new StringBuilder(11).append(this.className(ManifestFactory$.MODULE$.classType(Long.class))).append(".hashCode(").append(term).append(")").toString();
        } else if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
            string = new StringBuilder(11).append(this.className(ManifestFactory$.MODULE$.classType(Float.class))).append(".hashCode(").append(term).append(")").toString();
        } else if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
            string = new StringBuilder(11).append(this.className(ManifestFactory$.MODULE$.classType(Double.class))).append(".hashCode(").append(term).append(")").toString();
        } else {
            boolean bl = LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot) ? true : LogicalTypeRoot.CHAR.equals(logicalTypeRoot);
            if (bl) {
                string = new StringBuilder(11).append(term).append(".hashCode()").toString();
            } else {
                boolean bl2 = LogicalTypeRoot.VARBINARY.equals(logicalTypeRoot) ? true : LogicalTypeRoot.BINARY.equals(logicalTypeRoot);
                if (bl2) {
                    string = new StringBuilder(17).append(this.className(ManifestFactory$.MODULE$.classType(MurmurHashUtil.class))).append(".hashUnsafeBytes(").append(new StringBuilder(12).append(term).append(", ").append(BinaryRowUtil.BYTE_ARRAY_BASE_OFFSET).append(", ").append(term).append(".length)").toString()).toString();
                } else if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot)) {
                    string = new StringBuilder(11).append(term).append(".hashCode()").toString();
                } else if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
                    string = new StringBuilder(11).append(this.className(ManifestFactory$.MODULE$.classType(Integer.class))).append(".hashCode(").append(term).append(")").toString();
                } else if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
                    string = new StringBuilder(11).append(this.className(ManifestFactory$.MODULE$.classType(Integer.class))).append(".hashCode(").append(term).append(")").toString();
                } else {
                    boolean bl3 = LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot);
                    if (bl3) {
                        string = new StringBuilder(11).append(term).append(".hashCode()").toString();
                    } else if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)) {
                        string = new StringBuilder(11).append(this.className(ManifestFactory$.MODULE$.classType(Integer.class))).append(".hashCode(").append(term).append(")").toString();
                    } else if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)) {
                        string = new StringBuilder(11).append(this.className(ManifestFactory$.MODULE$.classType(Long.class))).append(".hashCode(").append(term).append(")").toString();
                    } else {
                        if (LogicalTypeRoot.ARRAY.equals(logicalTypeRoot)) {
                            throw new IllegalArgumentException(new StringBuilder(26).append("Not support type to hash: ").append(t).toString());
                        }
                        if (LogicalTypeRoot.ROW.equals(logicalTypeRoot)) {
                            RowType rowType = (RowType)t;
                            CodeGeneratorContext subCtx = CodeGeneratorContext$.MODULE$.apply(ctx.tableConfig());
                            GeneratedHashFunction genHash = HashCodeGenerator$.MODULE$.generateRowHash(subCtx, (LogicalType)rowType, "SubHashRow", (int[])RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), rowType.getFieldCount()).toArray(ClassTag$.MODULE$.Int()));
                            ctx.addReusableInnerClass(genHash.getClassName(), genHash.getCode());
                            String refs = ctx.addReusableObject(subCtx.references().toArray(ClassTag$.MODULE$.AnyRef()), "subRefs", ctx.addReusableObject$default$3());
                            String hashFunc = this.newName("hashFunc");
                            ctx.addReusableMember(new StringBuilder(2).append(HashFunction.class.getCanonicalName()).append(" ").append(hashFunc).append(";").toString());
                            ctx.addReusableInitStatement(new StringBuilder(10).append(hashFunc).append(" = new ").append(genHash.getClassName()).append("(").append(refs).append(");").toString());
                            string = new StringBuilder(11).append(hashFunc).append(".hashCode(").append(term).append(")").toString();
                        } else if (LogicalTypeRoot.RAW.equals(logicalTypeRoot)) {
                            TypeInformationRawType gt = (TypeInformationRawType)t;
                            String serTerm = ctx.addReusableObject(gt.getTypeInformation().createSerializer(new ExecutionConfig()), "serializer", ctx.addReusableObject$default$3());
                            string = new StringBuilder(46).append(this.BINARY_GENERIC()).append(".getJavaObjectFromBinaryGeneric(").append(term).append(", ").append(serTerm).append(").hashCode()").toString();
                        } else {
                            throw new MatchError((Object)logicalTypeRoot);
                        }
                    }
                }
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getNumericCastedResultTerm(GeneratedExpression expr, LogicalType targetType) {
        Tuple2 tuple2 = new Tuple2((Object)expr.resultType().getTypeRoot(), (Object)targetType.getTypeRoot());
        if (PlannerTypeUtils.isInteroperable((LogicalType)expr.resultType(), (LogicalType)targetType)) {
            return expr.resultTerm();
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot2 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot) && LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot2)) {
                return new StringBuilder(8).append("(short) ").append(expr.resultTerm()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot3 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot) && LogicalTypeRoot.INTEGER.equals(logicalTypeRoot3)) {
                return new StringBuilder(6).append("(int) ").append(expr.resultTerm()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot4 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot) && LogicalTypeRoot.BIGINT.equals(logicalTypeRoot4)) {
                return new StringBuilder(7).append("(long) ").append(expr.resultTerm()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot5 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot) && LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot5)) {
                DecimalType dt = (DecimalType)targetType;
                return new StringBuilder(10).append(Decimal.class.getCanonicalName()).append(".castFrom(").append(new StringBuilder(5).append(expr.resultTerm()).append(", ").append(dt.getPrecision()).append(", ").append(dt.getScale()).append(")").toString()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot6 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot) && LogicalTypeRoot.FLOAT.equals(logicalTypeRoot6)) {
                return new StringBuilder(8).append("(float) ").append(expr.resultTerm()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot7 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot) && LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot7)) {
                return new StringBuilder(9).append("(double) ").append(expr.resultTerm()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot8 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot) && LogicalTypeRoot.INTEGER.equals(logicalTypeRoot8)) {
                return new StringBuilder(6).append("(int) ").append(expr.resultTerm()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot9 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot) && LogicalTypeRoot.BIGINT.equals(logicalTypeRoot9)) {
                return new StringBuilder(7).append("(long) ").append(expr.resultTerm()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot10 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot) && LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot10)) {
                DecimalType dt = (DecimalType)targetType;
                return new StringBuilder(10).append(Decimal.class.getCanonicalName()).append(".castFrom(").append(new StringBuilder(5).append(expr.resultTerm()).append(", ").append(dt.getPrecision()).append(", ").append(dt.getScale()).append(")").toString()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot11 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot) && LogicalTypeRoot.FLOAT.equals(logicalTypeRoot11)) {
                return new StringBuilder(8).append("(float) ").append(expr.resultTerm()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot12 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot) && LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot12)) {
                return new StringBuilder(9).append("(double) ").append(expr.resultTerm()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot13 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) && LogicalTypeRoot.BIGINT.equals(logicalTypeRoot13)) {
                return new StringBuilder(7).append("(long) ").append(expr.resultTerm()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot14 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) && LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot14)) {
                DecimalType dt = (DecimalType)targetType;
                return new StringBuilder(10).append(Decimal.class.getCanonicalName()).append(".castFrom(").append(new StringBuilder(5).append(expr.resultTerm()).append(", ").append(dt.getPrecision()).append(", ").append(dt.getScale()).append(")").toString()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot15 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) && LogicalTypeRoot.FLOAT.equals(logicalTypeRoot15)) {
                return new StringBuilder(8).append("(float) ").append(expr.resultTerm()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot16 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) && LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot16)) {
                return new StringBuilder(9).append("(double) ").append(expr.resultTerm()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot17 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot) && LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot17)) {
                DecimalType dt = (DecimalType)targetType;
                return new StringBuilder(10).append(Decimal.class.getCanonicalName()).append(".castFrom(").append(new StringBuilder(5).append(expr.resultTerm()).append(", ").append(dt.getPrecision()).append(", ").append(dt.getScale()).append(")").toString()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot18 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot) && LogicalTypeRoot.FLOAT.equals(logicalTypeRoot18)) {
                return new StringBuilder(8).append("(float) ").append(expr.resultTerm()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot19 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot) && LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot19)) {
                return new StringBuilder(9).append("(double) ").append(expr.resultTerm()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot20 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot) && LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot20)) {
                DecimalType dt = (DecimalType)targetType;
                return new StringBuilder(15).append(Decimal.class.getCanonicalName()).append(".castToDecimal(").append(new StringBuilder(5).append(expr.resultTerm()).append(", ").append(dt.getPrecision()).append(", ").append(dt.getScale()).append(")").toString()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot21 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot) && LogicalTypeRoot.FLOAT.equals(logicalTypeRoot21)) {
                return new StringBuilder(14).append(Decimal.class.getCanonicalName()).append(".castToFloat(").append(expr.resultTerm()).append(")").toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot22 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot) && LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot22)) {
                return new StringBuilder(15).append(Decimal.class.getCanonicalName()).append(".castToDouble(").append(expr.resultTerm()).append(")").toString();
            }
        }
        if (tuple2 == null) return null;
        LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
        LogicalTypeRoot logicalTypeRoot23 = (LogicalTypeRoot)tuple2._2();
        if (!LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) return null;
        if (!LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot23)) return null;
        return new StringBuilder(9).append("(double) ").append(expr.resultTerm()).toString();
    }

    public String qualifyMethod(Method method) {
        return new StringBuilder(1).append(method.getDeclaringClass().getCanonicalName()).append(".").append(method.getName()).toString();
    }

    public String qualifyEnum(Enum<?> enum_) {
        return new StringBuilder(1).append(enum_.getClass().getCanonicalName()).append(".").append(enum_.name()).toString();
    }

    public boolean compareEnum(String term, Enum<?> enum_) {
        String string = term;
        String string2 = this.qualifyEnum(enum_);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public Enum<?> getEnum(GeneratedExpression genExpr) {
        String[] split = new StringOps(Predef$.MODULE$.augmentString(genExpr.resultTerm())).split('.');
        String value = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])split)).last();
        Class clazz = ((TypeInformationRawType)genExpr.resultType()).getTypeInformation().getTypeClass();
        return this.enumValueOf(clazz, value);
    }

    public <T extends Enum<T>> Enum<?> enumValueOf(Class<?> cls, String stringValue) {
        return Enum.valueOf(cls, stringValue);
    }

    public void requireNumeric(GeneratedExpression genExpr) {
        if (!TypeCheckUtils.isNumeric((LogicalType)genExpr.resultType())) {
            throw new CodeGenException(new StringBuilder(42).append("Numeric expression type expected, but was ").append(new StringBuilder(3).append("'").append(genExpr.resultType()).append("'.").toString()).toString());
        }
    }

    public void requireComparable(GeneratedExpression genExpr) {
        if (!TypeCheckUtils.isComparable((LogicalType)genExpr.resultType())) {
            throw new CodeGenException(new StringBuilder(37).append("Comparable type expected, but was '").append(genExpr.resultType()).append("'.").toString());
        }
    }

    public void requireCharacterString(GeneratedExpression genExpr) {
        if (!TypeCheckUtils.isCharacterString((LogicalType)genExpr.resultType())) {
            throw new CodeGenException("String expression type expected.");
        }
    }

    public void requireBoolean(GeneratedExpression genExpr) {
        if (!TypeCheckUtils.isBoolean((LogicalType)genExpr.resultType())) {
            throw new CodeGenException("Boolean expression type expected.");
        }
    }

    public void requireTemporal(GeneratedExpression genExpr) {
        if (!TypeCheckUtils.isTemporal((LogicalType)genExpr.resultType())) {
            throw new CodeGenException("Temporal expression type expected.");
        }
    }

    public void requireTimeInterval(GeneratedExpression genExpr) {
        if (!TypeCheckUtils.isTimeInterval((LogicalType)genExpr.resultType())) {
            throw new CodeGenException("Interval expression type expected.");
        }
    }

    public void requireArray(GeneratedExpression genExpr) {
        if (!TypeCheckUtils.isArray((LogicalType)genExpr.resultType())) {
            throw new CodeGenException("Array expression type expected.");
        }
    }

    public void requireMap(GeneratedExpression genExpr) {
        if (!TypeCheckUtils.isMap((LogicalType)genExpr.resultType())) {
            throw new CodeGenException("Map expression type expected.");
        }
    }

    public void requireInteger(GeneratedExpression genExpr) {
        if (!TypeCheckUtils.isInteger((LogicalType)genExpr.resultType())) {
            throw new CodeGenException("Integer expression type expected.");
        }
    }

    public String baseRowFieldReadAccess(CodeGeneratorContext ctx, int index, String rowTerm, LogicalType fieldType) {
        return this.baseRowFieldReadAccess(ctx, ((Object)BoxesRunTime.boxToInteger((int)index)).toString(), rowTerm, fieldType);
    }

    public String baseRowFieldReadAccess(CodeGeneratorContext ctx, String indexTerm, String rowTerm, LogicalType t) {
        String string;
        LogicalTypeRoot logicalTypeRoot = t.getTypeRoot();
        if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
            string = new StringBuilder(13).append(rowTerm).append(".getBoolean(").append(indexTerm).append(")").toString();
        } else if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
            string = new StringBuilder(10).append(rowTerm).append(".getByte(").append(indexTerm).append(")").toString();
        } else if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
            string = new StringBuilder(11).append(rowTerm).append(".getShort(").append(indexTerm).append(")").toString();
        } else if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot)) {
            string = new StringBuilder(9).append(rowTerm).append(".getInt(").append(indexTerm).append(")").toString();
        } else if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot)) {
            string = new StringBuilder(10).append(rowTerm).append(".getLong(").append(indexTerm).append(")").toString();
        } else if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
            string = new StringBuilder(11).append(rowTerm).append(".getFloat(").append(indexTerm).append(")").toString();
        } else if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
            string = new StringBuilder(12).append(rowTerm).append(".getDouble(").append(indexTerm).append(")").toString();
        } else {
            boolean bl = LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot) ? true : LogicalTypeRoot.CHAR.equals(logicalTypeRoot);
            if (bl) {
                string = new StringBuilder(12).append(rowTerm).append(".getString(").append(indexTerm).append(")").toString();
            } else {
                boolean bl2 = LogicalTypeRoot.VARBINARY.equals(logicalTypeRoot) ? true : LogicalTypeRoot.BINARY.equals(logicalTypeRoot);
                if (bl2) {
                    string = new StringBuilder(12).append(rowTerm).append(".getBinary(").append(indexTerm).append(")").toString();
                } else if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot)) {
                    DecimalType dt = (DecimalType)t;
                    string = new StringBuilder(17).append(rowTerm).append(".getDecimal(").append(indexTerm).append(", ").append(dt.getPrecision()).append(", ").append(dt.getScale()).append(")").toString();
                } else if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
                    string = new StringBuilder(9).append(rowTerm).append(".getInt(").append(indexTerm).append(")").toString();
                } else if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
                    string = new StringBuilder(9).append(rowTerm).append(".getInt(").append(indexTerm).append(")").toString();
                } else if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
                    TimestampType dt = (TimestampType)t;
                    string = new StringBuilder(17).append(rowTerm).append(".getTimestamp(").append(indexTerm).append(", ").append(dt.getPrecision()).append(")").toString();
                } else if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot)) {
                    LocalZonedTimestampType dt = (LocalZonedTimestampType)t;
                    string = new StringBuilder(17).append(rowTerm).append(".getTimestamp(").append(indexTerm).append(", ").append(dt.getPrecision()).append(")").toString();
                } else if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)) {
                    string = new StringBuilder(9).append(rowTerm).append(".getInt(").append(indexTerm).append(")").toString();
                } else if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)) {
                    string = new StringBuilder(10).append(rowTerm).append(".getLong(").append(indexTerm).append(")").toString();
                } else if (LogicalTypeRoot.ARRAY.equals(logicalTypeRoot)) {
                    string = new StringBuilder(11).append(rowTerm).append(".getArray(").append(indexTerm).append(")").toString();
                } else {
                    boolean bl3 = LogicalTypeRoot.MULTISET.equals(logicalTypeRoot) ? true : LogicalTypeRoot.MAP.equals(logicalTypeRoot);
                    if (bl3) {
                        string = new StringBuilder(9).append(rowTerm).append(".getMap(").append(indexTerm).append(")").toString();
                    } else if (LogicalTypeRoot.ROW.equals(logicalTypeRoot)) {
                        string = new StringBuilder(11).append(rowTerm).append(".getRow(").append(indexTerm).append(", ").append(((RowType)t).getFieldCount()).append(")").toString();
                    } else if (LogicalTypeRoot.RAW.equals(logicalTypeRoot)) {
                        string = new StringBuilder(13).append(rowTerm).append(".getGeneric(").append(indexTerm).append(")").toString();
                    } else {
                        throw new MatchError((Object)logicalTypeRoot);
                    }
                }
            }
        }
        return string;
    }

    public String baseRowSetField(CodeGeneratorContext ctx, Class<? extends BaseRow> rowClass, String rowTerm, String indexTerm, GeneratedExpression fieldExpr, Option<String> binaryRowWriterTerm) {
        String string;
        LogicalType fieldType = fieldExpr.resultType();
        String fieldTerm = fieldExpr.resultTerm();
        Class<? extends BaseRow> clazz = rowClass;
        Class<BinaryRow> clazz2 = BinaryRow.class;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            String string2;
            Option<String> option = binaryRowWriterTerm;
            if (option instanceof Some) {
                Some some = (Some)option;
                String writer = (String)some.value();
                String writeField = this.binaryWriterWriteField(ctx, indexTerm, fieldTerm, writer, fieldType);
                string2 = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(138).append("\n               |").append(fieldExpr.code()).append("\n               |if (").append(fieldExpr.nullTerm()).append(") {\n               |  ").append(this.binaryWriterWriteNull(indexTerm, writer, fieldType)).append(";\n               |} else {\n               |  ").append(writeField).append(";\n               |}\n             ").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(49).append("\n               |").append(fieldExpr.code()).append("\n               |").append(writeField).append(";\n             ").toString())).stripMargin();
            } else if (None$.MODULE$.equals(option)) {
                String writeField = this.binaryRowFieldSetAccess(indexTerm, rowTerm, fieldType, fieldTerm);
                string2 = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(138).append("\n               |").append(fieldExpr.code()).append("\n               |if (").append(fieldExpr.nullTerm()).append(") {\n               |  ").append(this.binaryRowSetNull(indexTerm, rowTerm, fieldType)).append(";\n               |} else {\n               |  ").append(writeField).append(";\n               |}\n             ").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(49).append("\n               |").append(fieldExpr.code()).append("\n               |").append(writeField).append(";\n             ").toString())).stripMargin();
            } else {
                throw new MatchError(option);
            }
            string = string2;
        } else {
            String writeField;
            Class<? extends BaseRow> clazz3 = rowClass;
            Class<GenericRow> clazz4 = GenericRow.class;
            if (clazz3 == null ? clazz4 != null : !clazz3.equals(clazz4)) {
                Class<? extends BaseRow> clazz5 = rowClass;
                Class<BoxedWrapperRow> clazz6 = BoxedWrapperRow.class;
                if (clazz5 != null ? !clazz5.equals(clazz6) : clazz6 != null) {
                    throw new UnsupportedOperationException(new StringBuilder(26).append("Not support set field for ").append(rowClass).toString());
                }
            }
            Class<? extends BaseRow> clazz7 = rowClass;
            Class<GenericRow> clazz8 = GenericRow.class;
            String string3 = !(clazz7 != null ? !clazz7.equals(clazz8) : clazz8 != null) ? new StringBuilder(14).append(rowTerm).append(".setField(").append(indexTerm).append(", ").append(fieldTerm).append(");").toString() : (writeField = this.boxedWrapperRowFieldSetAccess(rowTerm, indexTerm, fieldTerm, fieldType));
            string = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(123).append("\n           |").append(fieldExpr.code()).append("\n           |if (").append(fieldExpr.nullTerm()).append(") {\n           |  ").append(rowTerm).append(".setNullAt(").append(indexTerm).append(");\n           |} else {\n           |  ").append(writeField).append(";\n           |}\n          ").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(37).append("\n           |").append(fieldExpr.code()).append("\n           |").append(writeField).append(";\n         ").toString())).stripMargin();
        }
        return string;
    }

    public String binaryRowSetNull(int index, String rowTerm, LogicalType t) {
        return this.binaryRowSetNull(((Object)BoxesRunTime.boxToInteger((int)index)).toString(), rowTerm, t);
    }

    public String binaryRowSetNull(String indexTerm, String rowTerm, LogicalType t) {
        LocalZonedTimestampType localZonedTimestampType;
        TimestampType timestampType;
        DecimalType decimalType;
        LogicalType logicalType = t;
        String string = logicalType instanceof DecimalType && !Decimal.isCompact((int)(decimalType = (DecimalType)logicalType).getPrecision()) ? new StringBuilder(21).append(rowTerm).append(".setDecimal(").append(indexTerm).append(", null, ").append(decimalType.getPrecision()).append(")").toString() : (logicalType instanceof TimestampType && !SqlTimestamp.isCompact((int)(timestampType = (TimestampType)logicalType).getPrecision()) ? new StringBuilder(23).append(rowTerm).append(".setTimestamp(").append(indexTerm).append(", null, ").append(timestampType.getPrecision()).append(")").toString() : (logicalType instanceof LocalZonedTimestampType && !SqlTimestamp.isCompact((int)(localZonedTimestampType = (LocalZonedTimestampType)logicalType).getPrecision()) ? new StringBuilder(23).append(rowTerm).append(".setTimestamp(").append(indexTerm).append(", null, ").append(localZonedTimestampType.getPrecision()).append(")").toString() : new StringBuilder(12).append(rowTerm).append(".setNullAt(").append(indexTerm).append(")").toString()));
        return string;
    }

    public String binaryRowFieldSetAccess(int index, String binaryRowTerm, LogicalType fieldType, String fieldValTerm) {
        return this.binaryRowFieldSetAccess(((Object)BoxesRunTime.boxToInteger((int)index)).toString(), binaryRowTerm, fieldType, fieldValTerm);
    }

    public String binaryRowFieldSetAccess(String index, String binaryRowTerm, LogicalType t, String fieldValTerm) {
        String string;
        LogicalTypeRoot logicalTypeRoot = t.getTypeRoot();
        if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot)) {
            string = new StringBuilder(11).append(binaryRowTerm).append(".setInt(").append(index).append(", ").append(fieldValTerm).append(")").toString();
        } else if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot)) {
            string = new StringBuilder(12).append(binaryRowTerm).append(".setLong(").append(index).append(", ").append(fieldValTerm).append(")").toString();
        } else if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
            string = new StringBuilder(13).append(binaryRowTerm).append(".setShort(").append(index).append(", ").append(fieldValTerm).append(")").toString();
        } else if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
            string = new StringBuilder(12).append(binaryRowTerm).append(".setByte(").append(index).append(", ").append(fieldValTerm).append(")").toString();
        } else if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
            string = new StringBuilder(13).append(binaryRowTerm).append(".setFloat(").append(index).append(", ").append(fieldValTerm).append(")").toString();
        } else if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
            string = new StringBuilder(14).append(binaryRowTerm).append(".setDouble(").append(index).append(", ").append(fieldValTerm).append(")").toString();
        } else if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
            string = new StringBuilder(15).append(binaryRowTerm).append(".setBoolean(").append(index).append(", ").append(fieldValTerm).append(")").toString();
        } else if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
            string = new StringBuilder(11).append(binaryRowTerm).append(".setInt(").append(index).append(", ").append(fieldValTerm).append(")").toString();
        } else if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            string = new StringBuilder(11).append(binaryRowTerm).append(".setInt(").append(index).append(", ").append(fieldValTerm).append(")").toString();
        } else if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            TimestampType dt = (TimestampType)t;
            string = new StringBuilder(19).append(binaryRowTerm).append(".setTimestamp(").append(index).append(", ").append(fieldValTerm).append(", ").append(dt.getPrecision()).append(")").toString();
        } else if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot)) {
            LocalZonedTimestampType dt = (LocalZonedTimestampType)t;
            string = new StringBuilder(19).append(binaryRowTerm).append(".setTimestamp(").append(index).append(", ").append(fieldValTerm).append(", ").append(dt.getPrecision()).append(")").toString();
        } else if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)) {
            string = new StringBuilder(11).append(binaryRowTerm).append(".setInt(").append(index).append(", ").append(fieldValTerm).append(")").toString();
        } else if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)) {
            string = new StringBuilder(12).append(binaryRowTerm).append(".setLong(").append(index).append(", ").append(fieldValTerm).append(")").toString();
        } else if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot)) {
            DecimalType dt = (DecimalType)t;
            string = new StringBuilder(17).append(binaryRowTerm).append(".setDecimal(").append(index).append(", ").append(fieldValTerm).append(", ").append(dt.getPrecision()).append(")").toString();
        } else {
            throw new CodeGenException(new StringBuilder(60).append("Fail to find binary row field setter method of LogicalType ").append(t).append(".").toString());
        }
        return string;
    }

    public String boxedWrapperRowFieldSetAccess(String rowTerm, String indexTerm, String fieldTerm, LogicalType t) {
        LogicalTypeRoot logicalTypeRoot = t.getTypeRoot();
        String string = LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) ? new StringBuilder(11).append(rowTerm).append(".setInt(").append(indexTerm).append(", ").append(fieldTerm).append(")").toString() : (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot) ? new StringBuilder(12).append(rowTerm).append(".setLong(").append(indexTerm).append(", ").append(fieldTerm).append(")").toString() : (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot) ? new StringBuilder(13).append(rowTerm).append(".setShort(").append(indexTerm).append(", ").append(fieldTerm).append(")").toString() : (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot) ? new StringBuilder(12).append(rowTerm).append(".setByte(").append(indexTerm).append(", ").append(fieldTerm).append(")").toString() : (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot) ? new StringBuilder(13).append(rowTerm).append(".setFloat(").append(indexTerm).append(", ").append(fieldTerm).append(")").toString() : (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot) ? new StringBuilder(14).append(rowTerm).append(".setDouble(").append(indexTerm).append(", ").append(fieldTerm).append(")").toString() : (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot) ? new StringBuilder(15).append(rowTerm).append(".setBoolean(").append(indexTerm).append(", ").append(fieldTerm).append(")").toString() : (LogicalTypeRoot.DATE.equals(logicalTypeRoot) ? new StringBuilder(11).append(rowTerm).append(".setInt(").append(indexTerm).append(", ").append(fieldTerm).append(")").toString() : (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? new StringBuilder(11).append(rowTerm).append(".setInt(").append(indexTerm).append(", ").append(fieldTerm).append(")").toString() : (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot) ? new StringBuilder(11).append(rowTerm).append(".setInt(").append(indexTerm).append(", ").append(fieldTerm).append(")").toString() : (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot) ? new StringBuilder(12).append(rowTerm).append(".setLong(").append(indexTerm).append(", ").append(fieldTerm).append(")").toString() : new StringBuilder(25).append(rowTerm).append(".setNonPrimitiveValue(").append(indexTerm).append(", ").append(fieldTerm).append(")").toString()))))))))));
        return string;
    }

    public String binaryArraySetNull(int index, String arrayTerm, LogicalType t) {
        LogicalTypeRoot logicalTypeRoot = t.getTypeRoot();
        String string = LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot) ? new StringBuilder(17).append(arrayTerm).append(".setNullBoolean(").append(index).append(")").toString() : (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot) ? new StringBuilder(14).append(arrayTerm).append(".setNullByte(").append(index).append(")").toString() : (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot) ? new StringBuilder(15).append(arrayTerm).append(".setNullShort(").append(index).append(")").toString() : (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) ? new StringBuilder(13).append(arrayTerm).append(".setNullInt(").append(index).append(")").toString() : (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot) ? new StringBuilder(15).append(arrayTerm).append(".setNullFloat(").append(index).append(")").toString() : (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot) ? new StringBuilder(16).append(arrayTerm).append(".setNullDouble(").append(index).append(")").toString() : (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? new StringBuilder(13).append(arrayTerm).append(".setNullInt(").append(index).append(")").toString() : (LogicalTypeRoot.DATE.equals(logicalTypeRoot) ? new StringBuilder(13).append(arrayTerm).append(".setNullInt(").append(index).append(")").toString() : (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot) ? new StringBuilder(13).append(arrayTerm).append(".setNullInt(").append(index).append(")").toString() : new StringBuilder(14).append(arrayTerm).append(".setNullLong(").append(index).append(")").toString()))))))));
        return string;
    }

    public String binaryWriterWriteNull(int index, String writerTerm, LogicalType t) {
        return this.binaryWriterWriteNull(((Object)BoxesRunTime.boxToInteger((int)index)).toString(), writerTerm, t);
    }

    public String binaryWriterWriteNull(String indexTerm, String writerTerm, LogicalType t) {
        LocalZonedTimestampType localZonedTimestampType;
        TimestampType timestampType;
        DecimalType decimalType;
        LogicalType logicalType = t;
        String string = logicalType instanceof DecimalType && !Decimal.isCompact((int)(decimalType = (DecimalType)logicalType).getPrecision()) ? new StringBuilder(23).append(writerTerm).append(".writeDecimal(").append(indexTerm).append(", null, ").append(decimalType.getPrecision()).append(")").toString() : (logicalType instanceof TimestampType && !SqlTimestamp.isCompact((int)(timestampType = (TimestampType)logicalType).getPrecision()) ? new StringBuilder(25).append(writerTerm).append(".writeTimestamp(").append(indexTerm).append(", null, ").append(timestampType.getPrecision()).append(")").toString() : (logicalType instanceof LocalZonedTimestampType && !SqlTimestamp.isCompact((int)(localZonedTimestampType = (LocalZonedTimestampType)logicalType).getPrecision()) ? new StringBuilder(25).append(writerTerm).append(".writeTimestamp(").append(indexTerm).append(", null, ").append(localZonedTimestampType.getPrecision()).append(")").toString() : new StringBuilder(12).append(writerTerm).append(".setNullAt(").append(indexTerm).append(")").toString()));
        return string;
    }

    public String binaryWriterWriteField(CodeGeneratorContext ctx, int index, String fieldValTerm, String writerTerm, LogicalType fieldType) {
        return this.binaryWriterWriteField(ctx, ((Object)BoxesRunTime.boxToInteger((int)index)).toString(), fieldValTerm, writerTerm, fieldType);
    }

    public String binaryWriterWriteField(CodeGeneratorContext ctx, String indexTerm, String fieldValTerm, String writerTerm, LogicalType t) {
        String string;
        LogicalTypeRoot logicalTypeRoot = t.getTypeRoot();
        if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot)) {
            string = new StringBuilder(13).append(writerTerm).append(".writeInt(").append(indexTerm).append(", ").append(fieldValTerm).append(")").toString();
        } else if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot)) {
            string = new StringBuilder(14).append(writerTerm).append(".writeLong(").append(indexTerm).append(", ").append(fieldValTerm).append(")").toString();
        } else if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
            string = new StringBuilder(15).append(writerTerm).append(".writeShort(").append(indexTerm).append(", ").append(fieldValTerm).append(")").toString();
        } else if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
            string = new StringBuilder(14).append(writerTerm).append(".writeByte(").append(indexTerm).append(", ").append(fieldValTerm).append(")").toString();
        } else if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
            string = new StringBuilder(15).append(writerTerm).append(".writeFloat(").append(indexTerm).append(", ").append(fieldValTerm).append(")").toString();
        } else if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
            string = new StringBuilder(16).append(writerTerm).append(".writeDouble(").append(indexTerm).append(", ").append(fieldValTerm).append(")").toString();
        } else if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
            string = new StringBuilder(17).append(writerTerm).append(".writeBoolean(").append(indexTerm).append(", ").append(fieldValTerm).append(")").toString();
        } else {
            boolean bl = LogicalTypeRoot.VARBINARY.equals(logicalTypeRoot) ? true : LogicalTypeRoot.BINARY.equals(logicalTypeRoot);
            if (bl) {
                string = new StringBuilder(16).append(writerTerm).append(".writeBinary(").append(indexTerm).append(", ").append(fieldValTerm).append(")").toString();
            } else {
                boolean bl2 = LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot) ? true : LogicalTypeRoot.CHAR.equals(logicalTypeRoot);
                if (bl2) {
                    string = new StringBuilder(16).append(writerTerm).append(".writeString(").append(indexTerm).append(", ").append(fieldValTerm).append(")").toString();
                } else if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot)) {
                    DecimalType dt = (DecimalType)t;
                    string = new StringBuilder(19).append(writerTerm).append(".writeDecimal(").append(indexTerm).append(", ").append(fieldValTerm).append(", ").append(dt.getPrecision()).append(")").toString();
                } else if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
                    string = new StringBuilder(13).append(writerTerm).append(".writeInt(").append(indexTerm).append(", ").append(fieldValTerm).append(")").toString();
                } else if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
                    string = new StringBuilder(13).append(writerTerm).append(".writeInt(").append(indexTerm).append(", ").append(fieldValTerm).append(")").toString();
                } else if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
                    TimestampType dt = (TimestampType)t;
                    string = new StringBuilder(21).append(writerTerm).append(".writeTimestamp(").append(indexTerm).append(", ").append(fieldValTerm).append(", ").append(dt.getPrecision()).append(")").toString();
                } else if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot)) {
                    LocalZonedTimestampType dt = (LocalZonedTimestampType)t;
                    string = new StringBuilder(21).append(writerTerm).append(".writeTimestamp(").append(indexTerm).append(", ").append(fieldValTerm).append(", ").append(dt.getPrecision()).append(")").toString();
                } else if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)) {
                    string = new StringBuilder(13).append(writerTerm).append(".writeInt(").append(indexTerm).append(", ").append(fieldValTerm).append(")").toString();
                } else if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)) {
                    string = new StringBuilder(14).append(writerTerm).append(".writeLong(").append(indexTerm).append(", ").append(fieldValTerm).append(")").toString();
                } else if (LogicalTypeRoot.ARRAY.equals(logicalTypeRoot)) {
                    String ser = ctx.addReusableTypeSerializer(t);
                    string = new StringBuilder(17).append(writerTerm).append(".writeArray(").append(indexTerm).append(", ").append(fieldValTerm).append(", ").append(ser).append(")").toString();
                } else {
                    boolean bl3 = LogicalTypeRoot.MULTISET.equals(logicalTypeRoot) ? true : LogicalTypeRoot.MAP.equals(logicalTypeRoot);
                    if (bl3) {
                        String ser = ctx.addReusableTypeSerializer(t);
                        string = new StringBuilder(15).append(writerTerm).append(".writeMap(").append(indexTerm).append(", ").append(fieldValTerm).append(", ").append(ser).append(")").toString();
                    } else if (LogicalTypeRoot.ROW.equals(logicalTypeRoot)) {
                        String ser = ctx.addReusableTypeSerializer(t);
                        string = new StringBuilder(15).append(writerTerm).append(".writeRow(").append(indexTerm).append(", ").append(fieldValTerm).append(", ").append(ser).append(")").toString();
                    } else if (LogicalTypeRoot.RAW.equals(logicalTypeRoot)) {
                        String ser = ctx.addReusableTypeSerializer(t);
                        string = new StringBuilder(19).append(writerTerm).append(".writeGeneric(").append(indexTerm).append(", ").append(fieldValTerm).append(", ").append(ser).append(")").toString();
                    } else {
                        throw new MatchError((Object)logicalTypeRoot);
                    }
                }
            }
        }
        return string;
    }

    private boolean isConverterIdentity(DataType t) {
        return DataFormatConverters.getConverterForDataType((DataType)t) instanceof DataFormatConverters.IdentityConverter;
    }

    public String genToInternal(CodeGeneratorContext ctx, DataType t, String term) {
        return (String)this.genToInternal(ctx, t).apply((Object)term);
    }

    public Function1<String, String> genToInternal(CodeGeneratorContext ctx, DataType t) {
        Function1 & Serializable & scala.Serializable intersect;
        String iTerm = this.boxedTypeTermForType(LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)t));
        if (this.isConverterIdentity(t)) {
            intersect = (Function1 & Serializable & scala.Serializable)term -> new StringBuilder(3).append("(").append(iTerm).append(") ").append((String)term).toString();
        } else {
            String eTerm = this.boxedTypeTermForExternalType(t);
            String converter = ctx.addReusableObject(DataFormatConverters.getConverterForDataType((DataType)t), "converter", ctx.addReusableObject$default$3());
            intersect = (Function1 & Serializable & scala.Serializable)term -> new StringBuilder(19).append("(").append(iTerm).append(") ").append(converter).append(".toInternal((").append(eTerm).append(") ").append((String)term).append(")").toString();
        }
        return intersect;
    }

    public String genToInternalIfNeeded(CodeGeneratorContext ctx, DataType t, String term) {
        return this.isInternalClass(t) ? new StringBuilder(3).append("(").append(this.boxedTypeTermForType(LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)t))).append(") ").append(term).toString() : this.genToInternal(ctx, t, term);
    }

    public String genToExternal(CodeGeneratorContext ctx, DataType t, String term) {
        String string;
        String iTerm = this.boxedTypeTermForType(LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)t));
        if (this.isConverterIdentity(t)) {
            string = new StringBuilder(3).append("(").append(iTerm).append(") ").append(term).toString();
        } else {
            String eTerm = this.boxedTypeTermForExternalType(t);
            String converter = ctx.addReusableObject(DataFormatConverters.getConverterForDataType((DataType)t), "converter", ctx.addReusableObject$default$3());
            string = new StringBuilder(19).append("(").append(eTerm).append(") ").append(converter).append(".toExternal((").append(iTerm).append(") ").append(term).append(")").toString();
        }
        return string;
    }

    public String genToExternalIfNeeded(CodeGeneratorContext ctx, DataType t, String term) {
        return this.isInternalClass(t) ? new StringBuilder(3).append("(").append(this.boxedTypeTermForType(LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)t))).append(") ").append(term).toString() : this.genToExternal(ctx, t, term);
    }

    public String udfFieldName(UserDefinedFunction udf) {
        return new StringBuilder(9).append("function_").append(udf.functionIdentifier()).toString();
    }

    public String genLogInfo(String logTerm, String format, String argTerm) {
        return new StringBuilder(12).append(logTerm).append(".info(\"").append(format).append("\", ").append(argTerm).append(");").toString();
    }

    private CodeGenUtils$() {
        MODULE$ = this;
        this.DEFAULT_TIMEZONE_TERM = "timeZone";
        this.DEFAULT_INPUT1_TERM = "in1";
        this.DEFAULT_INPUT2_TERM = "in2";
        this.DEFAULT_COLLECTOR_TERM = "c";
        this.DEFAULT_OUT_RECORD_TERM = "out";
        this.DEFAULT_OPERATOR_COLLECTOR_TERM = "output";
        this.DEFAULT_OUT_RECORD_WRITER_TERM = "outWriter";
        this.DEFAULT_CONTEXT_TERM = "ctx";
        this.BINARY_ROW = this.className(ManifestFactory$.MODULE$.classType(BinaryRow.class));
        this.BINARY_ARRAY = this.className(ManifestFactory$.MODULE$.classType(BinaryArray.class));
        this.BASE_ARRAY = this.className(ManifestFactory$.MODULE$.classType(BaseArray.class));
        this.BINARY_GENERIC = this.className(ManifestFactory$.MODULE$.classType(BinaryGeneric.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        this.BINARY_STRING = this.className(ManifestFactory$.MODULE$.classType(BinaryString.class));
        this.BINARY_MAP = this.className(ManifestFactory$.MODULE$.classType(BinaryMap.class));
        this.BASE_MAP = this.className(ManifestFactory$.MODULE$.classType(BaseMap.class));
        this.BASE_ROW = this.className(ManifestFactory$.MODULE$.classType(BaseRow.class));
        this.JOINED_ROW = this.className(ManifestFactory$.MODULE$.classType(JoinedRow.class));
        this.GENERIC_ROW = this.className(ManifestFactory$.MODULE$.classType(GenericRow.class));
        this.DECIMAL_TERM = this.className(ManifestFactory$.MODULE$.classType(Decimal.class));
        this.SEGMENT = this.className(ManifestFactory$.MODULE$.classType(MemorySegment.class));
        this.AGGS_HANDLER_FUNCTION = this.className(ManifestFactory$.MODULE$.classType(AggsHandleFunction.class));
        this.TABLE_AGGS_HANDLER_FUNCTION = this.className(ManifestFactory$.MODULE$.classType(TableAggsHandleFunction.class));
        this.NAMESPACE_AGGS_HANDLER_FUNCTION = this.className(ManifestFactory$.MODULE$.classType(NamespaceAggsHandleFunction.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        this.STATE_DATA_VIEW_STORE = this.className(ManifestFactory$.MODULE$.classType(StateDataViewStore.class));
        this.STRING_UTIL = this.className(ManifestFactory$.MODULE$.classType(BinaryStringUtil.class));
        this.SQL_TIMESTAMP = this.className(ManifestFactory$.MODULE$.classType(SqlTimestamp.class));
        this.nameCounter = new AtomicInteger();
    }
}

