/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.batch;

import java.io.Serializable;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Util;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.operators.DamBehavior;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext$;
import org.apache.flink.table.planner.codegen.LongHashJoinGenerator$;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator$;
import org.apache.flink.table.planner.delegation.BatchPlanner;
import org.apache.flink.table.planner.plan.cost.FlinkCost$;
import org.apache.flink.table.planner.plan.cost.FlinkCostFactory;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode$;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchExecJoinBase;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistributionTraitDef$;
import org.apache.flink.table.planner.plan.utils.FlinkRelMdUtil$;
import org.apache.flink.table.planner.plan.utils.JoinUtil$;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.operators.join.HashJoinOperator;
import org.apache.flink.table.runtime.operators.join.HashJoinType;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple7;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t]b\u0001B\u0001\u0003\u0001U\u0011\u0011CQ1uG\",\u00050Z2ICND'j\\5o\u0015\t\u0019A!A\u0003cCR\u001c\u0007N\u0003\u0002\u0006\r\u0005A\u0001\u000f[=tS\u000e\fGN\u0003\u0002\b\u0011\u0005)an\u001c3fg*\u0011\u0011BC\u0001\u0005a2\fgN\u0003\u0002\f\u0019\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0007\u000f\u0003\u0015!\u0018M\u00197f\u0015\ty\u0001#A\u0003gY&t7N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\r\u000e\u0003\tI!!\u0007\u0002\u0003#\t\u000bGo\u00195Fq\u0016\u001c'j\\5o\u0005\u0006\u001cX\r\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u001d\u0003\u001d\u0019G.^:uKJ\u0004\"!H\u0011\u000e\u0003yQ!!C\u0010\u000b\u0005\u0001\u0002\u0012aB2bY\u000eLG/Z\u0005\u0003Ey\u0011QBU3m\u001fB$8\t\\;ti\u0016\u0014\b\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\u0011Q\u0014\u0018-\u001b;TKR\u0004\"!\b\u0014\n\u0005\u001dr\"a\u0003*fYR\u0013\u0018-\u001b;TKRD\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IAK\u0001\bY\u00164GOU3m!\tYc&D\u0001-\u0015\tis$A\u0002sK2L!a\f\u0017\u0003\u000fI+GNT8eK\"A\u0011\u0007\u0001B\u0001B\u0003%!&\u0001\u0005sS\u001eDGOU3m\u0011!\u0019\u0004A!A!\u0002\u0013!\u0014!C2p]\u0012LG/[8o!\t)\u0004(D\u00017\u0015\t9t$A\u0002sKbL!!\u000f\u001c\u0003\u000fI+\u0007PT8eK\"A1\b\u0001B\u0001B\u0003%A(\u0001\u0005k_&tG+\u001f9f!\ti\u0004)D\u0001?\u0015\tyD&\u0001\u0003d_J,\u0017BA!?\u0005-Qu.\u001b8SK2$\u0016\u0010]3\t\u0011\r\u0003!Q1A\u0005\u0002\u0011\u000b1\u0002\\3gi&\u001b()^5mIV\tQ\t\u0005\u0002G\u00136\tqIC\u0001I\u0003\u0015\u00198-\u00197b\u0013\tQuIA\u0004C_>dW-\u00198\t\u00111\u0003!\u0011!Q\u0001\n\u0015\u000bA\u0002\\3gi&\u001b()^5mI\u0002B\u0001B\u0014\u0001\u0003\u0006\u0004%\t\u0001R\u0001\fSN\u0014%o\\1eG\u0006\u001cH\u000f\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003F\u00031I7O\u0011:pC\u0012\u001c\u0017m\u001d;!\u0011!\u0011\u0006A!b\u0001\n\u0003!\u0015a\u0005;ss\u0012K7\u000f^5oGR\u0014U/\u001b7e%><\b\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B#\u0002)Q\u0014\u0018\u0010R5ti&t7\r\u001e\"vS2$'k\\<!\u0011\u00151\u0006\u0001\"\u0001X\u0003\u0019a\u0014N\\5u}QQ\u0001,\u0017.\\9vsv\fY1\u0011\u0005]\u0001\u0001\"B\u000eV\u0001\u0004a\u0002\"\u0002\u0013V\u0001\u0004)\u0003\"B\u0015V\u0001\u0004Q\u0003\"B\u0019V\u0001\u0004Q\u0003\"B\u001aV\u0001\u0004!\u0004\"B\u001eV\u0001\u0004a\u0004\"B\"V\u0001\u0004)\u0005\"\u0002(V\u0001\u0004)\u0005\"\u0002*V\u0001\u0004)\u0005BC2\u0001!\u0003\u0005\u0019\u0011)A\u0005I\u0006\u0019\u0001\u0010J\u0019\u0011\t\u0019+wmZ\u0005\u0003M\u001e\u0013a\u0001V;qY\u0016\u0014\u0004c\u0001$iU&\u0011\u0011n\u0012\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\r.L!\u0001\\$\u0003\u0007%sG\u000fC\u0004o\u0001\t\u0007I\u0011B8\u0002\u00111,g\r^&fsN,\u0012a\u001a\u0005\u0007c\u0002\u0001\u000b\u0011B4\u0002\u00131,g\r^&fsN\u0004\u0003bB:\u0001\u0005\u0004%Ia\\\u0001\ne&<\u0007\u000e^&fsNDa!\u001e\u0001!\u0002\u00139\u0017A\u0003:jO\"$8*Z=tA!Qq\u000f\u0001I\u0001\u0002\u0007\u0005\u000b\u0011\u00023\u0002\u0007a$#\u0007C\u0004z\u0001\t\u0007I\u0011A8\u0002\u0013\t,\u0018\u000e\u001c3LKf\u001c\bBB>\u0001A\u0003%q-\u0001\u0006ck&dGmS3zg\u0002Bq! \u0001C\u0002\u0013\u0005q.A\u0005qe>\u0014WmS3zg\"1q\u0010\u0001Q\u0001\n\u001d\f!\u0002\u001d:pE\u0016\\U-_:!\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000b\t\u0001BY;jY\u0012\u0014V\r\\\u000b\u0002U!9\u0011\u0011\u0002\u0001\u0005\u0002\u0005\u0015\u0011\u0001\u00039s_\n,'+\u001a7\t\u0013\u00055\u0001A1A\u0005\u0002\u0005=\u0011\u0001\u00045bg\"Tu.\u001b8UsB,WCAA\t!\u0011\t\u0019\"!\t\u000e\u0005\u0005U!\u0002BA\f\u00033\tAA[8j]*!\u00111DA\u000f\u0003%y\u0007/\u001a:bi>\u00148OC\u0002\u0002 1\tqA];oi&lW-\u0003\u0003\u0002$\u0005U!\u0001\u0004%bg\"Tu.\u001b8UsB,\u0007\u0002CA\u0014\u0001\u0001\u0006I!!\u0005\u0002\u001b!\f7\u000f\u001b&pS:$\u0016\u0010]3!\u0011\u001d\tY\u0003\u0001C!\u0003[\tAaY8qsRq\u0011qFA\u001b\u0003o\tY$a\u0010\u0002D\u0005\u0015\u0003cA\u001f\u00022%\u0019\u00111\u0007 \u0003\t){\u0017N\u001c\u0005\u0007I\u0005%\u0002\u0019A\u0013\t\u000f\u0005e\u0012\u0011\u0006a\u0001i\u0005i1m\u001c8eSRLwN\\#yaJDq!!\u0010\u0002*\u0001\u0007!&\u0001\u0003mK\u001a$\bbBA!\u0003S\u0001\rAK\u0001\u0006e&<\u0007\u000e\u001e\u0005\u0007w\u0005%\u0002\u0019\u0001\u001f\t\u000f\u0005\u001d\u0013\u0011\u0006a\u0001\u000b\u0006a1/Z7j\u0015>Lg\u000eR8oK\"9\u00111\n\u0001\u0005B\u00055\u0013\u0001D3ya2\f\u0017N\u001c+fe6\u001cH\u0003BA(\u0003+\u00022aKA)\u0013\r\t\u0019\u0006\f\u0002\n%\u0016dwK]5uKJD\u0001\"a\u0016\u0002J\u0001\u0007\u0011qJ\u0001\u0003a^Dq!a\u0017\u0001\t\u0003\ni&A\bd_6\u0004X\u000f^3TK247i\\:u)\u0019\ty&!\u001a\u0002nA\u0019Q$!\u0019\n\u0007\u0005\rdD\u0001\u0006SK2|\u0005\u000f^\"pgRDqaCA-\u0001\u0004\t9\u0007E\u0002\u001e\u0003SJ1!a\u001b\u001f\u00055\u0011V\r\\(qiBc\u0017M\u001c8fe\"A\u0011qNA-\u0001\u0004\t\t(\u0001\u0002ncB!\u00111OA=\u001b\t\t)HC\u0002\u0002x1\n\u0001\"\\3uC\u0012\fG/Y\u0005\u0005\u0003w\n)H\u0001\tSK2lU\r^1eCR\f\u0017+^3ss\"A\u0011q\u0010\u0001\u0005\u00029\t\t)A\ttQV4g\r\\3Ck&dGmQ8v]R$2A[AB\u0011!\ty'! A\u0002\u0005E\u0004bBAD\u0001\u0011\u0005\u0013\u0011R\u0001\u000eg\u0006$\u0018n\u001d4z)J\f\u0017\u000e^:\u0015\t\u0005-\u0015\u0011\u0013\t\u0005\r\u00065%&C\u0002\u0002\u0010\u001e\u0013aa\u00149uS>t\u0007bBAJ\u0003\u000b\u0003\r!J\u0001\u0011e\u0016\fX/\u001b:fIR\u0013\u0018-\u001b;TKRDq!a&\u0001\t\u0013\tI*A\u0012tCRL7OZ=Ue\u0006LGo](o\u001d>t'I]8bI\u000e\f7\u000f\u001e%bg\"Tu.\u001b8\u0015\t\u0005-\u00151\u0014\u0005\b\u0003'\u000b)\n1\u0001&\u0011\u001d\ty\n\u0001C!\u0003C\u000babZ3u\t\u0006l')\u001a5bm&|'/\u0006\u0002\u0002$B!\u0011QUAV\u001b\t\t9K\u0003\u0003\u0002\u001c\u0005%&bAA\u0010\u001d%!\u0011QVAT\u0005-!\u0015-\u001c\"fQ\u00064\u0018n\u001c:\t\u000f\u0005E\u0006\u0001\"\u0011\u00024\u0006iq-\u001a;J]B,HOT8eKN,\"!!.\u0011\r\u0005]\u0016\u0011YAc\u001b\t\tIL\u0003\u0003\u0002<\u0006u\u0016\u0001B;uS2T!!a0\u0002\t)\fg/Y\u0005\u0005\u0003\u0007\fIL\u0001\u0003MSN$\b\u0007BAd\u0003G\u0004\u0002\"!3\u0002P\u0006M\u0017q\\\u0007\u0003\u0003\u0017T1!!4\u0007\u0003\u0011)\u00070Z2\n\t\u0005E\u00171\u001a\u0002\t\u000bb,7MT8eKB!\u0011Q[An\u001b\t\t9NC\u0002\u0002Z*\t!\u0002Z3mK\u001e\fG/[8o\u0013\u0011\ti.a6\u0003\u0019\t\u000bGo\u00195QY\u0006tg.\u001a:\u0011\t\u0005\u0005\u00181\u001d\u0007\u0001\t1\t)/a,\u0002\u0002\u0003\u0005)\u0011AAt\u0005\ryF%M\t\u0005\u0003S\fy\u000fE\u0002G\u0003WL1!!<H\u0005\u001dqu\u000e\u001e5j]\u001e\u00042ARAy\u0013\r\t\u0019p\u0012\u0002\u0004\u0003:L\bbBA|\u0001\u0011\u0005\u0013\u0011`\u0001\u0011e\u0016\u0004H.Y2f\u0013:\u0004X\u000f\u001e(pI\u0016$b!a?\u0003\u0002\t\u0015\u0001c\u0001$\u0002~&\u0019\u0011q`$\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005\u0007\t)\u00101\u0001k\u0003=y'\u000fZ5oC2Le\u000eU1sK:$\b\u0002\u0003B\u0004\u0003k\u0004\rA!\u0003\u0002\u00199,w/\u00138qkRtu\u000eZ31\t\t-!q\u0002\t\t\u0003\u0013\fy-a5\u0003\u000eA!\u0011\u0011\u001dB\b\t1\u0011\tB!\u0002\u0002\u0002\u0003\u0005)\u0011AAt\u0005\ryFe\r\u0005\b\u0005+\u0001A\u0011\u000bB\f\u0003]!(/\u00198tY\u0006$X\rV8QY\u0006t\u0017J\u001c;fe:\fG\u000e\u0006\u0003\u0003\u001a\tU\u0002C\u0002B\u000e\u0005K\u0011I#\u0004\u0002\u0003\u001e)!!q\u0004B\u0011\u0003\r!\u0017m\u001a\u0006\u0004\u0005Gq\u0011aA1qS&!!q\u0005B\u000f\u00059!&/\u00198tM>\u0014X.\u0019;j_:\u0004BAa\u000b\u000325\u0011!Q\u0006\u0006\u0004\u0005_a\u0011A\u00033bi\u00064wN]7bi&!!1\u0007B\u0017\u0005\u001d\u0011\u0015m]3S_^Dqa\u0003B\n\u0001\u0004\t\u0019\u000e")
public class BatchExecHashJoin
extends BatchExecJoinBase {
    private final RelOptCluster cluster;
    private final boolean leftIsBuild;
    private final boolean isBroadcast;
    private final boolean tryDistinctBuildRow;
    private final /* synthetic */ Tuple2 x$1;
    private final int[] leftKeys;
    private final int[] rightKeys;
    private final /* synthetic */ Tuple2 x$2;
    private final int[] buildKeys;
    private final int[] probeKeys;
    private final HashJoinType hashJoinType;

    public boolean leftIsBuild() {
        return this.leftIsBuild;
    }

    public boolean isBroadcast() {
        return this.isBroadcast;
    }

    public boolean tryDistinctBuildRow() {
        return this.tryDistinctBuildRow;
    }

    private int[] leftKeys() {
        return this.leftKeys;
    }

    private int[] rightKeys() {
        return this.rightKeys;
    }

    public int[] buildKeys() {
        return this.buildKeys;
    }

    public int[] probeKeys() {
        return this.probeKeys;
    }

    public RelNode buildRel() {
        return this.leftIsBuild() ? this.getLeft() : this.getRight();
    }

    public RelNode probeRel() {
        return this.leftIsBuild() ? this.getRight() : this.getLeft();
    }

    public HashJoinType hashJoinType() {
        return this.hashJoinType;
    }

    @Override
    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new BatchExecHashJoin(this.cluster, traitSet, left, right, conditionExpr, joinType, this.leftIsBuild(), this.isBroadcast(), this.tryDistinctBuildRow());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("isBroadcast", "true", this.isBroadcast()).item("build", this.leftIsBuild() ? "left" : "right").itemIf("tryDistinctBuildRow", "true", this.tryDistinctBuildRow());
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        Tuple2 tuple2;
        Double leftRowCnt = mq.getRowCount(this.getLeft());
        Double rightRowCnt = mq.getRowCount(this.getRight());
        if (leftRowCnt == null || rightRowCnt == null) {
            return null;
        }
        double cpuCost = (double)FlinkCost$.MODULE$.HASH_CPU_COST() * (Predef$.MODULE$.Double2double(leftRowCnt) + Predef$.MODULE$.Double2double(rightRowCnt));
        Tuple2 tuple22 = tuple2 = this.leftIsBuild() ? new Tuple2((Object)leftRowCnt, (Object)FlinkRelMdUtil$.MODULE$.binaryRowAverageSize(this.getLeft())) : new Tuple2((Object)rightRowCnt, (Object)FlinkRelMdUtil$.MODULE$.binaryRowAverageSize(this.getRight()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Double buildRowCount = (Double)tuple2._1();
        Double buildRowSize = (Double)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)buildRowCount, (Object)buildRowSize);
        Tuple2 tuple24 = tuple23;
        Double buildRowCount2 = (Double)tuple24._1();
        Double buildRowSize2 = (Double)tuple24._2();
        double bucketSize = Predef$.MODULE$.Double2double(buildRowCount2) * (double)8 / (double)FlinkCost$.MODULE$.HASH_COLLISION_WEIGHT();
        double recordSize = Predef$.MODULE$.Double2double(buildRowCount2) * (Predef$.MODULE$.Double2double(buildRowSize2) + (double)4);
        double memCost = (bucketSize + recordSize) * (double)this.shuffleBuildCount(mq);
        FlinkCostFactory costFactory = (FlinkCostFactory)planner.getCostFactory();
        return costFactory.makeCost(Predef$.MODULE$.Double2double(mq.getRowCount(this)), cpuCost, 0.0, 0.0, memCost);
    }

    public int shuffleBuildCount(RelMetadataQuery mq) {
        int n;
        RelNode probeRel;
        RelNode relNode = probeRel = this.leftIsBuild() ? this.getRight() : this.getLeft();
        if (this.isBroadcast()) {
            double rowCount = Util.first(mq.getRowCount(probeRel), 1.0);
            double shuffleCount = rowCount * Predef$.MODULE$.Double2double(mq.getAverageRowSize(probeRel)) / (double)FlinkCost$.MODULE$.SQL_DEFAULT_PARALLELISM_WORKER_PROCESS_SIZE();
            n = Math.max(1, (int)shuffleCount);
        } else {
            n = 1;
        }
        return n;
    }

    @Override
    public Option<RelNode> satisfyTraits(RelTraitSet requiredTraitSet) {
        return !this.isBroadcast() ? this.satisfyTraitsOnNonBroadcastHashJoin(requiredTraitSet) : this.satisfyTraitsOnBroadcastJoin(requiredTraitSet, this.leftIsBuild());
    }

    private Option<RelNode> satisfyTraitsOnNonBroadcastHashJoin(RelTraitSet requiredTraitSet) {
        FlinkRelDistribution requiredDistribution = requiredTraitSet.getTrait(FlinkRelDistributionTraitDef$.MODULE$.INSTANCE());
        Tuple3<Object, FlinkRelDistribution, FlinkRelDistribution> tuple3 = this.satisfyHashDistributionOnNonBroadcastJoin(requiredDistribution);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        boolean canSatisfyDistribution = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
        FlinkRelDistribution leftRequiredDistribution = (FlinkRelDistribution)tuple3._2();
        FlinkRelDistribution rightRequiredDistribution = (FlinkRelDistribution)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)canSatisfyDistribution), (Object)leftRequiredDistribution, (Object)rightRequiredDistribution);
        Tuple3 tuple33 = tuple32;
        boolean canSatisfyDistribution2 = BoxesRunTime.unboxToBoolean((Object)tuple33._1());
        FlinkRelDistribution leftRequiredDistribution2 = (FlinkRelDistribution)tuple33._2();
        FlinkRelDistribution rightRequiredDistribution2 = (FlinkRelDistribution)tuple33._3();
        if (!canSatisfyDistribution2) {
            return None$.MODULE$;
        }
        Function1 & Serializable & scala.Serializable toRestrictHashDistributionByKeys = (Function1 & Serializable & scala.Serializable)distribution -> this.getCluster().getPlanner().emptyTraitSet().replace(FlinkConventions$.MODULE$.BATCH_PHYSICAL()).replace((RelTrait)distribution);
        RelTraitSet leftRequiredTraits = (RelTraitSet)toRestrictHashDistributionByKeys.apply((Object)leftRequiredDistribution2);
        RelTraitSet rightRequiredTraits = (RelTraitSet)toRestrictHashDistributionByKeys.apply((Object)rightRequiredDistribution2);
        RelNode newLeft = RelOptRule.convert(this.getLeft(), leftRequiredTraits);
        RelNode newRight = RelOptRule.convert(this.getRight(), rightRequiredTraits);
        RelTraitSet providedTraits = this.getTraitSet().replace(requiredDistribution);
        return new Some((Object)this.copy(providedTraits, JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelNode[]{newLeft, newRight})))));
    }

    @Override
    public DamBehavior getDamBehavior() {
        return this.hashJoinType().buildLeftSemiOrAnti() ? DamBehavior.FULL_DAM : DamBehavior.MATERIALIZING;
    }

    @Override
    public List<ExecNode<BatchPlanner, ?>> getInputNodes() {
        return JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.getInputs()).map((Function1 & Serializable & scala.Serializable)x$5 -> (ExecNode)((Object)x$5), Buffer$.MODULE$.canBuildFrom()));
    }

    @Override
    public void replaceInputNode(int ordinalInParent, ExecNode<BatchPlanner, ?> newInputNode) {
        this.replaceInput(ordinalInParent, (RelNode)((Object)newInputNode));
    }

    @Override
    public Transformation<BaseRow> translateToPlanInternal(BatchPlanner planner) {
        Tuple7 tuple7;
        TableConfig config = planner.getTableConfig();
        Transformation<?> lInput = this.getInputNodes().get(0).translateToPlan(planner);
        Transformation<?> rInput = this.getInputNodes().get(1).translateToPlan(planner);
        RowType lType = ((BaseRowTypeInfo)lInput.getOutputType()).toRowType();
        RowType rType = ((BaseRowTypeInfo)rInput.getOutputType()).toRowType();
        RowType keyType = RowType.of((LogicalType[])((LogicalType[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.leftKeys())).map((Function1 & Serializable & scala.Serializable)x$1 -> lType.getTypeAt(BoxesRunTime.unboxToInt((Object)x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)))));
        GeneratedJoinCondition condFunc = JoinUtil$.MODULE$.generateConditionFunction(config, this.cluster.getRexBuilder(), this.getJoinInfo(), (LogicalType)lType, (LogicalType)rType);
        GeneratedProjection lProj = ProjectionCodeGenerator$.MODULE$.generateProjection(CodeGeneratorContext$.MODULE$.apply(config), "HashJoinLeftProjection", lType, keyType, this.leftKeys());
        GeneratedProjection rProj = ProjectionCodeGenerator$.MODULE$.generateProjection(CodeGeneratorContext$.MODULE$.apply(config), "HashJoinRightProjection", rType, keyType, this.rightKeys());
        Tuple7 tuple72 = tuple7 = this.leftIsBuild() ? new Tuple7(lInput, rInput, (Object)lProj, (Object)rProj, (Object)lType, (Object)rType, (Object)BoxesRunTime.boxToBoolean((boolean)false)) : new Tuple7(rInput, lInput, (Object)rProj, (Object)lProj, (Object)rType, (Object)lType, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        if (tuple7 == null) {
            throw new MatchError((Object)tuple7);
        }
        Transformation build = (Transformation)tuple7._1();
        Transformation probe = (Transformation)tuple7._2();
        GeneratedProjection bProj = (GeneratedProjection)tuple7._3();
        GeneratedProjection pProj = (GeneratedProjection)tuple7._4();
        RowType bType = (RowType)tuple7._5();
        RowType pType = (RowType)tuple7._6();
        boolean reverseJoin = BoxesRunTime.unboxToBoolean((Object)tuple7._7());
        Tuple7 tuple73 = new Tuple7((Object)build, (Object)probe, (Object)bProj, (Object)pProj, (Object)bType, (Object)pType, (Object)BoxesRunTime.boxToBoolean((boolean)reverseJoin));
        Tuple7 tuple74 = tuple73;
        Transformation build2 = (Transformation)tuple74._1();
        Transformation probe2 = (Transformation)tuple74._2();
        GeneratedProjection bProj2 = (GeneratedProjection)tuple74._3();
        GeneratedProjection pProj2 = (GeneratedProjection)tuple74._4();
        RowType bType2 = (RowType)tuple74._5();
        RowType pType2 = (RowType)tuple74._6();
        boolean reverseJoin2 = BoxesRunTime.unboxToBoolean((Object)tuple74._7());
        RelMetadataQuery mq = this.getCluster().getMetadataQuery();
        int buildRowSize = (int)Util.first(mq.getAverageRowSize(this.buildRel()), 24.0);
        long buildRowCount = (long)Util.first(mq.getRowCount(this.buildRel()), 200000.0);
        long probeRowCount = (long)Util.first(mq.getRowCount(this.probeRel()), 200000.0);
        SimpleOperatorFactory operator = LongHashJoinGenerator$.MODULE$.support(this.hashJoinType(), keyType, this.filterNulls()) ? LongHashJoinGenerator$.MODULE$.gen(config, this.hashJoinType(), keyType, bType2, pType2, this.buildKeys(), this.probeKeys(), buildRowSize, buildRowCount, reverseJoin2, condFunc) : SimpleOperatorFactory.of((StreamOperator)HashJoinOperator.newHashJoinOperator((HashJoinType)this.hashJoinType(), (GeneratedJoinCondition)condFunc, (boolean)reverseJoin2, (boolean[])this.filterNulls(), (GeneratedProjection)bProj2, (GeneratedProjection)pProj2, (boolean)this.tryDistinctBuildRow(), (int)buildRowSize, (long)buildRowCount, (long)probeRowCount, (RowType)keyType));
        long managedMemory = MemorySize.parse((String)config.getConfiguration().getString(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_HASH_JOIN_MEMORY)).getBytes();
        return ExecNode$.MODULE$.createTwoInputTransformation(build2, probe2, this.getRelDetailedDescription(), operator, BaseRowTypeInfo.of((RowType)FlinkTypeFactory$.MODULE$.toLogicalRowType(this.getRowType())), probe2.getParallelism(), managedMemory);
    }

    public BatchExecHashJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode leftRel, RelNode rightRel, RexNode condition, JoinRelType joinType, boolean leftIsBuild, boolean isBroadcast, boolean tryDistinctBuildRow) {
        Tuple2 tuple2;
        this.cluster = cluster;
        this.leftIsBuild = leftIsBuild;
        this.isBroadcast = isBroadcast;
        this.tryDistinctBuildRow = tryDistinctBuildRow;
        super(cluster, traitSet, leftRel, rightRel, condition, joinType);
        Tuple2<int[], int[]> tuple22 = JoinUtil$.MODULE$.checkAndGetJoinKeys(this.keyPairs(), this.getLeft(), this.getRight(), true);
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        int[] leftKeys = (int[])tuple22._1();
        int[] rightKeys = (int[])tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)leftKeys, (Object)rightKeys);
        this.x$1 = tuple23;
        this.leftKeys = (int[])this.x$1._1();
        this.rightKeys = (int[])this.x$1._2();
        Tuple2 tuple24 = tuple2 = leftIsBuild ? new Tuple2((Object)this.leftKeys(), (Object)this.rightKeys()) : new Tuple2((Object)this.rightKeys(), (Object)this.leftKeys());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int[] buildKeys = (int[])tuple2._1();
        int[] probeKeys = (int[])tuple2._2();
        Tuple2 tuple25 = new Tuple2((Object)buildKeys, (Object)probeKeys);
        this.x$2 = tuple25;
        this.buildKeys = (int[])this.x$2._1();
        this.probeKeys = (int[])this.x$2._2();
        JoinRelType joinRelType = this.getJoinType();
        JoinRelType joinRelType2 = JoinRelType.SEMI;
        JoinRelType joinRelType3 = this.getJoinType();
        JoinRelType joinRelType4 = JoinRelType.ANTI;
        this.hashJoinType = HashJoinType.of((boolean)leftIsBuild, (boolean)this.getJoinType().generatesNullsOnRight(), (boolean)this.getJoinType().generatesNullsOnLeft(), (!(joinRelType != null ? !((Object)((Object)joinRelType)).equals((Object)joinRelType2) : joinRelType2 != null) ? 1 : 0) != 0, (!(joinRelType3 != null ? !((Object)((Object)joinRelType3)).equals((Object)joinRelType4) : joinRelType4 != null) ? 1 : 0) != 0);
    }
}

