/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Pair;

public class FlinkSemiAntiJoinProjectTransposeRule
extends RelOptRule {
    public static final FlinkSemiAntiJoinProjectTransposeRule INSTANCE = new FlinkSemiAntiJoinProjectTransposeRule(RelFactories.LOGICAL_BUILDER);

    private FlinkSemiAntiJoinProjectTransposeRule(RelBuilderFactory relBuilderFactory) {
        super(FlinkSemiAntiJoinProjectTransposeRule.operand(LogicalJoin.class, FlinkSemiAntiJoinProjectTransposeRule.some(FlinkSemiAntiJoinProjectTransposeRule.operand(LogicalProject.class, FlinkSemiAntiJoinProjectTransposeRule.any()), new RelOptRuleOperand[0])), relBuilderFactory, null);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        LogicalJoin join = (LogicalJoin)call.rel(0);
        LogicalProject project = (LogicalProject)call.rel(1);
        JoinRelType joinType = join.getJoinType();
        if (joinType != JoinRelType.SEMI && joinType != JoinRelType.ANTI) {
            return false;
        }
        for (RexNode p : project.getProjects()) {
            if (p instanceof RexInputRef) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalJoin join = (LogicalJoin)call.rel(0);
        LogicalProject project = (LogicalProject)call.rel(1);
        RexNode newCondition = this.adjustCondition(project, join);
        LogicalJoin newJoin = LogicalJoin.create(project.getInput(), join.getRight(), newCondition, join.getVariablesSet(), join.getJoinType());
        RelBuilder relBuilder = call.builder();
        relBuilder.push(newJoin);
        relBuilder.project(project.getProjects(), project.getRowType().getFieldNames());
        call.transformTo(relBuilder.build());
    }

    private RexNode adjustCondition(LogicalProject project, Join join) {
        RexBuilder rexBuilder = project.getCluster().getRexBuilder();
        RelDataTypeFactory typeFactory = rexBuilder.getTypeFactory();
        RelNode rightChild = join.getRight();
        RelDataType bottomInputRowType = SqlValidatorUtil.deriveJoinRowType(project.getInput().getRowType(), rightChild.getRowType(), JoinRelType.INNER, typeFactory, null, join.getSystemFieldList());
        RexProgramBuilder bottomProgramBuilder = new RexProgramBuilder(bottomInputRowType, rexBuilder);
        for (Pair<RexNode, String> pair : project.getNamedProjects()) {
            bottomProgramBuilder.addProject((RexNode)pair.left, (String)pair.right);
        }
        int nLeftFields = project.getInput().getRowType().getFieldCount();
        List<RelDataTypeField> rightFields = rightChild.getRowType().getFieldList();
        int nRightFields = rightFields.size();
        for (int i = 0; i < nRightFields; ++i) {
            RelDataTypeField field = rightFields.get(i);
            RexInputRef inputRef = rexBuilder.makeInputRef(field.getType(), i + nLeftFields);
            bottomProgramBuilder.addProject(inputRef, field.getName());
        }
        RexProgram bottomProgram = bottomProgramBuilder.getProgram();
        RelDataType topInputRowType = SqlValidatorUtil.deriveJoinRowType(project.getRowType(), rightChild.getRowType(), JoinRelType.INNER, typeFactory, null, join.getSystemFieldList());
        RexProgramBuilder topProgramBuilder = new RexProgramBuilder(topInputRowType, rexBuilder);
        topProgramBuilder.addIdentity();
        topProgramBuilder.addCondition(join.getCondition());
        RexProgram topProgram = topProgramBuilder.getProgram();
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(topProgram, bottomProgram, rexBuilder);
        return mergedProgram.expandLocalRef(mergedProgram.getCondition());
    }
}

