/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.expressions.converter.ExpressionConverter;
import org.apache.flink.table.planner.plan.rules.logical.PushFilterIntoTableSourceScanRule$;
import org.apache.flink.table.planner.plan.schema.FlinkPreparingTableBase;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.plan.utils.RexNodeExtractor$;
import org.apache.flink.table.sources.FilterableTableSource;
import org.apache.flink.table.sources.TableSource;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001'\t\t\u0003+^:i\r&dG/\u001a:J]R|G+\u00192mKN{WO]2f'\u000e\fgNU;mK*\u00111\u0001B\u0001\bY><\u0017nY1m\u0015\t)a!A\u0003sk2,7O\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ei\u0011A\u0006\u0006\u0003\u000f]Q!\u0001\u0007\b\u0002\u000f\r\fGnY5uK&\u0011!D\u0006\u0002\u000b%\u0016dw\n\u001d;Sk2,\u0007\"\u0002\u000f\u0001\t\u0003i\u0012A\u0002\u001fj]&$h\bF\u0001\u001f!\ty\u0002!D\u0001\u0003\u0011\u0015\t\u0003\u0001\"\u0011#\u0003\u001di\u0017\r^2iKN$\"aI\u0015\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\u000f\t{w\u000e\\3b]\")!\u0006\ta\u0001W\u0005!1-\u00197m!\t)B&\u0003\u0002.-\tq!+\u001a7PaR\u0014V\u000f\\3DC2d\u0007\"B\u0018\u0001\t\u0003\u0002\u0014aB8o\u001b\u0006$8\r\u001b\u000b\u0003cQ\u0002\"\u0001\n\u001a\n\u0005M*#\u0001B+oSRDQA\u000b\u0018A\u0002-BQA\u000e\u0001\u0005\n]\n!\u0003];tQ\u001aKG\u000e^3s\u0013:$xnU2b]R)\u0011\u0007O\u001dD\u0015\")!&\u000ea\u0001W!)!(\u000ea\u0001w\u00051a-\u001b7uKJ\u0004\"\u0001P!\u000e\u0003uR!AP \u0002\t\r|'/\u001a\u0006\u0003\u0001^\t1A]3m\u0013\t\u0011UH\u0001\u0004GS2$XM\u001d\u0005\u0006\tV\u0002\r!R\u0001\u0005g\u000e\fg\u000e\u0005\u0002G\u00116\tqI\u0003\u0002\u0004\u007f%\u0011\u0011j\u0012\u0002\u0011\u0019><\u0017nY1m)\u0006\u0014G.Z*dC:DQaS\u001bA\u00021\u000b1B]3m\u001fB$H+\u00192mKB\u0011Q\nU\u0007\u0002\u001d*\u0011qJB\u0001\u0007g\u000eDW-\\1\n\u0005Es%a\u0006$mS:\\\u0007K]3qCJLgn\u001a+bE2,')Y:f\u0011\u0015\u0019\u0006\u0001\"\u0003U\u00039\t\u0007\u000f\u001d7z!J,G-[2bi\u0016$B\u0001T+fM\")aK\u0015a\u0001/\u0006Q\u0001O]3eS\u000e\fG/Z:\u0011\u0007akv,D\u0001Z\u0015\tQ6,\u0001\u0003vi&d'\"\u0001/\u0002\t)\fg/Y\u0005\u0003=f\u0013A\u0001T5tiB\u0011\u0001mY\u0007\u0002C*\u0011!MC\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0002eC\nQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000b-\u0013\u0006\u0019\u0001'\t\u000b\u001d\u0014\u0006\u0019\u00015\u0002\u0017QL\b/\u001a$bGR|'/\u001f\t\u0003S2l\u0011A\u001b\u0006\u0003W~\nA\u0001^=qK&\u0011QN\u001b\u0002\u0013%\u0016dG)\u0019;b)f\u0004XMR1di>\u0014\u0018pB\u0003p\u0005!\u0005\u0001/A\u0011QkNDg)\u001b7uKJLe\u000e^8UC\ndWmU8ve\u000e,7kY1o%VdW\r\u0005\u0002 c\u001a)\u0011A\u0001E\u0001eN\u0011\u0011o\u001d\t\u0003IQL!!^\u0013\u0003\r\u0005s\u0017PU3g\u0011\u0015a\u0012\u000f\"\u0001x)\u0005\u0001\bbB=r\u0005\u0004%\tA_\u0001\t\u0013:\u001bF+\u0011(D\u000bV\tA\u0003\u0003\u0004}c\u0002\u0006I\u0001F\u0001\n\u0013:\u001bF+\u0011(D\u000b\u0002\u0002")
public class PushFilterIntoTableSourceScanRule
extends RelOptRule {
    public static RelOptRule INSTANCE() {
        return PushFilterIntoTableSourceScanRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        boolean bl;
        TableConfig config = call.getPlanner().getContext().unwrap(FlinkContext.class).getTableConfig();
        if (!config.getConfiguration().getBoolean(OptimizerConfigOptions.TABLE_OPTIMIZER_SOURCE_PREDICATE_PUSHDOWN_ENABLED)) {
            return false;
        }
        Filter filter = (Filter)call.rel(0);
        if (filter.getCondition() == null) {
            return false;
        }
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        TableSourceTable tableSourceTable = scan.getTable().unwrap(TableSourceTable.class);
        if (tableSourceTable != null) {
            TableSource tableSource;
            TableSourceTable tableSourceTable2 = tableSourceTable;
            TableSource tableSource2 = tableSourceTable2.tableSource();
            boolean bl2 = tableSource2 instanceof FilterableTableSource ? !((FilterableTableSource)(tableSource = tableSource2)).isFilterPushedDown() : false;
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        TableSourceTable table = (TableSourceTable)scan.getTable();
        this.pushFilterIntoScan(call, filter, scan, table);
    }

    private void pushFilterIntoScan(RelOptRuleCall call, Filter filter, LogicalTableScan scan, FlinkPreparingTableBase relOptTable) {
        RelBuilder relBuilder = call.builder();
        FlinkContext context = call.getPlanner().getContext().unwrap(FlinkContext.class);
        int maxCnfNodeCount = FlinkRelOptUtil$.MODULE$.getMaxCnfNodeCount(scan);
        Tuple2<Expression[], RexNode[]> tuple2 = RexNodeExtractor$.MODULE$.extractConjunctiveConditions(filter.getCondition(), maxCnfNodeCount, filter.getInput().getRowType().getFieldNames(), relBuilder.getRexBuilder(), context.getFunctionCatalog(), context.getCatalogManager(), TimeZone.getTimeZone(scan.getCluster().getPlanner().getContext().unwrap(FlinkContext.class).getTableConfig().getLocalTimeZone()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expression[] predicates = (Expression[])tuple2._1();
        RexNode[] unconvertedRexNodes = (RexNode[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)predicates, (Object)unconvertedRexNodes);
        Tuple2 tuple23 = tuple22;
        Expression[] predicates2 = (Expression[])tuple23._1();
        RexNode[] unconvertedRexNodes2 = (RexNode[])tuple23._2();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicates2)).isEmpty()) {
            return;
        }
        LinkedList<Expression> remainingPredicates = new LinkedList<Expression>();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicates2)).foreach((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)remainingPredicates.add(e)));
        FlinkPreparingTableBase newRelOptTable = this.applyPredicate(remainingPredicates, relOptTable, relBuilder.getTypeFactory());
        TableSource newTableSource = newRelOptTable.unwrap(TableSourceTable.class).tableSource();
        TableSource oldTableSource = relOptTable.unwrap(TableSourceTable.class).tableSource();
        if (((FilterableTableSource)newTableSource).isFilterPushedDown() && newTableSource.explainSource().equals(oldTableSource.explainSource())) {
            throw new TableException("Failed to push filter into table source! table source with pushdown capability must override and change explainSource() API to explain the pushdown applied!");
        }
        LogicalTableScan newScan = new LogicalTableScan(scan.getCluster(), scan.getTraitSet(), newRelOptTable);
        if (remainingPredicates.isEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unconvertedRexNodes2)).isEmpty()) {
            call.transformTo(newScan);
        } else {
            relBuilder.push(scan);
            ExpressionConverter converter = new ExpressionConverter(relBuilder);
            Buffer remainingConditions = ((BufferLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(remainingPredicates).map((Function1 & Serializable & scala.Serializable)x$2 -> (RexNode)x$2.accept((ExpressionVisitor)converter), Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unconvertedRexNodes2)));
            RexNode remainingCondition = (RexNode)remainingConditions.reduce((Function2 & Serializable & scala.Serializable)(l, r) -> relBuilder.and((RexNode)l, (RexNode)r));
            Filter newFilter = filter.copy(filter.getTraitSet(), newScan, remainingCondition);
            call.transformTo(newFilter);
        }
    }

    private FlinkPreparingTableBase applyPredicate(List<Expression> predicates, FlinkPreparingTableBase relOptTable, RelDataTypeFactory typeFactory) {
        FlinkStatistic flinkStatistic;
        int originPredicatesSize = predicates.size();
        TableSourceTable tableSourceTable = relOptTable.unwrap(TableSourceTable.class);
        FilterableTableSource filterableSource = (FilterableTableSource)tableSourceTable.tableSource();
        TableSource newTableSource = filterableSource.applyPredicate(predicates);
        int updatedPredicatesSize = predicates.size();
        FlinkStatistic statistic = tableSourceTable.getStatistic();
        if (originPredicatesSize == updatedPredicatesSize) {
            flinkStatistic = statistic;
        } else {
            FlinkStatistic flinkStatistic2 = statistic;
            FlinkStatistic flinkStatistic3 = FlinkStatistic$.MODULE$.UNKNOWN();
            flinkStatistic = !(flinkStatistic2 != null ? !flinkStatistic2.equals(flinkStatistic3) : flinkStatistic3 != null) ? statistic : FlinkStatistic$.MODULE$.builder().statistic(statistic).tableStats(null).build();
        }
        FlinkStatistic newStatistic = flinkStatistic;
        return tableSourceTable.copy(newTableSource, newStatistic);
    }

    public PushFilterIntoTableSourceScanRule() {
        super(RelOptRule.operand(Filter.class, RelOptRule.operand(LogicalTableScan.class, RelOptRule.none()), new RelOptRuleOperand[0]), "PushFilterIntoTableSourceScanRule");
    }
}

