/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import org.apache.flink.annotation.Experimental;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.logical.SessionGroupWindow;
import org.apache.flink.table.planner.plan.utils.AggregateUtil$;
import org.apache.flink.table.planner.plan.utils.WindowEmitStrategy;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import scala.Predef$;

public final class WindowEmitStrategy$ {
    public static WindowEmitStrategy$ MODULE$;
    @Experimental
    private final ConfigOption<Boolean> TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED;
    @Experimental
    private final ConfigOption<String> TABLE_EXEC_EMIT_EARLY_FIRE_DELAY;
    @Experimental
    private final ConfigOption<Boolean> TABLE_EXEC_EMIT_LATE_FIRE_ENABLED;
    @Experimental
    private final ConfigOption<String> TABLE_EXEC_EMIT_LATE_FIRE_DELAY;

    static {
        new WindowEmitStrategy$();
    }

    public WindowEmitStrategy apply(TableConfig tableConfig, LogicalWindow window) {
        boolean isEventTime = AggregateUtil$.MODULE$.isRowtimeAttribute(window.timeAttribute());
        boolean isSessionWindow = window instanceof SessionGroupWindow;
        long allowLateness = isSessionWindow ? 0L : (tableConfig.getMinIdleStateRetentionTime() < 0L ? 0L : tableConfig.getMinIdleStateRetentionTime());
        boolean enableEarlyFireDelay = tableConfig.getConfiguration().getBoolean(this.TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED());
        Long earlyFireDelay = TableConfigUtils.getMillisecondFromConfigDuration(tableConfig, this.TABLE_EXEC_EMIT_EARLY_FIRE_DELAY());
        boolean enableLateFireDelay = tableConfig.getConfiguration().getBoolean(this.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED());
        Long lateFireDelay = TableConfigUtils.getMillisecondFromConfigDuration(tableConfig, this.TABLE_EXEC_EMIT_LATE_FIRE_DELAY());
        return new WindowEmitStrategy(Predef$.MODULE$.boolean2Boolean(isEventTime), Predef$.MODULE$.boolean2Boolean(isSessionWindow), earlyFireDelay, Predef$.MODULE$.boolean2Boolean(enableEarlyFireDelay), lateFireDelay, Predef$.MODULE$.boolean2Boolean(enableLateFireDelay), Predef$.MODULE$.long2Long(allowLateness));
    }

    public ConfigOption<Boolean> TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED() {
        return this.TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED;
    }

    public ConfigOption<String> TABLE_EXEC_EMIT_EARLY_FIRE_DELAY() {
        return this.TABLE_EXEC_EMIT_EARLY_FIRE_DELAY;
    }

    public ConfigOption<Boolean> TABLE_EXEC_EMIT_LATE_FIRE_ENABLED() {
        return this.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED;
    }

    public ConfigOption<String> TABLE_EXEC_EMIT_LATE_FIRE_DELAY() {
        return this.TABLE_EXEC_EMIT_LATE_FIRE_DELAY;
    }

    private WindowEmitStrategy$() {
        MODULE$ = this;
        this.TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED = ConfigOptions.key((String)"table.exec.emit.early-fire.enabled").defaultValue((Object)false).withDescription("Specifies whether to enable early-fire emit.Early-fire is an emit strategy before watermark advanced to end of window.");
        this.TABLE_EXEC_EMIT_EARLY_FIRE_DELAY = ConfigOptions.key((String)"table.exec.emit.early-fire.delay").noDefaultValue().withDescription("The early firing delay in milli second, early fire is the emit strategy before watermark advanced to end of window. < 0 is illegal configuration. 0 means no delay (fire on every element). > 0 means the fire interval. ");
        this.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED = ConfigOptions.key((String)"table.exec.emit.late-fire.enabled").defaultValue((Object)false).withDescription("Specifies whether to enable late-fire emit. Late-fire is an emit strategy after watermark advanced to end of window.");
        this.TABLE_EXEC_EMIT_LATE_FIRE_DELAY = ConfigOptions.key((String)"table.exec.emit.late-fire.delay").noDefaultValue().withDescription("The late firing delay in milli second, late fire is the emit strategy after watermark advanced to end of window. < 0 is illegal configuration. 0 means no delay (fire on every element). > 0 means the fire interval.");
    }
}

