/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.common;

import java.io.Serializable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.planner.plan.cost.FlinkCost$;
import org.apache.flink.table.planner.plan.cost.FlinkCostFactory;
import org.apache.flink.table.planner.plan.nodes.FlinkRelNode;
import org.apache.flink.table.planner.plan.nodes.physical.FlinkPhysicalRel;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000194Q!\u0001\u0002\u0002\u0002M\u0011acQ8n[>t\u0007\u000b[=tS\u000e\fG.\u0012=dQ\u0006tw-\u001a\u0006\u0003\u0007\u0011\taaY8n[>t'BA\u0003\u0007\u0003\u0015qw\u000eZ3t\u0015\t9\u0001\"\u0001\u0003qY\u0006t'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001)y\u0001\"!\u0006\u000f\u000e\u0003YQ!a\u0006\r\u0002\t\r|'/\u001a\u0006\u00033i\t1A]3m\u0015\tYb\"A\u0004dC2\u001c\u0017\u000e^3\n\u0005u1\"\u0001C#yG\"\fgnZ3\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0005\u0005\"\u0011\u0001\u00039isNL7-\u00197\n\u0005\r\u0002#\u0001\u0005$mS:\\\u0007\u000b[=tS\u000e\fGNU3m\u0011!)\u0003A!A!\u0002\u00131\u0013aB2mkN$XM\u001d\t\u0003O%j\u0011\u0001\u000b\u0006\u0003\u000fiI!A\u000b\u0015\u0003\u001bI+Gn\u00149u\u00072,8\u000f^3s\u0011!a\u0003A!A!\u0002\u0013i\u0013\u0001\u0003;sC&$8+\u001a;\u0011\u0005\u001dr\u0013BA\u0018)\u0005-\u0011V\r\u001c+sC&$8+\u001a;\t\u0011E\u0002!\u0011!Q\u0001\nI\nqA]3m\u001d>$W\r\u0005\u00024i5\t\u0001$\u0003\u000261\t9!+\u001a7O_\u0012,\u0007\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\u0002\u001fI,G\u000eR5tiJL'-\u001e;j_:\u0004\"aM\u001d\n\u0005iB\"a\u0004*fY\u0012K7\u000f\u001e:jEV$\u0018n\u001c8\t\u000bq\u0002A\u0011A\u001f\u0002\rqJg.\u001b;?)\u0015q\u0004)\u0011\"D!\ty\u0004!D\u0001\u0003\u0011\u0015)3\b1\u0001'\u0011\u0015a3\b1\u0001.\u0011\u0015\t4\b1\u00013\u0011\u001594\b1\u00019\u0011\u0015)\u0005\u0001\"\u0011G\u0003=\u0019w.\u001c9vi\u0016\u001cV\r\u001c4D_N$HcA$K\u001dB\u0011q\u0005S\u0005\u0003\u0013\"\u0012!BU3m\u001fB$8i\\:u\u0011\u0015IA\t1\u0001L!\t9C*\u0003\u0002NQ\ti!+\u001a7PaR\u0004F.\u00198oKJDQa\u0014#A\u0002A\u000b!!\\9\u0011\u0005E#V\"\u0001*\u000b\u0005MC\u0012\u0001C7fi\u0006$\u0017\r^1\n\u0005U\u0013&\u0001\u0005*fY6+G/\u00193bi\u0006\fV/\u001a:z\u0011\u00159\u0006\u0001\"\u0011Y\u00031)\u0007\u0010\u001d7bS:$VM]7t)\tIF\f\u0005\u000245&\u00111\f\u0007\u0002\n%\u0016dwK]5uKJDQ!\u0018,A\u0002e\u000b!\u0001]<\t\u000b}\u0003A\u0011\u00021\u0002)\u0011L7\u000f\u001e:jEV$\u0018n\u001c8U_N#(/\u001b8h)\u0005\t\u0007C\u00012l\u001d\t\u0019\u0017\u000e\u0005\u0002eO6\tQM\u0003\u0002g%\u00051AH]8pizR\u0011\u0001[\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001e\fa\u0001\u0015:fI\u00164\u0017B\u00017n\u0005\u0019\u0019FO]5oO*\u0011!n\u001a")
public abstract class CommonPhysicalExchange
extends Exchange
implements FlinkPhysicalRel {
    private final RelDistribution relDistribution;

    @Override
    public Option<RelNode> satisfyTraits(RelTraitSet requiredTraitSet) {
        return FlinkPhysicalRel.satisfyTraits$(this, requiredTraitSet);
    }

    @Override
    public String getRelDetailedDescription() {
        return FlinkRelNode.getRelDetailedDescription$(this);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable) {
        return FlinkRelNode.getExpressionString$(this, expr, inFields, localExprsTable);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionFormat) {
        return FlinkRelNode.getExpressionString$(this, expr, inFields, localExprsTable, expressionFormat);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost relOptCost;
        Double inputRows = mq.getRowCount(this.input);
        if (inputRows == null) {
            return null;
        }
        double inputSize = Predef$.MODULE$.Double2double(mq.getAverageRowSize(this.input)) * Predef$.MODULE$.Double2double(inputRows);
        FlinkCostFactory costFactory = (FlinkCostFactory)planner.getCostFactory();
        RelDistribution.Type type = this.relDistribution.getType();
        if (((Object)((Object)RelDistribution.Type.SINGLETON)).equals((Object)type)) {
            double cpuCost = (double)(FlinkCost$.MODULE$.SINGLETON_CPU_COST() + FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST()) * Predef$.MODULE$.Double2double(inputRows);
            relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, 0.0, inputSize, 0.0);
        } else if (((Object)((Object)RelDistribution.Type.RANDOM_DISTRIBUTED)).equals((Object)type)) {
            double cpuCost = (double)(FlinkCost$.MODULE$.RANDOM_CPU_COST() + FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST()) * Predef$.MODULE$.Double2double(inputRows);
            relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, 0.0, inputSize, 0.0);
        } else if (((Object)((Object)RelDistribution.Type.RANGE_DISTRIBUTED)).equals((Object)type)) {
            double cpuCost = (double)(FlinkCost$.MODULE$.RANGE_PARTITION_CPU_COST() + FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST()) * Predef$.MODULE$.Double2double(inputRows);
            double diskIoCost = inputSize;
            double networkCost = (double)2 * inputSize;
            relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, diskIoCost, networkCost, 0.0);
        } else if (((Object)((Object)RelDistribution.Type.BROADCAST_DISTRIBUTED)).equals((Object)type)) {
            int nParallelism = Math.max(1, (int)(inputSize / (double)FlinkCost$.MODULE$.SQL_DEFAULT_PARALLELISM_WORKER_PROCESS_SIZE()));
            double cpuCost = (double)nParallelism * Predef$.MODULE$.Double2double(inputRows) * (double)FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST();
            double networkCost = (double)nParallelism * inputSize;
            relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, 0.0, networkCost, 0.0);
        } else if (((Object)((Object)RelDistribution.Type.HASH_DISTRIBUTED)).equals((Object)type)) {
            double cpuCost = (double)(FlinkCost$.MODULE$.HASH_CPU_COST() * this.relDistribution.getKeys().size() + FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST()) * Predef$.MODULE$.Double2double(inputRows);
            relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, 0.0, inputSize, 0.0);
        } else if (((Object)((Object)RelDistribution.Type.ANY)).equals((Object)type)) {
            relOptCost = costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), (double)FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST() * Predef$.MODULE$.Double2double(inputRows), 0.0, inputSize, 0.0);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(34).append("not support RelDistribution: ").append((Object)this.relDistribution.getType()).append(" now!").toString());
        }
        return relOptCost;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return pw.input("input", this.getInput()).item("distribution", this.distributionToString());
    }

    private String distributionToString() {
        FlinkRelDistribution flinkRelDistribution = (FlinkRelDistribution)this.relDistribution;
        java.util.List<String> inputFieldNames = this.getInput().getRowType().getFieldNames();
        String exchangeName = this.relDistribution.getType().shortName;
        RelDistribution.Type type = this.relDistribution.getType();
        java.util.List list = ((Object)((Object)RelDistribution.Type.RANGE_DISTRIBUTED)).equals((Object)type) ? (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)flinkRelDistribution.getFieldCollations().get()).asScala()).map((Function1 & Serializable & scala.Serializable)fieldCollation -> {
            String name = (String)inputFieldNames.get(fieldCollation.getFieldIndex());
            return new StringBuilder(1).append(name).append(" ").append(fieldCollation.getDirection().shortString).toString();
        }, Buffer$.MODULE$.canBuildFrom())).asJava() : (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)flinkRelDistribution.getKeys()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)inputFieldNames.get(Predef$.MODULE$.Integer2int(x$1)), Buffer$.MODULE$.canBuildFrom())).asJava();
        java.util.List fieldNames = list;
        return fieldNames.isEmpty() ? exchangeName : new StringBuilder(0).append(exchangeName).append(fieldNames).toString();
    }

    public CommonPhysicalExchange(RelOptCluster cluster, RelTraitSet traitSet, RelNode relNode, RelDistribution relDistribution) {
        this.relDistribution = relDistribution;
        super(cluster, traitSet, relNode, relDistribution);
        FlinkRelNode.$init$(this);
        FlinkPhysicalRel.$init$(this);
    }
}

