/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import java.util.List;
import java.util.TimeZone;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.Util;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil$;
import org.apache.flink.table.planner.plan.utils.InputRefVisitor;
import org.apache.flink.table.planner.plan.utils.PartitionPruner$;
import org.apache.flink.table.planner.plan.utils.RefFieldAccessorVisitor;
import org.apache.flink.table.planner.plan.utils.RexNodeToExpressionConverter;
import org.apache.flink.table.planner.utils.Logging;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class RexNodeExtractor$
implements Logging {
    public static RexNodeExtractor$ MODULE$;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    static {
        new RexNodeExtractor$();
    }

    private Logger LOG$lzycompute() {
        RexNodeExtractor$ rexNodeExtractor$ = this;
        synchronized (rexNodeExtractor$) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    public int[] extractRefInputFields(List<RexNode> exprs) {
        InputRefVisitor visitor = new InputRefVisitor();
        JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(exprs).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.accept(visitor);
            return BoxedUnit.UNIT;
        });
        return visitor.getFields();
    }

    public List<String>[][] extractRefNestedInputFields(List<RexNode> exprs, int[] usedFields) {
        RefFieldAccessorVisitor visitor = new RefFieldAccessorVisitor(usedFields);
        JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(exprs).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.accept(visitor);
            return BoxedUnit.UNIT;
        });
        return visitor.getProjectedFields();
    }

    public Tuple2<Expression[], RexNode[]> extractConjunctiveConditions(RexNode expr, int maxCnfNodeCount, List<String> inputFieldNames, RexBuilder rexBuilder, FunctionCatalog functionCatalog, CatalogManager catalogManager, TimeZone timeZone) {
        SqlKind sqlKind = expr.getKind();
        SqlKind sqlKind2 = SqlKind.SEARCH;
        RexNode rewrite = !(sqlKind != null ? !((Object)((Object)sqlKind)).equals((Object)sqlKind2) : sqlKind2 != null) ? RexUtil.expandSearch(rexBuilder, null, expr) : expr;
        RexNode cnf = FlinkRexUtil$.MODULE$.toCnf(rexBuilder, maxCnfNodeCount, rewrite);
        List<RexNode> conjunctions = RelOptUtil.conjunctions(cnf);
        ArrayBuffer convertedExpressions = new ArrayBuffer();
        ArrayBuffer unconvertedRexNodes = new ArrayBuffer();
        String[] inputNames = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(inputFieldNames).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
        RexNodeToExpressionConverter converter = new RexNodeToExpressionConverter(rexBuilder, inputNames, functionCatalog, catalogManager, timeZone);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(conjunctions).asScala()).foreach((Function1 & Serializable & scala.Serializable)rex -> {
            ArrayBuffer arrayBuffer;
            Option<ResolvedExpression> option = rex.accept(converter);
            if (option instanceof Some) {
                Some some = (Some)option;
                ResolvedExpression expression = (ResolvedExpression)some.value();
                arrayBuffer = convertedExpressions.$plus$eq((Object)expression);
            } else if (None$.MODULE$.equals(option)) {
                arrayBuffer = unconvertedRexNodes.$plus$eq(rex);
            } else {
                throw new MatchError(option);
            }
            return arrayBuffer;
        });
        return new Tuple2(convertedExpressions.toArray(ClassTag$.MODULE$.apply(Expression.class)), unconvertedRexNodes.toArray(ClassTag$.MODULE$.apply(RexNode.class)));
    }

    @VisibleForTesting
    public Tuple2<RexNode, RexNode> extractPartitionPredicates(RexNode expr, int maxCnfNodeCount, String[] inputFieldNames, RexBuilder rexBuilder, String[] partitionFieldNames) {
        Tuple2<Seq<RexNode>, Seq<RexNode>> tuple2 = this.extractPartitionPredicateList(expr, maxCnfNodeCount, inputFieldNames, rexBuilder, partitionFieldNames);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq partitionPredicates = (Seq)tuple2._1();
        Seq nonPartitionPredicates = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionPredicates, (Object)nonPartitionPredicates);
        Tuple2 tuple23 = tuple22;
        Seq partitionPredicates2 = (Seq)tuple23._1();
        Seq nonPartitionPredicates2 = (Seq)tuple23._2();
        RexNode partitionPredicate = RexUtil.composeConjunction(rexBuilder, JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(partitionPredicates2));
        RexNode nonPartitionPredicate = RexUtil.composeConjunction(rexBuilder, JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(nonPartitionPredicates2));
        return new Tuple2((Object)partitionPredicate, (Object)nonPartitionPredicate);
    }

    public Tuple2<Seq<RexNode>, Seq<RexNode>> extractPartitionPredicateList(RexNode expr, int maxCnfNodeCount, String[] inputFieldNames, RexBuilder rexBuilder, String[] partitionFieldNames) {
        RexNode cnf = FlinkRexUtil$.MODULE$.toCnf(rexBuilder, maxCnfNodeCount, expr);
        List<RexNode> conjunctions = RelOptUtil.conjunctions(cnf);
        Tuple2 tuple2 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(conjunctions).partition((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)RexNodeExtractor$.MODULE$.isSupportedPartitionPredicate(x$4, partitionFieldNames, inputFieldNames)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Buffer partitionPredicates = (Buffer)tuple2._1();
        Buffer nonPartitionPredicates = (Buffer)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionPredicates, (Object)nonPartitionPredicates);
        Tuple2 tuple23 = tuple22;
        Buffer partitionPredicates2 = (Buffer)tuple23._1();
        Buffer nonPartitionPredicates2 = (Buffer)tuple23._2();
        return new Tuple2((Object)partitionPredicates2, (Object)nonPartitionPredicates2);
    }

    private boolean isSupportedPartitionPredicate(RexNode predicate, String[] partitionFieldNames, String[] inputFieldNames) {
        boolean bl;
        RexVisitorImpl<Object> visitor = new RexVisitorImpl<Object>(partitionFieldNames, inputFieldNames){
            private final String[] partitionFieldNames$2;
            private final String[] inputFieldNames$2;

            public boolean visitInputRef(RexInputRef inputRef) {
                String fieldName = this.inputFieldNames$2[inputRef.getIndex()];
                LogicalTypeRoot typeRoot = FlinkTypeFactory$.MODULE$.toLogicalType(inputRef.getType()).getTypeRoot();
                if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.partitionFieldNames$2)).contains((Object)fieldName) || !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])PartitionPruner$.MODULE$.supportedPartitionFieldTypes())).contains((Object)typeRoot)) {
                    throw new Util.FoundOne(BoxesRunTime.boxToBoolean((boolean)false));
                }
                return BoxesRunTime.unboxToBoolean(super.visitInputRef(inputRef));
            }

            public boolean visitLocalRef(RexLocalRef localRef) {
                throw new Util.FoundOne(BoxesRunTime.boxToBoolean((boolean)false));
            }

            public boolean visitOver(RexOver over) {
                throw new Util.FoundOne(BoxesRunTime.boxToBoolean((boolean)false));
            }

            public boolean visitCorrelVariable(RexCorrelVariable correlVariable) {
                throw new Util.FoundOne(BoxesRunTime.boxToBoolean((boolean)false));
            }

            public boolean visitDynamicParam(RexDynamicParam dynamicParam) {
                throw new Util.FoundOne(BoxesRunTime.boxToBoolean((boolean)false));
            }

            public boolean visitRangeRef(RexRangeRef rangeRef) {
                throw new Util.FoundOne(BoxesRunTime.boxToBoolean((boolean)false));
            }

            public boolean visitFieldAccess(RexFieldAccess fieldAccess) {
                throw new Util.FoundOne(BoxesRunTime.boxToBoolean((boolean)false));
            }

            public boolean visitSubQuery(RexSubQuery subQuery) {
                throw new Util.FoundOne(BoxesRunTime.boxToBoolean((boolean)false));
            }

            public boolean visitTableInputRef(RexTableInputRef ref) {
                throw new Util.FoundOne(BoxesRunTime.boxToBoolean((boolean)false));
            }

            public boolean visitPatternFieldRef(RexPatternFieldRef fieldRef) {
                throw new Util.FoundOne(BoxesRunTime.boxToBoolean((boolean)false));
            }
            {
                this.partitionFieldNames$2 = partitionFieldNames$2;
                this.inputFieldNames$2 = inputFieldNames$2;
                super(true);
            }
        };
        try {
            predicate.accept(visitor);
            bl = true;
        }
        catch (Util.FoundOne foundOne) {
            bl = false;
        }
        return bl;
    }

    private RexNodeExtractor$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

