/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.calcite.jdbc.CalciteSchemaBuilder;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.PlannerType;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.ComponentFactoryService;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.CollectModifyOperation;
import org.apache.flink.table.operations.ExternalModifyOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.OutputConversionModifyOperation;
import org.apache.flink.table.operations.UnregisteredSinkModifyOperation;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.calcite.SqlExprToRexConverter;
import org.apache.flink.table.planner.calcite.SqlExprToRexConverterFactory;
import org.apache.flink.table.planner.catalog.CatalogManagerCalciteSchema;
import org.apache.flink.table.planner.connectors.DynamicSinkUtils;
import org.apache.flink.table.planner.delegation.ExecutorBase;
import org.apache.flink.table.planner.delegation.ParserFactory;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.expressions.PlannerTypeInferenceUtilImpl;
import org.apache.flink.table.planner.hint.FlinkHints;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalLegacySink$;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraphGenerator;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ExecNodeGraphProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ProcessorContext;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.plan.nodes.physical.FlinkPhysicalRel;
import org.apache.flink.table.planner.plan.optimize.Optimizer;
import org.apache.flink.table.planner.plan.reuse.SubplanReuser$;
import org.apache.flink.table.planner.plan.utils.SameRelObjectShuttle;
import org.apache.flink.table.planner.sinks.DataStreamTableSink;
import org.apache.flink.table.planner.sinks.TableSinkUtils$;
import org.apache.flink.table.planner.utils.InternalConfigOptions;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil$;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.LegacyTypeInfoDataTypeConverter;
import org.apache.flink.table.utils.TableSchemaUtils;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r=b!B\u0001\u0003\u0003\u0003y!a\u0003)mC:tWM\u001d\"bg\u0016T!a\u0001\u0003\u0002\u0015\u0011,G.Z4bi&|gN\u0003\u0002\u0006\r\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001AA\u0002CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u0003\u0011a\u0017M\\4\u000b\u0003U\tAA[1wC&\u0011qC\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005eYR\"\u0001\u000e\u000b\u0005\r1\u0011B\u0001\u000f\u001b\u0005\u001d\u0001F.\u00198oKJD\u0001B\b\u0001\u0003\u0002\u0003\u0006IaH\u0001\tKb,7-\u001e;peB\u0011\u0011\u0004I\u0005\u0003Ci\u0011\u0001\"\u0012=fGV$xN\u001d\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u000511m\u001c8gS\u001e\u0004\"!\n\u0015\u000e\u0003\u0019R!a\n\u0004\u0002\u0007\u0005\u0004\u0018.\u0003\u0002*M\tYA+\u00192mK\u000e{gNZ5h\u0011!Y\u0003A!b\u0001\n\u0003a\u0013a\u00044v]\u000e$\u0018n\u001c8DCR\fGn\\4\u0016\u00035\u0002\"AL\u0019\u000e\u0003=R!\u0001\r\u0004\u0002\u000f\r\fG/\u00197pO&\u0011!g\f\u0002\u0010\rVt7\r^5p]\u000e\u000bG/\u00197pO\"AA\u0007\u0001B\u0001B\u0003%Q&\u0001\tgk:\u001cG/[8o\u0007\u0006$\u0018\r\\8hA!Aa\u0007\u0001BC\u0002\u0013\u0005q'\u0001\bdCR\fGn\\4NC:\fw-\u001a:\u0016\u0003a\u0002\"AL\u001d\n\u0005iz#AD\"bi\u0006dwnZ'b]\u0006<WM\u001d\u0005\ty\u0001\u0011\t\u0011)A\u0005q\u0005y1-\u0019;bY><W*\u00198bO\u0016\u0014\b\u0005\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0003=I7o\u0015;sK\u0006l\u0017N\\4N_\u0012,\u0007C\u0001!D\u001b\u0005\t%\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b%a\u0002\"p_2,\u0017M\u001c\u0005\u0006\r\u0002!\taR\u0001\u0007y%t\u0017\u000e\u001e \u0015\r!S5\nT'O!\tI\u0005!D\u0001\u0003\u0011\u0015qR\t1\u0001 \u0011\u0015\u0019S\t1\u0001%\u0011\u0015YS\t1\u0001.\u0011\u00151T\t1\u00019\u0011\u0015qT\t1\u0001@\u0011\u001d\u0001\u0006A1A\u0005\nE\u000bAd]9m\u000bb\u0004(\u000fV8SKb\u001cuN\u001c<feR,'OR1di>\u0014\u00180F\u0001S%\r\u0019\u0006c\u0016\u0004\u0005)V\u0003!K\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0003\u0004W\u0001\u0001\u0006IAU\u0001\u001egFdW\t\u001f9s)>\u0014V\r_\"p]Z,'\u000f^3s\r\u0006\u001cGo\u001c:zAA\u0011\u0001lW\u0007\u00023*\u0011!\fB\u0001\bG\u0006d7-\u001b;f\u0013\ta\u0016L\u0001\u000fTc2,\u0005\u0010\u001d:U_J+\u0007pQ8om\u0016\u0014H/\u001a:GC\u000e$xN]=\t\u0013y\u0003\u0001\u0019!a\u0001\n\u0013y\u0016A\u00029beN,'/F\u0001a!\tI\u0012-\u0003\u0002c5\t1\u0001+\u0019:tKJD\u0011\u0002\u001a\u0001A\u0002\u0003\u0007I\u0011B3\u0002\u0015A\f'o]3s?\u0012*\u0017\u000f\u0006\u0002gSB\u0011\u0001iZ\u0005\u0003Q\u0006\u0013A!\u00168ji\"9!nYA\u0001\u0002\u0004\u0001\u0017a\u0001=%c!IA\u000e\u0001a\u0001\u0002\u0003\u0006K\u0001Y\u0001\ba\u0006\u00148/\u001a:!\u0011\u001dq\u0007\u00011A\u0005\n=\fabY;se\u0016tG\u000fR5bY\u0016\u001cG/F\u0001q!\t)\u0013/\u0003\u0002sM\tQ1+\u001d7ES\u0006dWm\u0019;\t\u000fQ\u0004\u0001\u0019!C\u0005k\u0006\u00112-\u001e:sK:$H)[1mK\u000e$x\fJ3r)\t1g\u000fC\u0004kg\u0006\u0005\t\u0019\u00019\t\ra\u0004\u0001\u0015)\u0003q\u0003=\u0019WO\u001d:f]R$\u0015.\u00197fGR\u0004\u0003\u0002\u0003>\u0001\u0005\u0004%\t\u0001C>\u0002\u001dAd\u0017M\u001c8fe\u000e{g\u000e^3yiV\tA\u0010\u0005\u0002J{&\u0011aP\u0001\u0002\u000f!2\fgN\\3s\u0007>tG/\u001a=u\u0011\u001d\t\t\u0001\u0001Q\u0001\nq\fq\u0002\u001d7b]:,'oQ8oi\u0016DH\u000f\t\u0015\u0004\u007f\u0006\u0015\u0001\u0003BA\u0004\u0003\u001bi!!!\u0003\u000b\u0007\u0005-\u0001\"\u0001\u0006b]:|G/\u0019;j_:LA!a\u0004\u0002\n\t\tb+[:jE2,gi\u001c:UKN$\u0018N\\4\t\u0011\u0005M\u0001\u0001\"\u0001\t\u0003+\tQbZ3u%\u0016d')^5mI\u0016\u0014XCAA\f!\rA\u0016\u0011D\u0005\u0004\u00037I&a\u0004$mS:\\'+\u001a7Ck&dG-\u001a:\t\u0011\u0005}\u0001\u0001\"\u0001\t\u0003C\t!c\u0019:fCR,g\t\\5oWBc\u0017M\u001c8feV\u0011\u00111\u0005\t\u00041\u0006\u0015\u0012bAA\u00143\n\u0001b\t\\5oWBc\u0017M\u001c8fe&k\u0007\u000f\u001c\u0015\u0005\u0003;\t)\u0001\u0003\u0005\u0002.\u0001!\t\u0001CA\u0018\u000399W\r\u001e+za\u00164\u0015m\u0019;pef,\"!!\r\u0011\u0007a\u000b\u0019$C\u0002\u00026e\u0013\u0001C\u00127j].$\u0016\u0010]3GC\u000e$xN]=\t\u000f\u0005e\u0002A\"\u0005\u0002<\u0005aq-\u001a;Ue\u0006LG\u000fR3ggV\u0011\u0011Q\b\t\u0006\u0001\u0006}\u00121I\u0005\u0004\u0003\u0003\n%!B!se\u0006L\b\u0007BA#\u0003/\u0002b!a\u0012\u0002P\u0005MSBAA%\u0015\u0011\tY%!\u0014\u0002\tAd\u0017M\u001c\u0006\u00035*IA!!\u0015\u0002J\tY!+\u001a7Ue\u0006LG\u000fR3g!\u0011\t)&a\u0016\r\u0001\u0011a\u0011\u0011LA\u001c\u0003\u0003\u0005\tQ!\u0001\u0002\\\t\u0019q\fJ\u0019\u0012\t\u0005u\u00131\r\t\u0004\u0001\u0006}\u0013bAA1\u0003\n9aj\u001c;iS:<\u0007\u0003BA$\u0003KJA!a\u001a\u0002J\tA!+\u001a7Ue\u0006LG\u000fC\u0004\u0002l\u00011\t\"!\u001c\u0002\u0019\u001d,Go\u00149uS6L'0\u001a:\u0016\u0005\u0005=\u0004\u0003BA9\u0003sj!!a\u001d\u000b\t\u0005U\u0014qO\u0001\t_B$\u0018.\\5{K*\u0019\u00111\n\u0003\n\t\u0005m\u00141\u000f\u0002\n\u001fB$\u0018.\\5{KJDq!a \u0001\t\u0003\t\t)\u0001\bhKR$\u0016M\u00197f\u0007>tg-[4\u0016\u0003\u0011Bq!!\"\u0001\t\u0003\t9)A\bhKR4E.\u001b8l\u0007>tG/\u001a=u+\t\tI\tE\u0002Y\u0003\u0017K1!!$Z\u000511E.\u001b8l\u0007>tG/\u001a=u\u0011!\t\t\n\u0001C\u0001\u0011\u0005M\u0015AC4fi\u0016CXmY#omV\u0011\u0011Q\u0013\t\u0005\u0003/\u000b\u0019+\u0004\u0002\u0002\u001a*!\u00111TAO\u0003-)gN^5s_:lWM\u001c;\u000b\u0007\u001d\nyJC\u0002\u0002\"\"\t\u0011b\u001d;sK\u0006l\u0017N\\4\n\t\u0005\u0015\u0016\u0011\u0014\u0002\u001b'R\u0014X-Y7Fq\u0016\u001cW\u000f^5p]\u0016sg/\u001b:p]6,g\u000e\u001e\u0005\u0007\u0003S\u0003A\u0011A0\u0002\u001f\r\u0014X-\u0019;f\u001d\u0016<\b+\u0019:tKJDq!!,\u0001\t\u0003\ny+A\u0005hKR\u0004\u0016M]:feR\t\u0001\rC\u0004\u00024\u0002!\t%!.\u0002\u0013Q\u0014\u0018M\\:mCR,G\u0003BA\\\u0003C\u0004b!!/\u0002@\u0006\rWBAA^\u0015\r\ti\fF\u0001\u0005kRLG.\u0003\u0003\u0002B\u0006m&\u0001\u0002'jgR\u0004D!!2\u0002VB1\u0011qYAh\u0003'l!!!3\u000b\t\u0005-\u0017QZ\u0001\u0004I\u0006<'BA\u0014\t\u0013\u0011\t\t.!3\u0003\u001dQ\u0013\u0018M\\:g_Jl\u0017\r^5p]B!\u0011QKAk\t1\t9.!-\u0002\u0002\u0003\u0005)\u0011AAm\u0005\ryFEM\t\u0005\u0003;\nY\u000eE\u0002A\u0003;L1!a8B\u0005\r\te.\u001f\u0005\t\u0003G\f\t\f1\u0001\u0002f\u0006\u0001Rn\u001c3jMf|\u0005/\u001a:bi&|gn\u001d\t\u0007\u0003s\u000by,a:\u0011\t\u0005%\u0018q^\u0007\u0003\u0003WT1!!<\u0007\u0003)y\u0007/\u001a:bi&|gn]\u0005\u0005\u0003c\fYOA\bN_\u0012Lg-_(qKJ\fG/[8o\u0011!\t)\u0010\u0001C\u0001\u0011\u0005]\u0018A\u0004;sC:\u001cH.\u0019;f)>\u0014V\r\u001c\u000b\u0005\u0003s\u0014)\u0001\u0005\u0003\u0002|\n\u0005QBAA\u007f\u0015\u0011\ty0!\u0014\u0002\u0007I,G.\u0003\u0003\u0003\u0004\u0005u(a\u0002*fY:{G-\u001a\u0005\t\u0005\u000f\t\u0019\u00101\u0001\u0002h\u0006yQn\u001c3jMf|\u0005/\u001a:bi&|g\u000e\u000b\u0003\u0002t\u0006\u0015\u0001\u0002CA;\u0001\u0011\u0005\u0001B!\u0004\u0015\t\t=!q\u0005\t\u0007\u0005#\u0011\t#!?\u000f\t\tM!Q\u0004\b\u0005\u0005+\u0011Y\"\u0004\u0002\u0003\u0018)\u0019!\u0011\u0004\b\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0015b\u0001B\u0010\u0003\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u0012\u0005K\u00111aU3r\u0015\r\u0011y\"\u0011\u0005\t\u0005S\u0011Y\u00011\u0001\u0003\u0010\u0005A!/\u001a7O_\u0012,7\u000f\u000b\u0003\u0003\f\u0005\u0015\u0001\u0002CA;\u0001\u0011\u0005\u0001Ba\f\u0015\t\u0005e(\u0011\u0007\u0005\t\u0005g\u0011i\u00031\u0001\u0002z\u00069!/\u001a7O_\u0012,\u0007\u0006\u0002B\u0017\u0003\u000bA\u0001B!\u000f\u0001\t\u0003A!1H\u0001\u0019iJ\fgn\u001d7bi\u0016$v.\u0012=fG:{G-Z$sCBDG\u0003\u0002B\u001f\u0005\u001b\u0002BAa\u0010\u0003J5\u0011!\u0011\t\u0006\u0005\u0005\u0007\u0012)%\u0001\u0003fq\u0016\u001c'\u0002\u0002B$\u0003o\nQA\\8eKNLAAa\u0013\u0003B\tiQ\t_3d\u001d>$Wm\u0012:ba\"D\u0001Ba\u0014\u00038\u0001\u0007!qB\u0001\u0012_B$\u0018.\\5{K\u0012\u0014V\r\u001c(pI\u0016\u001c\b\u0006\u0002B\u001c\u0003\u000bAqA!\u0016\u0001\r#\u00119&\u0001\u000ehKR,\u00050Z2O_\u0012,wI]1qQB\u0013xnY3tg>\u00148/\u0006\u0002\u0003ZA1!\u0011\u0003B\u0011\u00057\u0002BA!\u0018\u0003d5\u0011!q\f\u0006\u0005\u0005C\u0012\t%A\u0005qe>\u001cWm]:pe&!!Q\rB0\u0005Y)\u00050Z2O_\u0012,wI]1qQB\u0013xnY3tg>\u0014\bb\u0002B5\u0001\u0019E!1N\u0001\u0010iJ\fgn\u001d7bi\u0016$v\u000e\u00157b]R!!Q\u000eB=!\u0019\tI,a0\u0003pA\"!\u0011\u000fB;!\u0019\t9-a4\u0003tA!\u0011Q\u000bB;\t1\u00119Ha\u001a\u0002\u0002\u0003\u0005)\u0011AAm\u0005\ryF\u0005\u000e\u0005\t\u0005w\u00129\u00071\u0001\u0003>\u0005IQ\r_3d\u000fJ\f\u0007\u000f\u001b\u0005\b\u0005\u007f\u0002A\u0011\u0002BA\u000319W\r\u001e+bE2,7+\u001b8l)\u0019\u0011\u0019I!&\u0003 B)\u0001I!\"\u0003\n&\u0019!qQ!\u0003\r=\u0003H/[8o!\u001d\u0001%1\u0012BH\u00037L1A!$B\u0005\u0019!V\u000f\u001d7feA\u0019aF!%\n\u0007\tMuF\u0001\u000bSKN|GN^3e\u0007\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a\u0005\t\u0005/\u0013i\b1\u0001\u0003\u001a\u0006\u0001rN\u00196fGRLE-\u001a8uS\u001aLWM\u001d\t\u0004]\tm\u0015b\u0001BO_\t\u0001rJ\u00196fGRLE-\u001a8uS\u001aLWM\u001d\u0005\t\u0005C\u0013i\b1\u0001\u0003$\u0006qA-\u001f8b[&\u001cw\n\u001d;j_:\u001c\b\u0003\u0003BS\u0005{\u0013\u0019Ma1\u000f\t\t\u001d&1\u0018\b\u0005\u0005S\u0013IL\u0004\u0003\u0003,\n]f\u0002\u0002BW\u0005ksAAa,\u00034:!!Q\u0003BY\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0004\u0005?!\u0011\u0002\u0002B`\u0005\u0003\u0014AAS'ba*\u0019!q\u0004\u0003\u0011\t\t\u0015'Q\u001a\b\u0005\u0005\u000f\u0014I\rE\u0002\u0003\u0016\u0005K1Aa3B\u0003\u0019\u0001&/\u001a3fM&!!q\u001aBi\u0005\u0019\u0019FO]5oO*\u0019!1Z!\t\u000f\tU\u0007\u0001\"\u0003\u0003X\u0006A\u0012n\u001d'fO\u0006\u001c\u0017pQ8o]\u0016\u001cGo\u001c:PaRLwN\\:\u0015\u000f}\u0012INa7\u0003f\"A!q\u0013Bj\u0001\u0004\u0011I\n\u0003\u0005\u0003^\nM\u0007\u0019\u0001Bp\u00031\u0019\u0017\r^1m_\u001e$\u0016M\u00197f!\rq#\u0011]\u0005\u0004\u0005G|#\u0001D\"bi\u0006dwn\u001a+bE2,\u0007b\u0002Bt\u0005'\u0004\raP\u0001\fSN$V-\u001c9pe\u0006\u0014\u0018\u0010C\u0004\u0003l\u0002!\tE!<\u0002\u0017\u001d,GOS:p]Bc\u0017M\u001c\u000b\u0005\u0005\u0007\u0014y\u000f\u0003\u0005\u0002d\n%\b\u0019AAs\u0011\u001d\u0011\u0019\u0010\u0001C!\u0005k\f\u0011\u0003\u001e:b]Nd\u0017\r^3Kg>t\u0007\u000b\\1o)\u0011\u00119pa\u0001\u0011\r\u0005e\u0016q\u0018B}a\u0011\u0011YPa@\u0011\r\u0005\u001d\u0017q\u001aB\u007f!\u0011\t)Fa@\u0005\u0019\r\u0005!\u0011_A\u0001\u0002\u0003\u0015\t!!7\u0003\u0007}#S\u0007\u0003\u0005\u0004\u0006\tE\b\u0019\u0001Bb\u0003!Q7o\u001c8QY\u0006t\u0007bBB\u0005\u0001\u0011E11B\u0001\u0013GJ,\u0017\r^3TKJ$WmQ8oi\u0016DH/\u0006\u0002\u0004\u000eA!1qBB\u000b\u001b\t\u0019\tB\u0003\u0003\u0004\u0014\t\u0005\u0013!B:fe\u0012,\u0017\u0002BB\f\u0007#\u0011AbU3sI\u0016\u001cuN\u001c;fqRDqaa\u0007\u0001\t\u0013\u0019i\"\u0001\bhKR\u001cE.Y:t\u0019>\fG-\u001a:\u0016\u0005\r}\u0001cA\t\u0004\"%\u001911\u0005\n\u0003\u0017\rc\u0017m]:M_\u0006$WM\u001d\u0005\b\u0007O\u0001A\u0011CB\u0015\u0003\u00012\u0018\r\\5eCR,\u0017I\u001c3Pm\u0016\u0014(/\u001b3f\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\u0003\u0019Dqa!\f\u0001\t#\u0019I#A\u000fdY\u0016\fg.\u001e9J]R,'O\\1m\u0007>tg-[4ve\u0006$\u0018n\u001c8t\u0001")
public abstract class PlannerBase
implements Planner {
    private final Executor executor;
    private final TableConfig config;
    private final FunctionCatalog functionCatalog;
    private final CatalogManager catalogManager;
    private final boolean isStreamingMode;
    private final SqlExprToRexConverterFactory sqlExprToRexConverterFactory;
    private Parser parser;
    private SqlDialect currentDialect;
    @VisibleForTesting
    private final PlannerContext plannerContext;

    public FunctionCatalog functionCatalog() {
        return this.functionCatalog;
    }

    public CatalogManager catalogManager() {
        return this.catalogManager;
    }

    private SqlExprToRexConverterFactory sqlExprToRexConverterFactory() {
        return this.sqlExprToRexConverterFactory;
    }

    private Parser parser() {
        return this.parser;
    }

    private void parser_$eq(Parser x$1) {
        this.parser = x$1;
    }

    private SqlDialect currentDialect() {
        return this.currentDialect;
    }

    private void currentDialect_$eq(SqlDialect x$1) {
        this.currentDialect = x$1;
    }

    public PlannerContext plannerContext() {
        return this.plannerContext;
    }

    public FlinkRelBuilder getRelBuilder() {
        String currentCatalogName = this.catalogManager().getCurrentCatalog();
        String currentDatabase = this.catalogManager().getCurrentDatabase();
        return this.plannerContext().createRelBuilder(currentCatalogName, currentDatabase);
    }

    @VisibleForTesting
    public FlinkPlannerImpl createFlinkPlanner() {
        String currentCatalogName = this.catalogManager().getCurrentCatalog();
        String currentDatabase = this.catalogManager().getCurrentDatabase();
        return this.plannerContext().createFlinkPlanner(currentCatalogName, currentDatabase);
    }

    public FlinkTypeFactory getTypeFactory() {
        return this.plannerContext().getTypeFactory();
    }

    public abstract RelTraitDef<? extends RelTrait>[] getTraitDefs();

    public abstract Optimizer getOptimizer();

    public TableConfig getTableConfig() {
        return this.config;
    }

    public FlinkContext getFlinkContext() {
        return this.plannerContext().getFlinkContext();
    }

    public StreamExecutionEnvironment getExecEnv() {
        return ((ExecutorBase)this.executor).getExecutionEnvironment();
    }

    public Parser createNewParser() {
        scala.collection.immutable.Map parserProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TableConfigOptions.TABLE_SQL_DIALECT.key()), (Object)this.getTableConfig().getSqlDialect().name().toLowerCase())}));
        return ((ParserFactory)ComponentFactoryService.find(ParserFactory.class, (java.util.Map)JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)parserProps))).create(this.catalogManager(), this.plannerContext());
    }

    public Parser getParser() {
        block1: {
            block0: {
                if (this.parser() == null) break block0;
                SqlDialect sqlDialect = this.getTableConfig().getSqlDialect();
                SqlDialect sqlDialect2 = this.currentDialect();
                if (!(sqlDialect == null ? sqlDialect2 != null : !sqlDialect.equals(sqlDialect2))) break block1;
            }
            this.parser_$eq(this.createNewParser());
            this.currentDialect_$eq(this.getTableConfig().getSqlDialect());
        }
        return this.parser();
    }

    public List<Transformation<?>> translate(List<ModifyOperation> modifyOperations) {
        this.validateAndOverrideConfiguration();
        if (modifyOperations.isEmpty()) {
            return JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)List$.MODULE$.empty());
        }
        Buffer relNodes = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(modifyOperations).map((Function1 & Serializable & scala.Serializable)modifyOperation -> this.translateToRel((ModifyOperation)modifyOperation), Buffer$.MODULE$.canBuildFrom());
        Seq<RelNode> optimizedRelNodes = this.optimize((Seq<RelNode>)relNodes);
        ExecNodeGraph execGraph = this.translateToExecNodeGraph(optimizedRelNodes);
        List<Transformation<?>> transformations = this.translateToPlan(execGraph);
        this.cleanupInternalConfigurations();
        return transformations;
    }

    @VisibleForTesting
    public RelNode translateToRel(ModifyOperation modifyOperation) {
        RelNode relNode;
        DataTypeFactory dataTypeFactory = this.catalogManager().getDataTypeFactory();
        ModifyOperation modifyOperation2 = modifyOperation;
        if (modifyOperation2 instanceof UnregisteredSinkModifyOperation) {
            UnregisteredSinkModifyOperation unregisteredSinkModifyOperation = (UnregisteredSinkModifyOperation)modifyOperation2;
            RelNode input = this.getRelBuilder().queryOperation(unregisteredSinkModifyOperation.getChild()).build();
            TableSchema sinkSchema = unregisteredSinkModifyOperation.getSink().getTableSchema();
            RelNode query = DynamicSinkUtils.validateSchemaAndApplyImplicitCast(input, sinkSchema, null, dataTypeFactory, this.getTypeFactory());
            relNode = LogicalLegacySink$.MODULE$.create(query, unregisteredSinkModifyOperation.getSink(), "UnregisteredSink", (CatalogTable)ConnectorCatalogTable.sink((TableSink)unregisteredSinkModifyOperation.getSink(), (!this.isStreamingMode ? 1 : 0) != 0), LogicalLegacySink$.MODULE$.create$default$5());
        } else if (modifyOperation2 instanceof CollectModifyOperation) {
            CollectModifyOperation collectModifyOperation = (CollectModifyOperation)modifyOperation2;
            RelNode input = this.getRelBuilder().queryOperation(modifyOperation.getChild()).build();
            relNode = DynamicSinkUtils.convertCollectToRel(this.getRelBuilder(), input, collectModifyOperation);
        } else if (modifyOperation2 instanceof CatalogSinkModifyOperation) {
            RelNode sinkRel;
            java.util.Map dynamicOptions;
            CatalogSinkModifyOperation catalogSinkModifyOperation = (CatalogSinkModifyOperation)modifyOperation2;
            RelNode input = this.getRelBuilder().queryOperation(modifyOperation.getChild()).build();
            ObjectIdentifier identifier = catalogSinkModifyOperation.getTableIdentifier();
            Option option = this.getTableSink(identifier, dynamicOptions = catalogSinkModifyOperation.getDynamicOptions()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    ResolvedCatalogTable table = (ResolvedCatalogTable)tuple2._1();
                    Object sink = tuple2._2();
                    if (sink instanceof TableSink) {
                        TableSink tableSink = (TableSink)sink;
                        RowType queryLogicalType = FlinkTypeFactory$.MODULE$.toLogicalRowType(input.getRowType());
                        TableSinkUtils$.MODULE$.validateLogicalPhysicalTypesCompatible((CatalogTable)table, tableSink, queryLogicalType);
                        TableSinkUtils$.MODULE$.validateTableSink(catalogSinkModifyOperation, identifier, tableSink, (Seq<String>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(table.getPartitionKeys()));
                        RelNode query = DynamicSinkUtils.validateSchemaAndApplyImplicitCast(input, TableSchemaUtils.getPhysicalSchema((TableSchema)table.getSchema()), catalogSinkModifyOperation.getTableIdentifier(), dataTypeFactory, this.getTypeFactory());
                        ArrayList<RelHint> hints = new ArrayList<RelHint>();
                        Object object = !dynamicOptions.isEmpty() ? BoxesRunTime.boxToBoolean((boolean)hints.add(RelHint.builder("OPTIONS").hintOptions(dynamicOptions).build())) : BoxedUnit.UNIT;
                        return LogicalLegacySink$.MODULE$.create(query, hints, tableSink, identifier.toString(), (CatalogTable)table, (scala.collection.immutable.Map<String, String>)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(catalogSinkModifyOperation.getStaticPartitions()).toMap(Predef$.MODULE$.$conforms()));
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                ResolvedCatalogTable table = (ResolvedCatalogTable)tuple2._1();
                Object sink = tuple2._2();
                if (!(sink instanceof DynamicTableSink)) throw new MatchError((Object)tuple2);
                DynamicTableSink dynamicTableSink = (DynamicTableSink)sink;
                return DynamicSinkUtils.convertSinkToRel(this.getRelBuilder(), input, catalogSinkModifyOperation, dynamicTableSink, table);
            });
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new TableException(new StringBuilder(21).append("Sink ").append(catalogSinkModifyOperation.getTableIdentifier()).append(" does not exists").toString());
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            RelNode relNode2 = sinkRel = (RelNode)some.value();
            relNode = relNode2;
        } else if (modifyOperation2 instanceof ExternalModifyOperation) {
            ExternalModifyOperation externalModifyOperation = (ExternalModifyOperation)modifyOperation2;
            RelNode input = this.getRelBuilder().queryOperation(modifyOperation.getChild()).build();
            relNode = DynamicSinkUtils.convertExternalToRel(this.getRelBuilder(), input, externalModifyOperation);
        } else if (modifyOperation2 instanceof OutputConversionModifyOperation) {
            Tuple2.mcZZ.sp sp2;
            OutputConversionModifyOperation outputConversionModifyOperation = (OutputConversionModifyOperation)modifyOperation2;
            RelNode input = this.getRelBuilder().queryOperation(outputConversionModifyOperation.getChild()).build();
            OutputConversionModifyOperation.UpdateMode updateMode = outputConversionModifyOperation.getUpdateMode();
            if (OutputConversionModifyOperation.UpdateMode.RETRACT.equals(updateMode)) {
                sp2 = new Tuple2.mcZZ.sp(true, true);
            } else if (OutputConversionModifyOperation.UpdateMode.APPEND.equals(updateMode)) {
                sp2 = new Tuple2.mcZZ.sp(false, false);
            } else if (OutputConversionModifyOperation.UpdateMode.UPSERT.equals(updateMode)) {
                sp2 = new Tuple2.mcZZ.sp(false, true);
            } else {
                throw new MatchError((Object)updateMode);
            }
            Tuple2.mcZZ.sp sp3 = sp2;
            if (sp3 == null) {
                throw new MatchError((Object)sp3);
            }
            boolean needUpdateBefore = sp3._1$mcZ$sp();
            boolean withChangeFlag = sp3._2$mcZ$sp();
            Tuple2.mcZZ.sp sp4 = new Tuple2.mcZZ.sp(needUpdateBefore, withChangeFlag);
            Tuple2.mcZZ.sp sp5 = sp4;
            boolean needUpdateBefore2 = sp5._1$mcZ$sp();
            boolean withChangeFlag2 = sp5._2$mcZ$sp();
            TypeInformation typeInfo = LegacyTypeInfoDataTypeConverter.toLegacyTypeInfo((DataType)outputConversionModifyOperation.getType());
            RowType inputLogicalType = FlinkTypeFactory$.MODULE$.toLogicalRowType(input.getRowType());
            TableSchema sinkPhysicalSchema = TableSinkUtils$.MODULE$.inferSinkPhysicalSchema(outputConversionModifyOperation.getType(), inputLogicalType, withChangeFlag2);
            RelNode query = DynamicSinkUtils.validateSchemaAndApplyImplicitCast(input, sinkPhysicalSchema, null, dataTypeFactory, this.getTypeFactory());
            DataStreamTableSink tableSink = new DataStreamTableSink(FlinkTypeFactory$.MODULE$.toTableSchema(query.getRowType()), typeInfo, needUpdateBefore2, withChangeFlag2);
            relNode = LogicalLegacySink$.MODULE$.create(query, tableSink, "DataStreamTableSink", (CatalogTable)ConnectorCatalogTable.sink(tableSink, (!this.isStreamingMode ? 1 : 0) != 0), LogicalLegacySink$.MODULE$.create$default$5());
        } else {
            throw new TableException(new StringBuilder(29).append("Unsupported ModifyOperation: ").append(modifyOperation).toString());
        }
        return relNode;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public Seq<RelNode> optimize(Seq<RelNode> relNodes) {
        void var2_2;
        Seq<RelNode> optimizedRelNodes = this.getOptimizer().optimize(relNodes);
        Predef$.MODULE$.require(optimizedRelNodes.size() == relNodes.size());
        return var2_2;
    }

    @VisibleForTesting
    public RelNode optimize(RelNode relNode) {
        Seq<RelNode> optimizedRelNodes = this.getOptimizer().optimize((Seq<RelNode>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelNode[]{relNode}))));
        Predef$.MODULE$.require(optimizedRelNodes.size() == 1);
        return (RelNode)optimizedRelNodes.head();
    }

    @VisibleForTesting
    public ExecNodeGraph translateToExecNodeGraph(Seq<RelNode> optimizedRelNodes) {
        Seq nonPhysicalRel = (Seq)optimizedRelNodes.filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PlannerBase.$anonfun$translateToExecNodeGraph$1(x$2)));
        if (nonPhysicalRel.nonEmpty()) {
            throw new TableException(new StringBuilder(54).append("The expected optimized plan is FlinkPhysicalRel plan, ").append(new StringBuilder(21).append("actual plan is ").append(nonPhysicalRel.head().getClass().getSimpleName()).append(" plan.").toString()).toString());
        }
        Predef$.MODULE$.require(optimizedRelNodes.forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)PlannerBase.$anonfun$translateToExecNodeGraph$2(x$3))));
        SameRelObjectShuttle shuttle = new SameRelObjectShuttle();
        Seq relsWithoutSameObj = (Seq)optimizedRelNodes.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.accept(shuttle), Seq$.MODULE$.canBuildFrom());
        Seq<RelNode> reusedPlan = SubplanReuser$.MODULE$.reuseDuplicatedSubplan((Seq<RelNode>)relsWithoutSameObj, this.config);
        ExecNodeGraphGenerator generator = new ExecNodeGraphGenerator();
        ExecNodeGraph execGraph = generator.generate(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)reusedPlan.map((Function1 & Serializable & scala.Serializable)x$5 -> (FlinkPhysicalRel)x$5, Seq$.MODULE$.canBuildFrom())));
        ProcessorContext context = new ProcessorContext(this);
        Seq<ExecNodeGraphProcessor> processors = this.getExecNodeGraphProcessors();
        return (ExecNodeGraph)processors.foldLeft((Object)execGraph, (Function2 & Serializable & scala.Serializable)(graph, processor) -> processor.process((ExecNodeGraph)graph, context));
    }

    public abstract Seq<ExecNodeGraphProcessor> getExecNodeGraphProcessors();

    public abstract List<Transformation<?>> translateToPlan(ExecNodeGraph var1);

    private Option<Tuple2<ResolvedCatalogTable, Object>> getTableSink(ObjectIdentifier objectIdentifier, java.util.Map<String, String> dynamicOptions) {
        None$ none$;
        Option optionalLookupResult = JavaScalaConversionUtil$.MODULE$.toScala(this.catalogManager().getTable(objectIdentifier));
        if (optionalLookupResult.isEmpty()) {
            return None$.MODULE$;
        }
        CatalogManager.TableLookupResult lookupResult = (CatalogManager.TableLookupResult)optionalLookupResult.get();
        CatalogBaseTable catalogBaseTable = lookupResult.getTable();
        if (catalogBaseTable instanceof ConnectorCatalogTable) {
            None$ none$2;
            ConnectorCatalogTable connectorCatalogTable = (ConnectorCatalogTable)catalogBaseTable;
            ResolvedCatalogTable resolvedTable = (ResolvedCatalogTable)lookupResult.getResolvedTable();
            Option option = JavaScalaConversionUtil$.MODULE$.toScala(connectorCatalogTable.getTableSink());
            if (option instanceof Some) {
                Some some = (Some)option;
                TableSink sink = (TableSink)some.value();
                none$2 = new Some((Object)new Tuple2((Object)resolvedTable, (Object)sink));
            } else if (None$.MODULE$.equals(option)) {
                none$2 = None$.MODULE$;
            } else {
                throw new MatchError(option);
            }
            none$ = none$2;
        } else if (catalogBaseTable instanceof CatalogTable) {
            Option option;
            ResolvedCatalogTable resolvedTable = (ResolvedCatalogTable)lookupResult.getResolvedTable();
            ResolvedCatalogTable tableToFind = JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(dynamicOptions).nonEmpty() ? resolvedTable.copy(FlinkHints.mergeTableOptions(dynamicOptions, resolvedTable.getOptions())) : resolvedTable;
            Optional catalog = this.catalogManager().getCatalog(objectIdentifier.getCatalogName());
            boolean isTemporary = lookupResult.isTemporary();
            if (this.isLegacyConnectorOptions(objectIdentifier, resolvedTable.getOrigin(), isTemporary)) {
                TableSink tableSink = TableFactoryUtil.findAndCreateTableSink((Catalog)catalog.orElse(null), (ObjectIdentifier)objectIdentifier, (CatalogTable)tableToFind.getOrigin(), (ReadableConfig)this.getTableConfig().getConfiguration(), (boolean)this.isStreamingMode, (boolean)isTemporary);
                option = Option$.MODULE$.apply((Object)new Tuple2((Object)resolvedTable, (Object)tableSink));
            } else {
                DynamicTableSink tableSink = FactoryUtil.createTableSink((Catalog)catalog.orElse(null), (ObjectIdentifier)objectIdentifier, (ResolvedCatalogTable)tableToFind, (ReadableConfig)this.getTableConfig().getConfiguration(), (ClassLoader)this.getClassLoader(), (boolean)isTemporary);
                option = Option$.MODULE$.apply((Object)new Tuple2((Object)resolvedTable, (Object)tableSink));
            }
            none$ = option;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private boolean isLegacyConnectorOptions(ObjectIdentifier objectIdentifier, CatalogTable catalogTable, boolean isTemporary) {
        boolean bl;
        DescriptorProperties properties = new DescriptorProperties(true);
        properties.putProperties(catalogTable.getOptions());
        if (properties.containsKey("connector.type")) {
            bl = true;
        } else {
            Optional catalog = this.catalogManager().getCatalog(objectIdentifier.getCatalogName());
            try {
                TableFactoryUtil.findAndCreateTableSink((Catalog)catalog.orElse(null), (ObjectIdentifier)objectIdentifier, (CatalogTable)catalogTable, (ReadableConfig)this.getTableConfig().getConfiguration(), (boolean)this.isStreamingMode, (boolean)isTemporary);
                bl = true;
            }
            catch (Throwable throwable) {
                bl = false;
            }
        }
        return bl;
    }

    public String getJsonPlan(List<ModifyOperation> modifyOperations) {
        if (!this.isStreamingMode) {
            throw new TableException("Only streaming mode is supported now.");
        }
        this.validateAndOverrideConfiguration();
        Buffer relNodes = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(modifyOperations).map((Function1 & Serializable & scala.Serializable)modifyOperation -> this.translateToRel((ModifyOperation)modifyOperation), Buffer$.MODULE$.canBuildFrom());
        Seq<RelNode> optimizedRelNodes = this.optimize((Seq<RelNode>)relNodes);
        ExecNodeGraph execGraph = this.translateToExecNodeGraph(optimizedRelNodes);
        String jsonPlan = ExecNodeGraph.createJsonPlan(execGraph, this.createSerdeContext());
        this.cleanupInternalConfigurations();
        return jsonPlan;
    }

    /*
     * WARNING - void declaration
     */
    public List<Transformation<?>> translateJsonPlan(String jsonPlan) {
        void var3_3;
        if (!this.isStreamingMode) {
            throw new TableException("Only streaming mode is supported now.");
        }
        this.validateAndOverrideConfiguration();
        ExecNodeGraph execGraph = ExecNodeGraph.createExecNodeGraph(jsonPlan, this.createSerdeContext());
        List<Transformation<?>> transformations = this.translateToPlan(execGraph);
        this.cleanupInternalConfigurations();
        return var3_3;
    }

    public SerdeContext createSerdeContext() {
        FlinkPlannerImpl planner = this.createFlinkPlanner();
        return new SerdeContext((FlinkContext)planner.config().getContext(), this.getClassLoader(), this.plannerContext().getTypeFactory(), planner.operatorTable());
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public void validateAndOverrideConfiguration() {
        block1: {
            Configuration configuration = this.config.getConfiguration();
            if (!((Enum)configuration.get(TableConfigOptions.TABLE_PLANNER)).equals(PlannerType.BLINK)) {
                throw new IllegalArgumentException("Mismatch between configured planner and actual planner. Currently, the 'table.planner' can only be set when instantiating the table environment. Subsequent changes are not supported. Please instantiate a new TableEnvironment if necessary.");
            }
            Long epochTime = Predef$.MODULE$.long2Long(System.currentTimeMillis());
            configuration.set(InternalConfigOptions.TABLE_QUERY_START_EPOCH_TIME, (Object)epochTime);
            Long localTime = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(epochTime) + (long)TimeZone.getTimeZone(this.config.getLocalTimeZone()).getOffset(Predef$.MODULE$.Long2long(epochTime)));
            configuration.set(InternalConfigOptions.TABLE_QUERY_START_LOCAL_TIME, (Object)localTime);
            this.getExecEnv().configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
            int defaultParallelism = this.getTableConfig().getConfiguration().getInteger(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM);
            if (defaultParallelism <= 0) break block1;
            this.getExecEnv().getConfig().setParallelism(defaultParallelism);
        }
    }

    public void cleanupInternalConfigurations() {
        Configuration configuration = this.config.getConfiguration();
        configuration.removeConfig(InternalConfigOptions.TABLE_QUERY_START_EPOCH_TIME);
        configuration.removeConfig(InternalConfigOptions.TABLE_QUERY_START_LOCAL_TIME);
    }

    public static final /* synthetic */ boolean $anonfun$translateToExecNodeGraph$1(RelNode x$2) {
        return x$2 instanceof FlinkPhysicalRel;
    }

    public static final /* synthetic */ boolean $anonfun$translateToExecNodeGraph$2(RelNode x$3) {
        return x$3 instanceof FlinkPhysicalRel;
    }

    public PlannerBase(Executor executor, TableConfig config, FunctionCatalog functionCatalog, CatalogManager catalogManager, boolean isStreamingMode) {
        this.executor = executor;
        this.config = config;
        this.functionCatalog = functionCatalog;
        this.catalogManager = catalogManager;
        this.isStreamingMode = isStreamingMode;
        functionCatalog.setPlannerTypeInferenceUtil(PlannerTypeInferenceUtilImpl.INSTANCE);
        this.sqlExprToRexConverterFactory = new SqlExprToRexConverterFactory(this){
            private final /* synthetic */ PlannerBase $outer;

            public SqlExprToRexConverter create(RelDataType tableRowType) {
                return this.$outer.plannerContext().createSqlExprToRexConverter(tableRowType);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.currentDialect = this.getTableConfig().getSqlDialect();
        this.plannerContext = new PlannerContext(config, functionCatalog, catalogManager, CalciteSchemaBuilder.asRootSchema(new CatalogManagerCalciteSchema(catalogManager, isStreamingMode)), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getTraitDefs())).toList()));
    }
}

