/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.parse;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.command.ResetOperation;
import org.apache.flink.table.planner.parse.AbstractRegexParseStrategy;

public class ResetOperationParseStrategy
extends AbstractRegexParseStrategy {
    static final ResetOperationParseStrategy INSTANCE = new ResetOperationParseStrategy();

    private ResetOperationParseStrategy() {
        super(Pattern.compile("RESET(\\s+(?<key>\\S+)\\s*)?", 34));
    }

    @Override
    public Operation convert(String statement) {
        Matcher matcher = this.pattern.matcher(statement.trim());
        if (!matcher.find()) {
            throw new TableException(String.format("Failed to convert the statement to RESET operation: %s.", statement));
        }
        String key = matcher.group("key");
        return new ResetOperation(key);
    }

    @Override
    public String[] getHints() {
        return new String[]{"RESET"};
    }
}

