/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.batch;

import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.python.PythonFunctionKind;
import org.apache.flink.table.planner.calcite.FlinkRelFactories;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.logical.SessionGroupWindow;
import org.apache.flink.table.planner.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.planner.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalPythonGroupWindowAggregate;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil;
import org.apache.flink.table.planner.plan.utils.PythonUtil;
import org.apache.flink.table.types.DataType;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;

public class BatchPhysicalPythonWindowAggregateRule
extends RelOptRule {
    public static final RelOptRule INSTANCE = new BatchPhysicalPythonWindowAggregateRule();

    private BatchPhysicalPythonWindowAggregateRule() {
        super(BatchPhysicalPythonWindowAggregateRule.operand(FlinkLogicalWindowAggregate.class, BatchPhysicalPythonWindowAggregateRule.operand(RelNode.class, BatchPhysicalPythonWindowAggregateRule.any()), new RelOptRuleOperand[0]), FlinkRelFactories.LOGICAL_BUILDER_WITHOUT_AGG_INPUT_PRUNE(), "BatchPhysicalPythonWindowAggregateRule");
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalWindowAggregate agg = (FlinkLogicalWindowAggregate)call.rel(0);
        List<AggregateCall> aggCalls = agg.getAggCallList();
        boolean existGeneralPythonFunction = aggCalls.stream().anyMatch(x -> PythonUtil.isPythonAggregate(x, PythonFunctionKind.GENERAL));
        boolean existPandasFunction = aggCalls.stream().anyMatch(x -> PythonUtil.isPythonAggregate(x, PythonFunctionKind.PANDAS));
        boolean existJavaFunction = aggCalls.stream().anyMatch(x -> !PythonUtil.isPythonAggregate(x, null));
        if (existPandasFunction || existGeneralPythonFunction) {
            if (existJavaFunction) {
                throw new TableException("Python UDAF and Java/Scala UDAF cannot be used together.");
            }
            if (existPandasFunction && existGeneralPythonFunction) {
                throw new TableException("Pandas UDAF and non-Pandas UDAF cannot be used together.");
            }
            return true;
        }
        return false;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FlinkLogicalWindowAggregate agg = (FlinkLogicalWindowAggregate)call.rel(0);
        RelNode input = agg.getInput();
        LogicalWindow window = agg.getWindow();
        if (!(window instanceof TumblingGroupWindow && AggregateUtil.hasTimeIntervalType(((TumblingGroupWindow)window).size()) || window instanceof SlidingGroupWindow && AggregateUtil.hasTimeIntervalType(((SlidingGroupWindow)window).size()) || window instanceof SessionGroupWindow)) {
            throw new TableException("Window " + window + " is not supported right now.");
        }
        int[] groupSet = agg.getGroupSet().toArray();
        RelTraitSet traitSet = agg.getTraitSet().replace(FlinkConventions.BATCH_PHYSICAL());
        Tuple2<int[], Seq<AggregateCall>> auxGroupSetAndCallsTuple = AggregateUtil.checkAndSplitAggCalls(agg);
        int[] auxGroupSet = (int[])auxGroupSetAndCallsTuple._1;
        Seq aggCallsWithoutAuxGroupCalls = (Seq)auxGroupSetAndCallsTuple._2;
        Tuple3<int[][], DataType[][], UserDefinedFunction[]> aggBufferTypesAndFunctions = AggregateUtil.transformToBatchAggregateFunctions(FlinkTypeFactory.toLogicalRowType(input.getRowType()), (Seq<AggregateCall>)aggCallsWithoutAuxGroupCalls, null);
        UserDefinedFunction[] aggFunctions = (UserDefinedFunction[])aggBufferTypesAndFunctions._3();
        int inputTimeFieldIndex = AggregateUtil.timeFieldIndex(input.getRowType(), call.builder(), window.timeAttribute());
        RelDataType inputTimeFieldType = input.getRowType().getFieldList().get(inputTimeFieldIndex).getType();
        boolean inputTimeIsDate = inputTimeFieldType.getSqlTypeName() == SqlTypeName.DATE;
        RelTraitSet requiredTraitSet = agg.getTraitSet().replace(FlinkConventions.BATCH_PHYSICAL());
        if (groupSet.length != 0) {
            FlinkRelDistribution requiredDistribution = FlinkRelDistribution.hash(groupSet, false);
            requiredTraitSet = requiredTraitSet.replace(requiredDistribution);
        } else {
            requiredTraitSet = requiredTraitSet.replace(FlinkRelDistribution.SINGLETON());
        }
        RelCollation sortCollation = this.createRelCollation(groupSet, inputTimeFieldIndex);
        requiredTraitSet = requiredTraitSet.replace(sortCollation);
        RelNode newInput = RelOptRule.convert(input, requiredTraitSet);
        BatchPhysicalPythonGroupWindowAggregate windowAgg = new BatchPhysicalPythonGroupWindowAggregate(agg.getCluster(), traitSet, newInput, agg.getRowType(), newInput.getRowType(), groupSet, auxGroupSet, (Seq<AggregateCall>)aggCallsWithoutAuxGroupCalls, aggFunctions, window, inputTimeFieldIndex, inputTimeIsDate, agg.getNamedProperties());
        call.transformTo(windowAgg);
    }

    private RelCollation createRelCollation(int[] groupSet, int timeIndex) {
        LinkedList<RelFieldCollation> fields = new LinkedList<RelFieldCollation>();
        for (int value : groupSet) {
            fields.add(FlinkRelOptUtil.ofRelFieldCollation(value));
        }
        fields.add(FlinkRelOptUtil.ofRelFieldCollation(timeIndex));
        return RelCollations.of(fields);
    }
}

