/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.datastream;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.functions.NullByteKeySelector;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.api.StreamTableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.plan.nodes.CommonSort;
import org.apache.flink.table.plan.nodes.CommonSort$class;
import org.apache.flink.table.plan.nodes.FlinkRelNode$class;
import org.apache.flink.table.plan.nodes.datastream.DataStreamRel;
import org.apache.flink.table.plan.nodes.datastream.DataStreamRel$class;
import org.apache.flink.table.plan.schema.RowSchema;
import org.apache.flink.table.runtime.aggregate.IdentityCRowMap;
import org.apache.flink.table.runtime.aggregate.SortUtil$;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.runtime.types.CRowTypeInfo$;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u0001E\u0011a\u0002R1uCN#(/Z1n'>\u0014HO\u0003\u0002\u0004\t\u0005QA-\u0019;bgR\u0014X-Y7\u000b\u0005\u00151\u0011!\u00028pI\u0016\u001c(BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011!\u0002;bE2,'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0005\u000f!!\t\u0019\"$D\u0001\u0015\u0015\t)b#\u0001\u0003d_J,'BA\f\u0019\u0003\r\u0011X\r\u001c\u0006\u000331\tqaY1mG&$X-\u0003\u0002\u001c)\t!1k\u001c:u!\tib$D\u0001\u0005\u0013\tyBA\u0001\u0006D_6lwN\\*peR\u0004\"!\t\u0012\u000e\u0003\tI!a\t\u0002\u0003\u001b\u0011\u000bG/Y*ue\u0016\fWNU3m\u0011!)\u0003A!A!\u0002\u00131\u0013aB2mkN$XM\u001d\t\u0003O%j\u0011\u0001\u000b\u0006\u0003\u000faI!A\u000b\u0015\u0003\u001bI+Gn\u00149u\u00072,8\u000f^3s\u0011!a\u0003A!A!\u0002\u0013i\u0013\u0001\u0003;sC&$8+\u001a;\u0011\u0005\u001dr\u0013BA\u0018)\u0005-\u0011V\r\u001c+sC&$8+\u001a;\t\u0011E\u0002!\u0011!Q\u0001\nI\n\u0011\"\u001b8qkRtu\u000eZ3\u0011\u0005M\"T\"\u0001\f\n\u0005U2\"a\u0002*fY:{G-\u001a\u0005\to\u0001\u0011\t\u0011)A\u0005q\u0005Y\u0011N\u001c9viN\u001b\u0007.Z7b!\tID(D\u0001;\u0015\tYd!\u0001\u0004tG\",W.Y\u0005\u0003{i\u0012\u0011BU8x'\u000eDW-\\1\t\u0011m\u0002!\u0011!Q\u0001\naB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!Q\u0001\u000eg>\u0014HoQ8mY\u0006$\u0018n\u001c8\u0011\u0005M\u0012\u0015BA\"\u0017\u00051\u0011V\r\\\"pY2\fG/[8o\u0011!)\u0005A!A!\u0002\u00131\u0015AC:peR|eMZ:fiB\u0011qIS\u0007\u0002\u0011*\u0011\u0011\nG\u0001\u0004e\u0016D\u0018BA&I\u0005\u001d\u0011V\r\u001f(pI\u0016D\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IAR\u0001\ng>\u0014HOR3uG\"D\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001U\u0001\fI\u0016\u001c8M]5qi&|g\u000e\u0005\u0002R/:\u0011!+V\u0007\u0002'*\tA+A\u0003tG\u0006d\u0017-\u0003\u0002W'\u00061\u0001K]3eK\u001aL!\u0001W-\u0003\rM#(/\u001b8h\u0015\t16\u000bC\u0003\\\u0001\u0011\u0005A,\u0001\u0004=S:LGO\u0010\u000b\u000b;z{\u0006-\u00192dI\u00164\u0007CA\u0011\u0001\u0011\u0015)#\f1\u0001'\u0011\u0015a#\f1\u0001.\u0011\u0015\t$\f1\u00013\u0011\u00159$\f1\u00019\u0011\u0015Y$\f1\u00019\u0011\u0015\u0001%\f1\u0001B\u0011\u0015)%\f1\u0001G\u0011\u0015i%\f1\u0001G\u0011\u0015y%\f1\u0001Q\u0011\u0015A\u0007\u0001\"\u0011j\u00035!WM]5wKJ{w\u000fV=qKR\t!\u000e\u0005\u0002l]6\tAN\u0003\u0002n-\u0005!A/\u001f9f\u0013\tyGNA\u0006SK2$\u0015\r^1UsB,\u0007\"B9\u0001\t\u0003\u0012\u0018\u0001B2paf$bAE:umbT\b\"\u0002\u0017q\u0001\u0004i\u0003\"B;q\u0001\u0004\u0011\u0014!B5oaV$\b\"B<q\u0001\u0004\t\u0015\u0001\u00048fo\u000e{G\u000e\\1uS>t\u0007\"B=q\u0001\u00041\u0015AB8gMN,G\u000fC\u0003|a\u0002\u0007a)A\u0003gKR\u001c\u0007\u000eC\u0003~\u0001\u0011\u0005c0\u0001\u0005u_N#(/\u001b8h)\u0005\u0001\u0006bBA\u0001\u0001\u0011\u0005\u00131A\u0001\rKb\u0004H.Y5o)\u0016\u0014Xn\u001d\u000b\u0005\u0003\u000b\tY\u0001E\u00024\u0003\u000fI1!!\u0003\u0017\u0005%\u0011V\r\\,sSR,'\u000fC\u0004\u0002\u000e}\u0004\r!!\u0002\u0002\u0005A<\bbBA\t\u0001\u0011\u0005\u00131C\u0001\u0010iJ\fgn\u001d7bi\u0016$v\u000e\u00157b]R1\u0011QCA\u001c\u0003\u000b\u0002b!a\u0006\u0002$\u0005\u001dRBAA\r\u0015\r\u0019\u00111\u0004\u0006\u0005\u0003;\ty\"A\u0002ba&T1!!\t\u000b\u0003%\u0019HO]3b[&tw-\u0003\u0003\u0002&\u0005e!A\u0003#bi\u0006\u001cFO]3b[B!\u0011\u0011FA\u001a\u001b\t\tYC\u0003\u0003\u0002.\u0005=\u0012!\u0002;za\u0016\u001c(bAA\u0019\u0011\u00059!/\u001e8uS6,\u0017\u0002BA\u001b\u0003W\u0011Aa\u0011*po\"A\u0011\u0011HA\b\u0001\u0004\tY$\u0001\u0005uC\ndW-\u00128w!\u0011\ti$!\u0011\u000e\u0005\u0005}\"bAA\u000f\u0011%!\u00111IA \u0005Y\u0019FO]3b[R\u000b'\r\\3F]ZL'o\u001c8nK:$\b\u0002CA$\u0003\u001f\u0001\r!!\u0013\u0002\u0017E,XM]=D_:4\u0017n\u001a\t\u0005\u0003{\tY%\u0003\u0003\u0002N\u0005}\"!E*ue\u0016\fW.U;fef\u001cuN\u001c4jO\"9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M\u0013AE2sK\u0006$XmU8siB\u0013xn\u0019+j[\u0016$b!!\u0006\u0002V\u0005e\u0003\u0002CA,\u0003\u001f\u0002\r!!\u0006\u0002\u000f%t\u0007/\u001e;E'\"A\u00111LA(\u0001\u0004\ti&A\u0004fq\u0016\u001c7IZ4\u0011\t\u0005}\u0013qM\u0007\u0003\u0003CRA!a\u0019\u0002f\u000511m\\7n_:T1!!\b\u000b\u0013\u0011\tI'!\u0019\u0003\u001f\u0015CXmY;uS>t7i\u001c8gS\u001eDq!!\u001c\u0001\t\u0003\ty'A\tde\u0016\fG/Z*peR\u0014vn\u001e+j[\u0016$b!!\u0006\u0002r\u0005M\u0004\u0002CA,\u0003W\u0002\r!!\u0006\t\u0011\u0005m\u00131\u000ea\u0001\u0003;\u0002")
public class DataStreamSort
extends Sort
implements CommonSort,
DataStreamRel {
    private final RelOptCluster cluster;
    private final RowSchema inputSchema;
    private final RowSchema schema;
    private final RelCollation sortCollation;
    private final RexNode sortOffset;
    private final RexNode sortFetch;
    private final String description;

    @Override
    public boolean needsUpdatesAsRetraction() {
        return DataStreamRel$class.needsUpdatesAsRetraction(this);
    }

    @Override
    public boolean producesUpdates() {
        return DataStreamRel$class.producesUpdates(this);
    }

    @Override
    public boolean consumesRetractions() {
        return DataStreamRel$class.consumesRetractions(this);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable) {
        return FlinkRelNode$class.getExpressionString(this, expr, inFields, localExprsTable);
    }

    @Override
    public double estimateRowSize(RelDataType rowType) {
        return FlinkRelNode$class.estimateRowSize(this, rowType);
    }

    @Override
    public double estimateDataTypeSize(RelDataType t) {
        return FlinkRelNode$class.estimateDataTypeSize(this, t);
    }

    @Override
    public Order directionToOrder(RelFieldCollation.Direction direction) {
        return CommonSort$class.directionToOrder(this, direction);
    }

    @Override
    public long getFetchLimitEnd(RexNode fetch, RexNode offset) {
        return CommonSort$class.getFetchLimitEnd(this, fetch, offset);
    }

    @Override
    public long getFetchLimitStart(RexNode offset) {
        return CommonSort$class.getFetchLimitStart(this, offset);
    }

    @Override
    public String sortToString(RelDataType rowRelDataType, RelCollation sortCollation, RexNode sortOffset, RexNode sortFetch) {
        return CommonSort$class.sortToString(this, rowRelDataType, sortCollation, sortOffset, sortFetch);
    }

    @Override
    public RelWriter sortExplainTerms(RelWriter pw, RelDataType rowRelDataType, RelCollation sortCollation, RexNode sortOffset, RexNode sortFetch) {
        return CommonSort$class.sortExplainTerms(this, pw, rowRelDataType, sortCollation, sortOffset, sortFetch);
    }

    @Override
    public RelDataType deriveRowType() {
        return this.schema.relDataType();
    }

    @Override
    public Sort copy(RelTraitSet traitSet, RelNode input, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new DataStreamSort(this.cluster, traitSet, input, this.inputSchema, this.schema, newCollation, offset, fetch, this.description);
    }

    @Override
    public String toString() {
        return this.sortToString(this.schema.relDataType(), this.sortCollation, this.sortOffset, this.sortFetch);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return this.sortExplainTerms(pw.input("input", this.getInput()), this.schema.relDataType(), this.sortCollation, this.sortOffset, this.sortFetch);
    }

    @Override
    public DataStream<CRow> translateToPlan(StreamTableEnvironment tableEnv, StreamQueryConfig queryConfig) {
        block9: {
            block12: {
                DataStream<CRow> dataStream;
                block11: {
                    ExecutionConfig execCfg;
                    RelDataType timeType;
                    DataStream<CRow> inputDS;
                    block10: {
                        DataStream<CRow> dataStream2;
                        inputDS = ((DataStreamRel)this.input).translateToPlan(tableEnv, queryConfig);
                        timeType = SortUtil$.MODULE$.getFirstSortField(this.sortCollation, this.schema.relDataType()).getType();
                        RelFieldCollation.Direction direction = SortUtil$.MODULE$.getFirstSortDirection(this.sortCollation);
                        RelFieldCollation.Direction direction2 = RelFieldCollation.Direction.ASCENDING;
                        if (direction != null ? !((Object)((Object)direction)).equals((Object)direction2) : direction2 != null) break block9;
                        execCfg = tableEnv.execEnv().getConfig();
                        RelDataType relDataType = timeType;
                        if (!FlinkTypeFactory$.MODULE$.isProctimeIndicatorType(timeType)) break block10;
                        Tuple2 tuple2 = new Tuple2((Object)this.sortOffset, (Object)this.sortFetch);
                        if (tuple2 != null && tuple2._1() != null && tuple2._2() != null) {
                            throw new TableException("Streaming tables do not support sort with offset and fetch.");
                        }
                        if (tuple2 != null && tuple2._2() != null) {
                            throw new TableException("Streaming tables do not support sort with fetch.");
                        }
                        if (tuple2 != null && tuple2._1() != null) {
                            throw new TableException("Streaming tables do not support sort with offset.");
                        }
                        dataStream = dataStream2 = this.createSortProcTime(inputDS, execCfg);
                        break block11;
                    }
                    if (!FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType(timeType)) break block12;
                    Tuple2 tuple2 = new Tuple2((Object)this.sortOffset, (Object)this.sortFetch);
                    if (tuple2 != null && tuple2._1() != null && tuple2._2() != null) {
                        throw new TableException("Streaming tables do not support sort with offset and fetch");
                    }
                    if (tuple2 != null && tuple2._2() != null) {
                        throw new TableException("Streaming tables do not support sort with fetch");
                    }
                    if (tuple2 != null && tuple2._1() != null) {
                        throw new TableException("Streaming tables do not support sort with offset");
                    }
                    DataStream<CRow> dataStream3 = this.createSortRowTime(inputDS, execCfg);
                    dataStream = dataStream3;
                }
                return dataStream;
            }
            throw new TableException("Primary sort order of a streaming table must be ascending on time.");
        }
        throw new TableException("Primary sort order of a streaming table must be ascending on time.");
    }

    public DataStream<CRow> createSortProcTime(DataStream<CRow> inputDS, ExecutionConfig execCfg) {
        SingleOutputStreamOperator singleOutputStreamOperator;
        CRowTypeInfo returnTypeInfo = CRowTypeInfo$.MODULE$.apply(this.schema.typeInfo());
        if (this.sortCollation.getFieldCollations().size() > 1) {
            ProcessFunction<CRow, CRow> processFunction = SortUtil$.MODULE$.createProcTimeSortFunction(this.sortCollation, this.inputSchema.relDataType(), this.inputSchema.typeInfo(), execCfg);
            singleOutputStreamOperator = inputDS.keyBy((KeySelector)new NullByteKeySelector()).process(processFunction).setParallelism(1).setMaxParallelism(1).returns((TypeInformation)returnTypeInfo);
        } else {
            singleOutputStreamOperator = inputDS.map((MapFunction)new IdentityCRowMap()).setParallelism(1).setMaxParallelism(1).returns((TypeInformation)returnTypeInfo);
        }
        return singleOutputStreamOperator;
    }

    public DataStream<CRow> createSortRowTime(DataStream<CRow> inputDS, ExecutionConfig execCfg) {
        CRowTypeInfo returnTypeInfo = CRowTypeInfo$.MODULE$.apply(this.schema.typeInfo());
        ProcessFunction<CRow, CRow> processFunction = SortUtil$.MODULE$.createRowTimeSortFunction(this.sortCollation, this.inputSchema.relDataType(), this.inputSchema.typeInfo(), execCfg);
        return inputDS.keyBy((KeySelector)new NullByteKeySelector()).process(processFunction).setParallelism(1).setMaxParallelism(1).returns((TypeInformation)returnTypeInfo);
    }

    public DataStreamSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode inputNode, RowSchema inputSchema, RowSchema schema2, RelCollation sortCollation, RexNode sortOffset, RexNode sortFetch, String description) {
        this.cluster = cluster;
        this.inputSchema = inputSchema;
        this.schema = schema2;
        this.sortCollation = sortCollation;
        this.sortOffset = sortOffset;
        this.sortFetch = sortFetch;
        this.description = description;
        super(cluster, traitSet, inputNode, sortCollation, sortOffset, sortFetch);
        CommonSort$class.$init$(this);
        FlinkRelNode$class.$init$(this);
        DataStreamRel$class.$init$(this);
    }
}

