/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.shaded.org.apache.commons.configuration.beanutils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.table.shaded.org.apache.commons.beanutils.BeanUtils;
import org.apache.flink.table.shaded.org.apache.commons.beanutils.PropertyUtils;
import org.apache.flink.table.shaded.org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.flink.table.shaded.org.apache.commons.configuration.beanutils.BeanDeclaration;
import org.apache.flink.table.shaded.org.apache.commons.configuration.beanutils.BeanFactory;
import org.apache.flink.table.shaded.org.apache.commons.configuration.beanutils.DefaultBeanFactory;
import org.apache.flink.table.shaded.org.apache.commons.lang.ClassUtils;

public final class BeanHelper {
    private static Map beanFactories = Collections.synchronizedMap(new HashMap());
    private static BeanFactory defaultBeanFactory = DefaultBeanFactory.INSTANCE;

    private BeanHelper() {
    }

    public static void registerBeanFactory(String name, BeanFactory factory) {
        if (name == null) {
            throw new IllegalArgumentException("Name for bean factory must not be null!");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Bean factory must not be null!");
        }
        beanFactories.put(name, factory);
    }

    public static BeanFactory deregisterBeanFactory(String name) {
        return (BeanFactory)beanFactories.remove(name);
    }

    public static Set registeredFactoryNames() {
        return beanFactories.keySet();
    }

    public static BeanFactory getDefaultBeanFactory() {
        return defaultBeanFactory;
    }

    public static void setDefaultBeanFactory(BeanFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Default bean factory must not be null!");
        }
        defaultBeanFactory = factory;
    }

    public static void initBean(Object bean, BeanDeclaration data) throws ConfigurationRuntimeException {
        block4: {
            Map nestedBeans;
            block5: {
                BeanHelper.initBeanProperties(bean, data);
                nestedBeans = data.getNestedBeanDeclarations();
                if (nestedBeans == null) break block4;
                if (!(bean instanceof Collection)) break block5;
                Collection coll = (Collection)bean;
                if (nestedBeans.size() != 1) break block4;
                Map.Entry e2 = nestedBeans.entrySet().iterator().next();
                String propName = (String)e2.getKey();
                Class defaultClass = BeanHelper.getDefaultClass(bean, propName);
                if (e2.getValue() instanceof List) {
                    Iterator iter = ((List)e2.getValue()).iterator();
                    while (iter.hasNext()) {
                        coll.add(BeanHelper.createBean((BeanDeclaration)iter.next(), defaultClass));
                    }
                } else {
                    BeanDeclaration decl = (BeanDeclaration)e2.getValue();
                    coll.add(BeanHelper.createBean(decl, defaultClass));
                }
                break block4;
            }
            Iterator it = nestedBeans.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e3 = it.next();
                String propName = (String)e3.getKey();
                Class defaultClass = BeanHelper.getDefaultClass(bean, propName);
                BeanHelper.initProperty(bean, propName, BeanHelper.createBean((BeanDeclaration)e3.getValue(), defaultClass));
            }
        }
    }

    public static void initBeanProperties(Object bean, BeanDeclaration data) throws ConfigurationRuntimeException {
        Map properties2 = data.getBeanProperties();
        if (properties2 != null) {
            Iterator it = properties2.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e2 = it.next();
                String propName = (String)e2.getKey();
                BeanHelper.initProperty(bean, propName, e2.getValue());
            }
        }
    }

    private static Class getDefaultClass(Object bean, String propName) {
        try {
            PropertyDescriptor desc = PropertyUtils.getPropertyDescriptor((Object)bean, (String)propName);
            if (desc == null) {
                return null;
            }
            return desc.getPropertyType();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static void initProperty(Object bean, String propName, Object value) throws ConfigurationRuntimeException {
        if (!PropertyUtils.isWriteable((Object)bean, (String)propName)) {
            throw new ConfigurationRuntimeException("Property " + propName + " cannot be set on " + bean.getClass().getName());
        }
        try {
            BeanUtils.setProperty((Object)bean, (String)propName, (Object)value);
        }
        catch (IllegalAccessException iaex) {
            throw new ConfigurationRuntimeException(iaex);
        }
        catch (InvocationTargetException itex) {
            throw new ConfigurationRuntimeException(itex);
        }
    }

    public static void setProperty(Object bean, String propName, Object value) {
        if (PropertyUtils.isWriteable((Object)bean, (String)propName)) {
            BeanHelper.initProperty(bean, propName, value);
        }
    }

    public static Object createBean(BeanDeclaration data, Class defaultClass, Object param) throws ConfigurationRuntimeException {
        if (data == null) {
            throw new IllegalArgumentException("Bean declaration must not be null!");
        }
        BeanFactory factory = BeanHelper.fetchBeanFactory(data);
        try {
            return factory.createBean(BeanHelper.fetchBeanClass(data, defaultClass, factory), data, param);
        }
        catch (Exception ex) {
            throw new ConfigurationRuntimeException(ex);
        }
    }

    public static Object createBean(BeanDeclaration data, Class defaultClass) throws ConfigurationRuntimeException {
        return BeanHelper.createBean(data, defaultClass, null);
    }

    public static Object createBean(BeanDeclaration data) throws ConfigurationRuntimeException {
        return BeanHelper.createBean(data, null);
    }

    static Class loadClass(String name, Class callingClass) throws ClassNotFoundException {
        return ClassUtils.getClass(name);
    }

    private static Class fetchBeanClass(BeanDeclaration data, Class defaultClass, BeanFactory factory) throws ConfigurationRuntimeException {
        String clsName = data.getBeanClassName();
        if (clsName != null) {
            try {
                return BeanHelper.loadClass(clsName, factory.getClass());
            }
            catch (ClassNotFoundException cex) {
                throw new ConfigurationRuntimeException(cex);
            }
        }
        if (defaultClass != null) {
            return defaultClass;
        }
        Class clazz = factory.getDefaultBeanClass();
        if (clazz == null) {
            throw new ConfigurationRuntimeException("Bean class is not specified!");
        }
        return clazz;
    }

    private static BeanFactory fetchBeanFactory(BeanDeclaration data) throws ConfigurationRuntimeException {
        String factoryName = data.getBeanFactoryName();
        if (factoryName != null) {
            BeanFactory factory = (BeanFactory)beanFactories.get(factoryName);
            if (factory == null) {
                throw new ConfigurationRuntimeException("Unknown bean factory: " + factoryName);
            }
            return factory;
        }
        return BeanHelper.getDefaultBeanFactory();
    }
}

