/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.descriptors.ConnectorDescriptorValidator$;
import org.apache.flink.table.descriptors.CsvValidator;
import org.apache.flink.table.descriptors.CsvValidator$;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.DescriptorProperties$;
import org.apache.flink.table.descriptors.FileSystemValidator;
import org.apache.flink.table.descriptors.FileSystemValidator$;
import org.apache.flink.table.descriptors.FormatDescriptorValidator$;
import org.apache.flink.table.descriptors.SchemaValidator;
import org.apache.flink.table.descriptors.SchemaValidator$;
import org.apache.flink.table.sources.CsvTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.TableSourceFactory;
import org.apache.flink.types.Row;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t3A!\u0001\u0002\u0001\u001b\t)2i\u001d<UC\ndWmU8ve\u000e,g)Y2u_JL(BA\u0002\u0005\u0003\u001d\u0019x.\u001e:dKNT!!\u0002\u0004\u0002\u000bQ\f'\r\\3\u000b\u0005\u001dA\u0011!\u00024mS:\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007cA\u000b\u001715\t!!\u0003\u0002\u0018\u0005\t\u0011B+\u00192mKN{WO]2f\r\u0006\u001cGo\u001c:z!\tIB$D\u0001\u001b\u0015\tYb!A\u0003usB,7/\u0003\u0002\u001e5\t\u0019!k\\<\t\u000b}\u0001A\u0011\u0001\u0011\u0002\rqJg.\u001b;?)\u0005\t\u0003CA\u000b\u0001\u0011\u0015\u0019\u0003\u0001\"\u0011%\u0003=\u0011X-];je\u0016$7i\u001c8uKb$H#A\u0013\u0011\t\u0019ZS&L\u0007\u0002O)\u0011\u0001&K\u0001\u0005kRLGNC\u0001+\u0003\u0011Q\u0017M^1\n\u00051:#aA'baB\u0011a&\r\b\u0003\u001f=J!\u0001\r\t\u0002\rA\u0013X\rZ3g\u0013\t\u00114G\u0001\u0004TiJLgn\u001a\u0006\u0003aAAQ!\u000e\u0001\u0005BY\n1c];qa>\u0014H/\u001a3Qe>\u0004XM\u001d;jKN$\u0012a\u000e\t\u0004Maj\u0013BA\u001d(\u0005\u0011a\u0015n\u001d;\t\u000bm\u0002A\u0011\t\u001f\u0002\r\r\u0014X-\u0019;f)\ti\u0004\tE\u0002\u0016}aI!a\u0010\u0002\u0003\u0017Q\u000b'\r\\3T_V\u00148-\u001a\u0005\u0006\u0003j\u0002\r!J\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\b")
public class CsvTableSourceFactory
implements TableSourceFactory<Row> {
    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, String> requiredContext() {
        void var1_1;
        HashMap<String, String> context = new HashMap<String, String>();
        context.put(ConnectorDescriptorValidator$.MODULE$.CONNECTOR_TYPE(), FileSystemValidator$.MODULE$.CONNECTOR_TYPE_VALUE());
        context.put(FormatDescriptorValidator$.MODULE$.FORMAT_TYPE(), CsvValidator$.MODULE$.FORMAT_TYPE_VALUE());
        context.put(ConnectorDescriptorValidator$.MODULE$.CONNECTOR_PROPERTY_VERSION(), "1");
        context.put(FormatDescriptorValidator$.MODULE$.FORMAT_PROPERTY_VERSION(), "1");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> supportedProperties() {
        void var1_1;
        ArrayList<String> properties2 = new ArrayList<String>();
        properties2.add(FileSystemValidator$.MODULE$.CONNECTOR_PATH());
        properties2.add(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".#.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CsvValidator$.MODULE$.FORMAT_FIELDS(), DescriptorProperties$.MODULE$.TYPE()})));
        properties2.add(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".#.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CsvValidator$.MODULE$.FORMAT_FIELDS(), DescriptorProperties$.MODULE$.NAME()})));
        properties2.add(CsvValidator$.MODULE$.FORMAT_FIELD_DELIMITER());
        properties2.add(CsvValidator$.MODULE$.FORMAT_LINE_DELIMITER());
        properties2.add(CsvValidator$.MODULE$.FORMAT_QUOTE_CHARACTER());
        properties2.add(CsvValidator$.MODULE$.FORMAT_COMMENT_PREFIX());
        properties2.add(CsvValidator$.MODULE$.FORMAT_IGNORE_FIRST_LINE());
        properties2.add(CsvValidator$.MODULE$.FORMAT_IGNORE_PARSE_ERRORS());
        properties2.add(FileSystemValidator$.MODULE$.CONNECTOR_PATH());
        properties2.add(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".#.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SchemaValidator$.MODULE$.SCHEMA(), DescriptorProperties$.MODULE$.TYPE()})));
        properties2.add(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".#.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SchemaValidator$.MODULE$.SCHEMA(), DescriptorProperties$.MODULE$.NAME()})));
        return var1_1;
    }

    @Override
    public TableSource<Row> create(Map<String, String> properties2) {
        DescriptorProperties params = new DescriptorProperties(DescriptorProperties$.MODULE$.$lessinit$greater$default$1());
        params.putProperties(properties2);
        new FileSystemValidator().validate(params);
        new CsvValidator().validate(params);
        new SchemaValidator(SchemaValidator$.MODULE$.$lessinit$greater$default$1()).validate(params);
        CsvTableSource.Builder csvTableSourceBuilder = new CsvTableSource.Builder();
        TableSchema formatSchema = params.getTableSchema(CsvValidator$.MODULE$.FORMAT_FIELDS());
        TableSchema tableSchema2 = params.getTableSchema(SchemaValidator$.MODULE$.SCHEMA());
        if (formatSchema.equals(tableSchema2)) {
            DescriptorProperties$.MODULE$.toScala(params.getOptionalString(FileSystemValidator$.MODULE$.CONNECTOR_PATH())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(String path) {
                    return this.csvTableSourceBuilder$1.path(path);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            DescriptorProperties$.MODULE$.toScala(params.getOptionalString(CsvValidator$.MODULE$.FORMAT_FIELD_DELIMITER())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(String delim) {
                    return this.csvTableSourceBuilder$1.fieldDelimiter(delim);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            DescriptorProperties$.MODULE$.toScala(params.getOptionalString(CsvValidator$.MODULE$.FORMAT_LINE_DELIMITER())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(String delim) {
                    return this.csvTableSourceBuilder$1.lineDelimiter(delim);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])formatSchema.getColumnNames()).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])formatSchema.getTypes()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(Tuple2<String, TypeInformation<?>> x0$1) {
                    Tuple2<String, TypeInformation<?>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        TypeInformation tpe = (TypeInformation)tuple2._2();
                        CsvTableSource.Builder builder = this.csvTableSourceBuilder$1.field(name, tpe);
                        return builder;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            DescriptorProperties$.MODULE$.toScala(params.getOptionalCharacter(CsvValidator$.MODULE$.FORMAT_QUOTE_CHARACTER())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(Character quote) {
                    return this.csvTableSourceBuilder$1.quoteCharacter(quote);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            DescriptorProperties$.MODULE$.toScala(params.getOptionalString(CsvValidator$.MODULE$.FORMAT_COMMENT_PREFIX())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(String prefix) {
                    return this.csvTableSourceBuilder$1.commentPrefix(prefix);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            DescriptorProperties$.MODULE$.toScala(params.getOptionalBoolean(CsvValidator$.MODULE$.FORMAT_IGNORE_FIRST_LINE())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final Object apply(Boolean flag) {
                    return Predef$.MODULE$.Boolean2boolean(flag) ? this.csvTableSourceBuilder$1.ignoreFirstLine() : BoxedUnit.UNIT;
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            DescriptorProperties$.MODULE$.toScala(params.getOptionalBoolean(CsvValidator$.MODULE$.FORMAT_IGNORE_PARSE_ERRORS())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final Object apply(Boolean flag) {
                    return Predef$.MODULE$.Boolean2boolean(flag) ? this.csvTableSourceBuilder$1.ignoreParseErrors() : BoxedUnit.UNIT;
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            return csvTableSourceBuilder.build();
        }
        throw new TableException("Encodings that differ from the schema are not supported yet for CsvTableSources.");
    }
}

