/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources;

import java.sql.Timestamp;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.table.api.TableException$;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.ValidationException$;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.expressions.Cast;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ResolvedFieldReference;
import org.apache.flink.table.sources.DefinedFieldMapping;
import org.apache.flink.table.sources.DefinedProctimeAttribute;
import org.apache.flink.table.sources.DefinedRowtimeAttributes;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.tsextractors.TimestampExtractor;
import org.apache.flink.table.typeutils.TimeIndicatorTypeInfo;
import org.apache.flink.table.typeutils.TimeIndicatorTypeInfo$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class TableSourceUtil$ {
    public static final TableSourceUtil$ MODULE$;

    static {
        new TableSourceUtil$();
    }

    public boolean hasRowtimeAttribute(TableSource<?> tableSource) {
        return Predef$.MODULE$.refArrayOps((Object[])this.org$apache$flink$table$sources$TableSourceUtil$$getRowtimeAttributes(tableSource)).nonEmpty();
    }

    public boolean hasProctimeAttribute(TableSource<?> tableSource) {
        return this.org$apache$flink$table$sources$TableSourceUtil$$getProctimeAttribute(tableSource).nonEmpty();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateTableSource(TableSource<?> tableSource) {
        DefinedProctimeAttribute definedProctimeAttribute;
        TableSchema schema2 = tableSource.getTableSchema();
        String[] tableFieldNames = schema2.getColumnNames();
        TypeInformation<?>[] tableFieldTypes = schema2.getTypes();
        String[] rowtimeAttributes = this.org$apache$flink$table$sources$TableSourceUtil$$getRowtimeAttributes(tableSource);
        Option<String> proctimeAttribute = this.org$apache$flink$table$sources$TableSourceUtil$$getProctimeAttribute(tableSource);
        IntRef mappedFieldCnt = IntRef.create((int)0);
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])tableFieldTypes).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])tableFieldNames), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(tableSource, rowtimeAttributes, proctimeAttribute, mappedFieldCnt){
            public static final long serialVersionUID = 0L;
            private final TableSource tableSource$4;
            private final String[] rowtimeAttributes$1;
            private final Option proctimeAttribute$1;
            private final IntRef mappedFieldCnt$1;

            /*
             * WARNING - void declaration
             */
            public final void apply(Tuple2<TypeInformation<?>, String> x0$1) {
                Tuple2<TypeInformation<?>, String> tuple2;
                block8: {
                    Tuple3<String, Object, TypeInformation<?>> tuple3;
                    block9: {
                        void var22_24;
                        void var23_25;
                        TypeInformation typeInformation;
                        String name;
                        block10: {
                            block6: {
                                TypeInformation tpe;
                                Tuple2 tuple22;
                                block7: {
                                    block5: {
                                        tuple2 = x0$1;
                                        if (tuple2 == null) break block5;
                                        TypeInformation t = (TypeInformation)tuple2._1();
                                        String name2 = (String)tuple2._2();
                                        if (!(t instanceof SqlTimeTypeInfo)) break block5;
                                        SqlTimeTypeInfo sqlTimeTypeInfo = (SqlTimeTypeInfo)t;
                                        if (name2 == null) break block5;
                                        String string = name2;
                                        Class clazz = sqlTimeTypeInfo.getTypeClass();
                                        Class<Timestamp> clazz2 = Timestamp.class;
                                        if ((clazz != null ? !clazz.equals(clazz2) : clazz2 != null) || !this.proctimeAttribute$1.contains((Object)string)) break block5;
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block6;
                                    }
                                    if (tuple2 == null) break block7;
                                    TypeInformation t = (TypeInformation)tuple2._1();
                                    String name3 = (String)tuple2._2();
                                    if (!(t instanceof SqlTimeTypeInfo)) break block7;
                                    SqlTimeTypeInfo sqlTimeTypeInfo = (SqlTimeTypeInfo)t;
                                    if (name3 == null) break block7;
                                    String string = name3;
                                    Class clazz = sqlTimeTypeInfo.getTypeClass();
                                    Class<Timestamp> clazz3 = Timestamp.class;
                                    if ((clazz != null ? !clazz.equals(clazz3) : clazz3 != null) || !Predef$.MODULE$.refArrayOps((Object[])this.rowtimeAttributes$1).contains((Object)string)) break block7;
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block6;
                                }
                                if (tuple2 == null) break block8;
                                TypeInformation t = (TypeInformation)tuple2._1();
                                name = (String)tuple2._2();
                                if (!(t instanceof TypeInformation)) break block8;
                                typeInformation = t;
                                if (TableSourceUtil$.MODULE$.org$apache$flink$table$sources$TableSourceUtil$$getProctimeAttribute(this.tableSource$4).contains((Object)name)) {
                                    throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing time field '", "' has invalid type ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, typeInformation}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing time attributes must be of type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Types$.MODULE$.SQL_TIMESTAMP()}))).toString());
                                }
                                if (Predef$.MODULE$.refArrayOps((Object[])TableSourceUtil$.MODULE$.org$apache$flink$table$sources$TableSourceUtil$$getRowtimeAttributes(this.tableSource$4)).contains((Object)name)) {
                                    throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rowtime field '", "' has invalid type ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, typeInformation}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rowtime attributes must be of type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Types$.MODULE$.SQL_TIMESTAMP()}))).toString());
                                }
                                tuple3 = TableSourceUtil$.MODULE$.org$apache$flink$table$sources$TableSourceUtil$$resolveInputField(name, this.tableSource$4);
                                if (tuple3 == null) break block9;
                                String physicalName = (String)tuple3._1();
                                TypeInformation tpe2 = (TypeInformation)tuple3._3();
                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)physicalName, (Object)tpe2);
                                String physicalName2 = (String)tuple23._1();
                                TypeInformation typeInformation2 = tpe = (TypeInformation)tuple23._2();
                                TypeInformation typeInformation3 = typeInformation;
                                if (typeInformation2 != null ? !typeInformation2.equals(typeInformation3) : typeInformation3 != null) break block10;
                                ++this.mappedFieldCnt$1.elem;
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            return;
                        }
                        throw ValidationException$.MODULE$.apply(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Type ", " of table field '", "' does not "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeInformation, name}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"match with type ", " of the field '", "' of the TableSource return type."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var23_25, var22_24}))).toString());
                    }
                    throw new MatchError(tuple3);
                }
                throw new MatchError(tuple2);
            }
            {
                this.tableSource$4 = tableSource$4;
                this.rowtimeAttributes$1 = rowtimeAttributes$1;
                this.proctimeAttribute$1 = proctimeAttribute$1;
                this.mappedFieldCnt$1 = mappedFieldCnt$1;
            }
        });
        if (!(tableSource.getReturnType() instanceof CompositeType) && mappedFieldCnt.elem > 1) {
            throw ValidationException$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"More than one table field matched to atomic input type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableSource.getReturnType()})));
        }
        TableSource<?> tableSource2 = tableSource;
        if (tableSource2 instanceof DefinedRowtimeAttributes) {
            BoxedUnit boxedUnit;
            DefinedRowtimeAttributes definedRowtimeAttributes = (DefinedRowtimeAttributes)((Object)tableSource2);
            List<RowtimeAttributeDescriptor> descriptors = definedRowtimeAttributes.getRowtimeAttributeDescriptors();
            if (descriptors.size() > 1) {
                throw ValidationException$.MODULE$.apply(new StringBuilder().append((Object)"Currently, only a single rowtime attribute is supported. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please remove all but one RowtimeAttributeDescriptor."})).s((Seq)Nil$.MODULE$)).toString());
            }
            if (descriptors.size() == 1) {
                RowtimeAttributeDescriptor descriptor = descriptors.get(0);
                String rowtimeAttribute = descriptor.getAttributeName();
                int rowtimeIdx = Predef$.MODULE$.refArrayOps((Object[])schema2.getColumnNames()).indexOf((Object)rowtimeAttribute);
                if (rowtimeIdx < 0) {
                    throw ValidationException$.MODULE$.apply(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found a RowtimeAttributeDescriptor for field "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' but field '", "' does not exist in table."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowtimeAttribute, rowtimeAttribute}))).toString());
                }
                TypeInformation<?> typeInformation = schema2.getTypes()[rowtimeIdx];
                TypeInformation<Timestamp> typeInformation2 = Types$.MODULE$.SQL_TIMESTAMP();
                if (typeInformation != null ? !typeInformation.equals(typeInformation2) : typeInformation2 != null) void var12_12;
                throw ValidationException$.MODULE$.apply(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found a RowtimeAttributeDescriptor for field "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' but field '", "' is not of type TIMESTAMP."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var12_12, var12_12}))).toString());
                String[] extractorInputFields = descriptor.getTimestampExtractor().getArgumentFields();
                TypeInformation[] physicalTypes = (TypeInformation[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$flink$table$sources$TableSourceUtil$$resolveInputFields(extractorInputFields, tableSource)).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final TypeInformation<?> apply(Tuple3<String, Object, TypeInformation<?>> x$2) {
                        return (TypeInformation)x$2._3();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TypeInformation.class)));
                descriptor.getTimestampExtractor().validateArgumentFields(physicalTypes);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        TableSource<?> tableSource3 = tableSource;
        if (tableSource3 instanceof DefinedProctimeAttribute && (definedProctimeAttribute = (DefinedProctimeAttribute)((Object)tableSource3)).getProctimeAttribute() != null) {
            String proctimeAttribute2 = definedProctimeAttribute.getProctimeAttribute();
            int proctimeIdx = Predef$.MODULE$.refArrayOps((Object[])schema2.getColumnNames()).indexOf((Object)proctimeAttribute2);
            if (proctimeIdx < 0) {
                throw ValidationException$.MODULE$.apply(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found a RowtimeAttributeDescriptor for field "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' but field '", "' does not exist in table."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{proctimeAttribute2, proctimeAttribute2}))).toString());
            }
            TypeInformation<?> typeInformation = schema2.getTypes()[proctimeIdx];
            TypeInformation<Timestamp> typeInformation3 = Types$.MODULE$.SQL_TIMESTAMP();
            if (typeInformation != null ? !typeInformation.equals(typeInformation3) : typeInformation3 != null) throw ValidationException$.MODULE$.apply(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found a RowtimeAttributeDescriptor for field "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' but field '", "' is not of type TIMESTAMP."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{proctimeAttribute2, proctimeAttribute2}))).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        if (!proctimeAttribute.isDefined() || !Predef$.MODULE$.refArrayOps((Object[])rowtimeAttributes).contains(proctimeAttribute.get())) return;
        throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Field '", "' must not be "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{proctimeAttribute.get()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"processing time and rowtime attribute at the same time."})).s((Seq)Nil$.MODULE$)).toString());
    }

    public int[] computeIndexMapping(TableSource<?> tableSource, boolean isStreamTable, Option<int[]> selectedFields) {
        TypeInformation<?>[] typeInformationArray;
        String[] tableFieldNames;
        String[] stringArray;
        TypeInformation<?> inputType = tableSource.getReturnType();
        TableSchema tableSchema2 = tableSource.getTableSchema();
        if (selectedFields.isDefined()) {
            String[] names = tableSchema2.getColumnNames();
            stringArray = (String[])Predef$.MODULE$.intArrayOps((int[])selectedFields.get()).map((Function1)new Serializable(names){
                public static final long serialVersionUID = 0L;
                private final String[] names$1;

                public final String apply(int x$3) {
                    return this.names$1[x$3];
                }
                {
                    this.names$1 = names$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        } else {
            stringArray = tableFieldNames = tableSchema2.getColumnNames();
        }
        if (selectedFields.isDefined()) {
            TypeInformation<?>[] types = tableSchema2.getTypes();
            typeInformationArray = (TypeInformation[])Predef$.MODULE$.intArrayOps((int[])selectedFields.get()).map((Function1)new Serializable(types){
                public static final long serialVersionUID = 0L;
                private final TypeInformation[] types$1;

                public final TypeInformation<?> apply(int x$4) {
                    return this.types$1[x$4];
                }
                {
                    this.types$1 = types$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TypeInformation.class)));
        } else {
            typeInformationArray = tableSchema2.getTypes();
        }
        TypeInformation<?>[] tableFieldTypes = typeInformationArray;
        String[] rowtimeAttributes = this.org$apache$flink$table$sources$TableSourceUtil$$getRowtimeAttributes(tableSource);
        Option<String> proctimeAttributes = this.org$apache$flink$table$sources$TableSourceUtil$$getProctimeAttribute(tableSource);
        int[] mapping = (int[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])tableFieldTypes).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])tableFieldNames), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(tableSource, isStreamTable, rowtimeAttributes, proctimeAttributes){
            public static final long serialVersionUID = 0L;
            private final TableSource tableSource$1;
            private final boolean isStreamTable$1;
            private final String[] rowtimeAttributes$2;
            private final Option proctimeAttributes$1;

            /*
             * WARNING - void declaration
             */
            public final int apply(Tuple2<TypeInformation<?>, String> x0$2) {
                Tuple2<TypeInformation<?>, String> tuple2;
                block8: {
                    Tuple3<String, Object, TypeInformation<?>> tuple3;
                    block9: {
                        void var23_23;
                        void var25_25;
                        TypeInformation typeInformation;
                        String name;
                        block10: {
                            int n;
                            block6: {
                                TypeInformation tpe;
                                Tuple3 tuple32;
                                block7: {
                                    block5: {
                                        tuple2 = x0$2;
                                        if (tuple2 == null) break block5;
                                        TypeInformation t = (TypeInformation)tuple2._1();
                                        String name2 = (String)tuple2._2();
                                        if (!(t instanceof SqlTimeTypeInfo)) break block5;
                                        SqlTimeTypeInfo sqlTimeTypeInfo = (SqlTimeTypeInfo)t;
                                        if (name2 == null) break block5;
                                        String string = name2;
                                        Class clazz = sqlTimeTypeInfo.getTypeClass();
                                        Class<Timestamp> clazz2 = Timestamp.class;
                                        if ((clazz != null ? !clazz.equals(clazz2) : clazz2 != null) || !this.proctimeAttributes$1.contains((Object)string)) break block5;
                                        n = this.isStreamTable$1 ? TimeIndicatorTypeInfo$.MODULE$.PROCTIME_STREAM_MARKER() : TimeIndicatorTypeInfo$.MODULE$.PROCTIME_BATCH_MARKER();
                                        break block6;
                                    }
                                    if (tuple2 == null) break block7;
                                    TypeInformation t = (TypeInformation)tuple2._1();
                                    String name3 = (String)tuple2._2();
                                    if (!(t instanceof SqlTimeTypeInfo)) break block7;
                                    SqlTimeTypeInfo sqlTimeTypeInfo = (SqlTimeTypeInfo)t;
                                    if (name3 == null) break block7;
                                    String string = name3;
                                    Class clazz = sqlTimeTypeInfo.getTypeClass();
                                    Class<Timestamp> clazz3 = Timestamp.class;
                                    if ((clazz != null ? !clazz.equals(clazz3) : clazz3 != null) || !Predef$.MODULE$.refArrayOps((Object[])this.rowtimeAttributes$2).contains((Object)string)) break block7;
                                    n = this.isStreamTable$1 ? TimeIndicatorTypeInfo$.MODULE$.ROWTIME_STREAM_MARKER() : TimeIndicatorTypeInfo$.MODULE$.ROWTIME_BATCH_MARKER();
                                    break block6;
                                }
                                if (tuple2 == null) break block8;
                                TypeInformation t = (TypeInformation)tuple2._1();
                                name = (String)tuple2._2();
                                if (!(t instanceof TypeInformation)) break block8;
                                typeInformation = t;
                                if (TableSourceUtil$.MODULE$.org$apache$flink$table$sources$TableSourceUtil$$getProctimeAttribute(this.tableSource$1).contains((Object)name)) {
                                    throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing time field '", "' has invalid type ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, typeInformation}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing time attributes must be of type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Types$.MODULE$.SQL_TIMESTAMP()}))).toString());
                                }
                                if (Predef$.MODULE$.refArrayOps((Object[])TableSourceUtil$.MODULE$.org$apache$flink$table$sources$TableSourceUtil$$getRowtimeAttributes(this.tableSource$1)).contains((Object)name)) {
                                    throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rowtime field '", "' has invalid type ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, typeInformation}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rowtime attributes must be of type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Types$.MODULE$.SQL_TIMESTAMP()}))).toString());
                                }
                                tuple3 = TableSourceUtil$.MODULE$.org$apache$flink$table$sources$TableSourceUtil$$resolveInputField(name, this.tableSource$1);
                                if (tuple3 == null) break block9;
                                String physicalName = (String)tuple3._1();
                                int idx = BoxesRunTime.unboxToInt((Object)tuple3._2());
                                TypeInformation tpe2 = (TypeInformation)tuple3._3();
                                Tuple3 tuple33 = tuple32 = new Tuple3((Object)physicalName, (Object)BoxesRunTime.boxToInteger((int)idx), (Object)tpe2);
                                String physicalName2 = (String)tuple33._1();
                                int idx2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
                                TypeInformation typeInformation2 = tpe = (TypeInformation)tuple33._3();
                                TypeInformation typeInformation3 = typeInformation;
                                if (typeInformation2 != null ? !typeInformation2.equals(typeInformation3) : typeInformation3 != null) break block10;
                                n = idx2;
                            }
                            return n;
                        }
                        throw ValidationException$.MODULE$.apply(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Type ", " of table field '", "' does not "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeInformation, name}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"match with type ", " of the field '", "' of the TableSource return type."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var25_25, var23_23}))).toString());
                    }
                    throw new MatchError(tuple3);
                }
                throw new MatchError(tuple2);
            }
            {
                this.tableSource$1 = tableSource$1;
                this.isStreamTable$1 = isStreamTable$1;
                this.rowtimeAttributes$2 = rowtimeAttributes$2;
                this.proctimeAttributes$1 = proctimeAttributes$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        if (!(inputType instanceof CompositeType) && Predef$.MODULE$.intArrayOps(mapping).count((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int x$6) {
                return this.apply$mcZI$sp(x$6);
            }

            public boolean apply$mcZI$sp(int x$6) {
                return x$6 >= 0;
            }
        }) > 1) {
            throw ValidationException$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"More than one table field matched to atomic input type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputType})));
        }
        return mapping;
    }

    public RelDataType getRelDataType(TableSource<?> tableSource, Option<int[]> selectedFields, boolean streaming, FlinkTypeFactory typeFactory) {
        Tuple2 tuple2;
        String[] fieldNames = tableSource.getTableSchema().getColumnNames();
        ObjectRef fieldTypes = ObjectRef.create(tableSource.getTableSchema().getTypes());
        if (streaming) {
            String[] rowtimeAttributes = this.org$apache$flink$table$sources$TableSourceUtil$$getRowtimeAttributes(tableSource);
            Option<String> proctimeAttributes = this.org$apache$flink$table$sources$TableSourceUtil$$getProctimeAttribute(tableSource);
            Predef$.MODULE$.refArrayOps((Object[])rowtimeAttributes).foreach((Function1)new Serializable(fieldNames, fieldTypes){
                public static final long serialVersionUID = 0L;
                private final String[] fieldNames$1;
                private final ObjectRef fieldTypes$1;

                public final void apply(String rowtimeField) {
                    int idx = Predef$.MODULE$.refArrayOps((Object[])this.fieldNames$1).indexOf((Object)rowtimeField);
                    this.fieldTypes$1.elem = (TypeInformation[])Predef$.MODULE$.refArrayOps((Object[])((TypeInformation[])this.fieldTypes$1.elem)).patch(idx, (GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimeIndicatorTypeInfo[]{TimeIndicatorTypeInfo$.MODULE$.ROWTIME_INDICATOR()})), 1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TypeInformation.class)));
                }
                {
                    this.fieldNames$1 = fieldNames$1;
                    this.fieldTypes$1 = fieldTypes$1;
                }
            });
            proctimeAttributes.foreach((Function1)new Serializable(fieldNames, fieldTypes){
                public static final long serialVersionUID = 0L;
                private final String[] fieldNames$1;
                private final ObjectRef fieldTypes$1;

                public final void apply(String proctimeField) {
                    int idx = Predef$.MODULE$.refArrayOps((Object[])this.fieldNames$1).indexOf((Object)proctimeField);
                    this.fieldTypes$1.elem = (TypeInformation[])Predef$.MODULE$.refArrayOps((Object[])((TypeInformation[])this.fieldTypes$1.elem)).patch(idx, (GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimeIndicatorTypeInfo[]{TimeIndicatorTypeInfo$.MODULE$.PROCTIME_INDICATOR()})), 1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TypeInformation.class)));
                }
                {
                    this.fieldNames$1 = fieldNames$1;
                    this.fieldTypes$1 = fieldTypes$1;
                }
            });
        }
        Tuple2 tuple22 = tuple2 = selectedFields.isDefined() ? new Tuple2(Predef$.MODULE$.intArrayOps((int[])selectedFields.get()).map((Function1)new Serializable(fieldNames){
            public static final long serialVersionUID = 0L;
            private final String[] fieldNames$1;

            public final String apply(int x$7) {
                return this.fieldNames$1[x$7];
            }
            {
                this.fieldNames$1 = fieldNames$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), Predef$.MODULE$.intArrayOps((int[])selectedFields.get()).map((Function1)new Serializable(fieldTypes){
            public static final long serialVersionUID = 0L;
            private final ObjectRef fieldTypes$1;

            public final TypeInformation<?> apply(int x$8) {
                return ((TypeInformation[])this.fieldTypes$1.elem)[x$8];
            }
            {
                this.fieldTypes$1 = fieldTypes$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TypeInformation.class)))) : new Tuple2((Object)fieldNames, (Object)((TypeInformation[])fieldTypes.elem));
        if (tuple2 != null) {
            Tuple2 tuple23;
            String[] selectedFieldNames = (String[])tuple2._1();
            TypeInformation[] selectedFieldTypes = (TypeInformation[])tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)selectedFieldNames, (Object)selectedFieldTypes);
            String[] selectedFieldNames2 = (String[])tuple24._1();
            TypeInformation[] selectedFieldTypes2 = (TypeInformation[])tuple24._2();
            return typeFactory.buildLogicalRowType((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])selectedFieldNames2), (Seq<TypeInformation<?>>)Predef$.MODULE$.wrapRefArray((Object[])selectedFieldTypes2));
        }
        throw new MatchError((Object)tuple2);
    }

    public Option<RowtimeAttributeDescriptor> getRowtimeAttributeDescriptor(TableSource<?> tableSource, Option<int[]> selectedFields) {
        None$ none$;
        TableSource<?> tableSource2 = tableSource;
        if (tableSource2 instanceof DefinedRowtimeAttributes) {
            Object object;
            DefinedRowtimeAttributes definedRowtimeAttributes = (DefinedRowtimeAttributes)((Object)tableSource2);
            List<RowtimeAttributeDescriptor> descriptors = definedRowtimeAttributes.getRowtimeAttributeDescriptors();
            if (descriptors.size() == 0) {
                object = None$.MODULE$;
            } else {
                if (descriptors.size() > 1) {
                    throw ValidationException$.MODULE$.apply("Table with has more than a single rowtime attribute..");
                }
                if (selectedFields.isEmpty()) {
                    object = new Some((Object)descriptors.get(0));
                } else {
                    RowtimeAttributeDescriptor descriptor = descriptors.get(0);
                    int fieldIdx = Predef$.MODULE$.refArrayOps((Object[])tableSource.getTableSchema().getColumnNames()).indexOf((Object)descriptor.getAttributeName());
                    object = Predef$.MODULE$.intArrayOps((int[])selectedFields.get()).contains((Object)BoxesRunTime.boxToInteger((int)fieldIdx)) ? new Some((Object)descriptor) : None$.MODULE$;
                }
            }
            none$ = object;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<RexNode> getRowtimeExtractionExpression(TableSource<?> tableSource, Option<int[]> selectedFields, RelOptCluster cluster, RelBuilder relBuilder, TypeInformation<?> resultType2) {
        FlinkTypeFactory typeFactory = (FlinkTypeFactory)cluster.getTypeFactory();
        Option<RowtimeAttributeDescriptor> rowtimeDesc = this.getRowtimeAttributeDescriptor(tableSource, selectedFields);
        return rowtimeDesc.map((Function1)new Serializable(tableSource, cluster, relBuilder, resultType2, typeFactory){
            public static final long serialVersionUID = 0L;
            private final TableSource tableSource$2;
            private final RelOptCluster cluster$1;
            private final RelBuilder relBuilder$1;
            private final TypeInformation resultType$1;
            private final FlinkTypeFactory typeFactory$1;

            public final RexNode apply(RowtimeAttributeDescriptor r) {
                ResolvedFieldReference[] resolvedFieldReferenceArray;
                TimestampExtractor tsExtractor = r.getTimestampExtractor();
                if (Predef$.MODULE$.refArrayOps((Object[])tsExtractor.getArgumentFields()).nonEmpty()) {
                    Tuple3<String, Object, TypeInformation<?>>[] resolvedFields = TableSourceUtil$.MODULE$.org$apache$flink$table$sources$TableSourceUtil$$resolveInputFields(tsExtractor.getArgumentFields(), this.tableSource$2);
                    this.relBuilder$1.push(TableSourceUtil$.MODULE$.org$apache$flink$table$sources$TableSourceUtil$$createSchemaRelNode$1(resolvedFields, this.cluster$1, this.typeFactory$1));
                    resolvedFieldReferenceArray = (ResolvedFieldReference[])Predef$.MODULE$.refArrayOps((Object[])resolvedFields).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ResolvedFieldReference apply(Tuple3<String, Object, TypeInformation<?>> f) {
                            return new ResolvedFieldReference((String)f._1(), (TypeInformation)f._3());
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ResolvedFieldReference.class)));
                } else {
                    resolvedFieldReferenceArray = new ResolvedFieldReference[]{};
                }
                ResolvedFieldReference[] fieldAccesses = resolvedFieldReferenceArray;
                Expression expression2 = tsExtractor.getExpression(fieldAccesses);
                RexNode rexExpression = new Cast(expression2, this.resultType$1).toRexNode(this.relBuilder$1);
                this.relBuilder$1.clear();
                return rexExpression;
            }
            {
                this.tableSource$2 = tableSource$2;
                this.cluster$1 = cluster$1;
                this.relBuilder$1 = relBuilder$1;
                this.resultType$1 = resultType$1;
                this.typeFactory$1 = typeFactory$1;
            }
        });
    }

    public int[] getPhysicalIndexes(TableSource<?> tableSource, int[] logicalFieldIndexes) {
        int[] fieldMapping = this.computeIndexMapping(tableSource, true, (Option<int[]>)None$.MODULE$);
        return (int[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps(logicalFieldIndexes).map((Function1)new Serializable(fieldMapping){
            public static final long serialVersionUID = 0L;
            private final int[] fieldMapping$1;

            public final int apply(int x$12) {
                return this.apply$mcII$sp(x$12);
            }

            public int apply$mcII$sp(int x$12) {
                return this.fieldMapping$1[x$12];
            }
            {
                this.fieldMapping$1 = fieldMapping$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).flatMap((Function1)new Serializable(tableSource){
            public static final long serialVersionUID = 0L;
            private final TableSource tableSource$3;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final SeqLike<Object, Object> apply(int x0$3) {
                int n = x0$3;
                if (TimeIndicatorTypeInfo$.MODULE$.PROCTIME_STREAM_MARKER() == n) {
                    return (SeqLike)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                }
                if (TimeIndicatorTypeInfo$.MODULE$.ROWTIME_STREAM_MARKER() != n) return (SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{n}));
                Option<RowtimeAttributeDescriptor> rowtimeAttributeDescriptor = TableSourceUtil$.MODULE$.getRowtimeAttributeDescriptor(this.tableSource$3, (Option<int[]>)None$.MODULE$);
                if (!rowtimeAttributeDescriptor.isDefined()) throw TableException$.MODULE$.apply("Computed field mapping includes a rowtime marker but the TableSource does not provide a RowtimeAttributeDescriptor. This is a bug and should be reported.");
                String[] accessedFields = ((RowtimeAttributeDescriptor)rowtimeAttributeDescriptor.get()).getTimestampExtractor().getArgumentFields();
                return Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])TableSourceUtil$.MODULE$.org$apache$flink$table$sources$TableSourceUtil$$resolveInputFields(accessedFields, this.tableSource$3)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Tuple3<String, Object, TypeInformation<?>> x$13) {
                        return BoxesRunTime.unboxToInt((Object)x$13._2());
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
            }
            {
                this.tableSource$3 = tableSource$3;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
    }

    public String[] org$apache$flink$table$sources$TableSourceUtil$$getRowtimeAttributes(TableSource<?> tableSource) {
        String[] stringArray;
        TableSource<?> tableSource2 = tableSource;
        if (tableSource2 instanceof DefinedRowtimeAttributes) {
            DefinedRowtimeAttributes definedRowtimeAttributes = (DefinedRowtimeAttributes)((Object)tableSource2);
            stringArray = (String[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(definedRowtimeAttributes.getRowtimeAttributeDescriptors()).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(RowtimeAttributeDescriptor x$14) {
                    return x$14.getAttributeName();
                }
            }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        } else {
            stringArray = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        }
        return stringArray;
    }

    public Option<String> org$apache$flink$table$sources$TableSourceUtil$$getProctimeAttribute(TableSource<?> tableSource) {
        DefinedProctimeAttribute definedProctimeAttribute;
        TableSource<?> tableSource2 = tableSource;
        Object object = tableSource2 instanceof DefinedProctimeAttribute && (definedProctimeAttribute = (DefinedProctimeAttribute)((Object)tableSource2)).getProctimeAttribute() != null ? new Some((Object)definedProctimeAttribute.getProctimeAttribute()) : None$.MODULE$;
        return object;
    }

    public Tuple3<String, Object, TypeInformation<?>> org$apache$flink$table$sources$TableSourceUtil$$resolveInputField(String fieldName2, TableSource<?> tableSource) {
        Tuple3 tuple3;
        DefinedFieldMapping definedFieldMapping;
        TypeInformation<?> returnType = tableSource.getReturnType();
        TableSource<?> tableSource2 = tableSource;
        if (tableSource2 instanceof DefinedFieldMapping && (definedFieldMapping = (DefinedFieldMapping)((Object)tableSource2)).getFieldMapping() != null) {
            String resolvedFieldName = definedFieldMapping.getFieldMapping().get(fieldName2);
            if (resolvedFieldName == null) {
                throw ValidationException$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Field '", "' could not be resolved by the field mapping."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fieldName2})));
            }
            tuple3 = this.lookupField$1(resolvedFieldName, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table field '", "' was resolved to TableSource return type field "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fieldName2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "', but field '", "' was not found in the return "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resolvedFieldName, resolvedFieldName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"type ", " of the TableSource. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{returnType}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please verify the field mapping of the TableSource."})).s((Seq)Nil$.MODULE$)).toString(), returnType);
        } else {
            tuple3 = this.lookupField$1(fieldName2, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table field '", "' was not found in the return type ", " of the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fieldName2, returnType}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TableSource."})).s((Seq)Nil$.MODULE$)).toString(), returnType);
        }
        return tuple3;
    }

    public Tuple3<String, Object, TypeInformation<?>>[] org$apache$flink$table$sources$TableSourceUtil$$resolveInputFields(String[] fieldNames, TableSource<?> tableSource) {
        return (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])fieldNames).map((Function1)new Serializable(tableSource){
            public static final long serialVersionUID = 0L;
            private final TableSource tableSource$5;

            public final Tuple3<String, Object, TypeInformation<?>> apply(String x$15) {
                return TableSourceUtil$.MODULE$.org$apache$flink$table$sources$TableSourceUtil$$resolveInputField(x$15, this.tableSource$5);
            }
            {
                this.tableSource$5 = tableSource$5;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
    }

    public final RelNode org$apache$flink$table$sources$TableSourceUtil$$createSchemaRelNode$1(Tuple3[] fields, RelOptCluster cluster$1, FlinkTypeFactory typeFactory$1) {
        int maxIdx = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])fields).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple3<String, Object, TypeInformation<?>> x$10) {
                return BoxesRunTime.unboxToInt((Object)x$10._2());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).max((Ordering)Ordering.Int$.MODULE$));
        Map idxMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])((Tuple2[])Predef$.MODULE$.refArrayOps((Object[])fields).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<String, TypeInformation<Object>>> apply(Tuple3<String, Object, TypeInformation<?>> f) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(f._2()), (Object)new Tuple2(f._1(), f._3()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))));
        Tuple2 tuple2 = ((GenericTraversableTemplate)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), maxIdx).map((Function1)new Serializable(idxMap){
            public static final long serialVersionUID = 0L;
            private final Map idxMap$1;

            public final Tuple2<String, TypeInformation<?>> apply(int i) {
                return (Tuple2)this.idxMap$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)i), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, TypeInformation<Byte>> apply() {
                        return new Tuple2((Object)"", Types$.MODULE$.BYTE());
                    }
                });
            }
            {
                this.idxMap$1 = idxMap$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            IndexedSeq physicalFields = (IndexedSeq)tuple2._1();
            IndexedSeq physicalTypes = (IndexedSeq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)physicalFields, (Object)physicalTypes);
            IndexedSeq physicalFields2 = (IndexedSeq)tuple23._1();
            IndexedSeq physicalTypes2 = (IndexedSeq)tuple23._2();
            RelDataType physicalSchema = typeFactory$1.buildLogicalRowType((Seq<String>)physicalFields2, (Seq<TypeInformation<?>>)physicalTypes2);
            return LogicalValues.create(cluster$1, physicalSchema, ImmutableList.<ImmutableList<RexLiteral>>of());
        }
        throw new MatchError((Object)tuple2);
    }

    private final Tuple3 lookupField$1(String fieldName2, String failMsg, TypeInformation returnType$1) {
        TypeInformation typeInformation;
        block6: {
            Tuple3 tuple3;
            block5: {
                block4: {
                    typeInformation = returnType$1;
                    if (!(typeInformation instanceof CompositeType)) break block4;
                    CompositeType compositeType = (CompositeType)typeInformation;
                    int idx = compositeType.getFieldIndex(fieldName2);
                    if (idx < 0) {
                        throw ValidationException$.MODULE$.apply(failMsg);
                    }
                    tuple3 = new Tuple3((Object)fieldName2, (Object)BoxesRunTime.boxToInteger((int)idx), (Object)compositeType.getTypeAt(idx));
                    break block5;
                }
                if (typeInformation == null) break block6;
                TypeInformation typeInformation2 = typeInformation;
                tuple3 = new Tuple3((Object)fieldName2, (Object)BoxesRunTime.boxToInteger((int)0), (Object)typeInformation2);
            }
            return tuple3;
        }
        throw new MatchError((Object)typeInformation);
    }

    private TableSourceUtil$() {
        MODULE$ = this;
    }
}

