/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.util.Objects;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.yarn.YarnFlinkResourceManager;
import org.apache.hadoop.yarn.api.records.Container;

public class RegisteredYarnWorkerNode
implements ResourceIDRetrievable {
    private final Container yarnContainer;
    private final ResourceID resourceID;

    public RegisteredYarnWorkerNode(Container yarnContainer) {
        this.yarnContainer = Objects.requireNonNull(yarnContainer);
        this.resourceID = YarnFlinkResourceManager.extractResourceID(yarnContainer);
    }

    public Container yarnContainer() {
        return this.yarnContainer;
    }

    public String toString() {
        return "RegisteredYarnWorkerNode{yarnContainer=" + this.yarnContainer + '}';
    }

    public ResourceID getResourceID() {
        return this.resourceID;
    }
}

