/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.util.Objects;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.yarn.YarnFlinkResourceManager;
import org.apache.hadoop.yarn.api.records.Container;

public class YarnContainerInLaunch
implements ResourceIDRetrievable {
    private final Container container;
    private final long timestamp;
    private final ResourceID resourceID;

    public YarnContainerInLaunch(Container container) {
        this(container, System.currentTimeMillis());
    }

    public YarnContainerInLaunch(Container container, long timestamp) {
        this.container = Objects.requireNonNull(container);
        this.timestamp = timestamp;
        this.resourceID = YarnFlinkResourceManager.extractResourceID(container);
    }

    public Container container() {
        return this.container;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "ContainerInLaunch @ " + this.timestamp + ": " + this.container;
    }

    public ResourceID getResourceID() {
        return this.resourceID;
    }
}

