/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import akka.actor.ActorRef;
import java.util.List;
import org.apache.flink.runtime.clusterframework.messages.FatalErrorOccurred;
import org.apache.flink.yarn.messages.ContainersAllocated;
import org.apache.flink.yarn.messages.ContainersComplete;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;

public class YarnResourceManagerCallbackHandler
implements AMRMClientAsync.CallbackHandler {
    private ActorRef yarnFrameworkMaster;
    private float currentProgress;

    public YarnResourceManagerCallbackHandler() {
        this(null);
    }

    public YarnResourceManagerCallbackHandler(ActorRef yarnFrameworkMaster) {
        this.yarnFrameworkMaster = yarnFrameworkMaster;
    }

    public void initialize(ActorRef yarnFrameworkMaster) {
        this.yarnFrameworkMaster = yarnFrameworkMaster;
    }

    public void setCurrentProgress(float progress) {
        progress = Math.max(progress, 0.0f);
        this.currentProgress = progress = Math.min(progress, 1.0f);
    }

    public float getProgress() {
        return this.currentProgress;
    }

    public void onContainersCompleted(List<ContainerStatus> list) {
        if (this.yarnFrameworkMaster != null) {
            this.yarnFrameworkMaster.tell((Object)new ContainersComplete(list), ActorRef.noSender());
        }
    }

    public void onContainersAllocated(List<Container> containers) {
        if (this.yarnFrameworkMaster != null) {
            this.yarnFrameworkMaster.tell((Object)new ContainersAllocated(containers), ActorRef.noSender());
        }
    }

    public void onShutdownRequest() {
    }

    public void onNodesUpdated(List<NodeReport> list) {
    }

    public void onError(Throwable error) {
        if (this.yarnFrameworkMaster != null) {
            this.yarnFrameworkMaster.tell((Object)new FatalErrorOccurred("Connection to YARN Resource Manager failed", error), ActorRef.noSender());
        }
    }
}

