/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.clusterframework.BootstrapTools;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.util.Preconditions;
import org.apache.flink.yarn.YarnTaskManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnTaskManagerRunnerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(YarnTaskManagerRunnerFactory.class);

    public static Runner create(String[] args, Class<? extends YarnTaskManager> taskManager, Map<String, String> envs) throws IOException {
        Configuration configuration;
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)"YARN TaskManager", (String[])args);
        SignalHandler.register((Logger)LOG);
        JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG);
        try {
            configuration = TaskManager.parseArgsAndLoadConfig((String[])args);
        }
        catch (Throwable t) {
            LOG.error(t.getMessage(), t);
            System.exit(TaskManager.STARTUP_FAILURE_RETURN_CODE());
            return null;
        }
        String yarnClientUsername = envs.get("HADOOP_USER_NAME");
        String localDirs = envs.get(ApplicationConstants.Environment.LOCAL_DIRS.key());
        LOG.info("Current working/local Directory: {}", (Object)localDirs);
        String currDir = envs.get(ApplicationConstants.Environment.PWD.key());
        LOG.info("Current working Directory: {}", (Object)currDir);
        String remoteKeytabPrincipal = envs.get("_KEYTAB_PRINCIPAL");
        LOG.info("TM: remoteKeytabPrincipal obtained {}", (Object)remoteKeytabPrincipal);
        BootstrapTools.updateTmpDirectoriesInConfiguration((Configuration)configuration, (String)localDirs);
        configuration.setBoolean(AkkaOptions.JVM_EXIT_ON_FATAL_ERROR, true);
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        LOG.info("YARN daemon is running as: {} Yarn client user obtainer: {}", (Object)currentUser.getShortUserName(), (Object)yarnClientUsername);
        String containerID = (String)Preconditions.checkNotNull((Object)envs.get("_FLINK_CONTAINER_ID"));
        ResourceID resourceId = new ResourceID(containerID);
        LOG.info("ResourceID assigned for this container: {}", (Object)resourceId);
        File f = new File(currDir, "krb5.keytab");
        if (remoteKeytabPrincipal != null && f.exists()) {
            configuration.setString(SecurityOptions.KERBEROS_LOGIN_KEYTAB, f.getAbsolutePath());
            configuration.setString(SecurityOptions.KERBEROS_LOGIN_PRINCIPAL, remoteKeytabPrincipal);
        }
        try {
            SecurityConfiguration sc = new SecurityConfiguration(configuration);
            SecurityUtils.install((SecurityConfiguration)sc);
            return new Runner(configuration, resourceId, taskManager);
        }
        catch (Exception e) {
            LOG.error("Exception occurred while building Task Manager runner", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static class Runner
    implements Callable<Object> {
        private final Configuration configuration;
        private final ResourceID resourceId;
        private final Class<? extends YarnTaskManager> taskManager;

        Runner(Configuration configuration, ResourceID resourceId, Class<? extends YarnTaskManager> taskManager) {
            this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
            this.resourceId = (ResourceID)Preconditions.checkNotNull((Object)resourceId);
            this.taskManager = (Class)Preconditions.checkNotNull(taskManager);
        }

        @Override
        public Object call() throws Exception {
            try {
                TaskManager.selectNetworkInterfaceAndRunTaskManager((Configuration)this.configuration, (ResourceID)this.resourceId, this.taskManager);
            }
            catch (Throwable t) {
                LOG.error("Error while starting the TaskManager", t);
                System.exit(TaskManager.STARTUP_FAILURE_RETURN_CODE());
            }
            return null;
        }

        @VisibleForTesting
        Configuration getConfiguration() {
            return this.configuration;
        }

        @VisibleForTesting
        ResourceID getResourceId() {
            return this.resourceId;
        }
    }
}

